/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.asset;

import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LayoutAssetRenderer
extends BaseJSPAssetRenderer<Layout> {
    private final Layout _layout;

    public LayoutAssetRenderer(Layout layout) {
        this._layout = layout;
    }

    public Layout getAssetObject() {
        return this._layout;
    }

    public String getClassName() {
        return Layout.class.getName();
    }

    public long getClassPK() {
        return this._layout.getLayoutId();
    }

    public long getGroupId() {
        return this._layout.getGroupId();
    }

    public String getJspPath(HttpServletRequest request, String template) {
        if (template.equals("full_content")) {
            return "/asset/" + template + ".jsp";
        }
        return null;
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        Locale locale = this.getLocale(portletRequest);
        StringBundler sb = new StringBundler(4);
        sb.append("<strong>");
        sb.append(LanguageUtil.get((Locale)locale, (String)"page"));
        sb.append(":</strong> ");
        sb.append(this._layout.getHTMLTitle(locale));
        return sb.toString();
    }

    public String getTitle(Locale locale) {
        return this._layout.getHTMLTitle(locale);
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Layout layout = LayoutLocalServiceUtil.getLayout((long)this._layout.getPlid());
            return PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay);
        }
        catch (Exception e) {
            return "";
        }
    }

    public long getUserId() {
        return this._layout.getUserId();
    }

    public String getUserName() {
        return this._layout.getUserName();
    }

    public String getUuid() {
        return null;
    }

    public boolean include(HttpServletRequest request, HttpServletResponse response, String template) throws Exception {
        request.setAttribute("LAYOUT", (Object)this._layout);
        return super.include(request, response, template);
    }
}

