/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.portlet;

import com.liferay.application.list.GroupProvider;
import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.mobile.device.rules.model.MDRAction;
import com.liferay.mobile.device.rules.model.MDRRuleGroupInstance;
import com.liferay.mobile.device.rules.service.MDRActionLocalService;
import com.liferay.mobile.device.rules.service.MDRActionService;
import com.liferay.mobile.device.rules.service.MDRRuleGroupInstanceLocalService;
import com.liferay.mobile.device.rules.service.MDRRuleGroupInstanceService;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.exception.ImageTypeException;
import com.liferay.portal.kernel.exception.LayoutFriendlyURLException;
import com.liferay.portal.kernel.exception.LayoutFriendlyURLsException;
import com.liferay.portal.kernel.exception.LayoutNameException;
import com.liferay.portal.kernel.exception.LayoutParentLayoutIdException;
import com.liferay.portal.kernel.exception.LayoutSetVirtualHostException;
import com.liferay.portal.kernel.exception.LayoutTypeException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredLayoutException;
import com.liferay.portal.kernel.exception.SitemapChangeFrequencyException;
import com.liferay.portal.kernel.exception.SitemapIncludeException;
import com.liferay.portal.kernel.exception.SitemapPagePriorityException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.ThemeSetting;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeService;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.servlet.MultiSessionMessages;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.ThemeFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.sites.action.ActionUtil;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=portlet-layouts-admin", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.icon=/icons/default.png", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.system=true", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Layouts Admin", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_layout_admin_web_portlet_LayoutAdminPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class LayoutAdminPortlet
extends MVCPortlet {
    protected DLAppLocalService dlAppLocalService;
    protected GroupLocalService groupLocalService;
    protected GroupProvider groupProvider;
    protected GroupService groupService;
    protected LayoutLocalService layoutLocalService;
    protected LayoutPrototypeLocalService layoutPrototypeLocalService;
    protected LayoutPrototypeService layoutPrototypeService;
    protected LayoutRevisionLocalService layoutRevisionLocalService;
    protected LayoutService layoutService;
    protected LayoutSetBranchLocalService layoutSetBranchLocalService;
    protected LayoutSetLocalService layoutSetLocalService;
    protected LayoutSetService layoutSetService;
    protected MDRActionLocalService mdrActionLocalService;
    protected MDRActionService mdrActionService;
    protected MDRRuleGroupInstanceLocalService mdrRuleGroupInstanceLocalService;
    protected MDRRuleGroupInstanceService mdrRuleGroupInstanceService;
    @Reference
    protected Portal portal;
    protected PortletLocalService portletLocalService;
    protected PortletPreferencesLocalService portletPreferencesLocalService;
    protected ThemeLocalService themeLocalService;
    private static final Log _log = LogFactoryUtil.getLog(LayoutAdminPortlet.class);

    public void addLayout(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        UploadPortletRequest uploadPortletRequest = this.portal.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        long parentLayoutId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"parentLayoutId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        Map keywordsMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"keywords");
        Map robotsMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"robots");
        String type = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"type");
        boolean hidden = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"hidden");
        Map friendlyURLMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"friendlyURL");
        long layoutPrototypeId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"layoutPrototypeId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Layout.class.getName(), (PortletRequest)actionRequest);
        Layout layout = null;
        boolean inheritFromParentLayoutId = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"inheritFromParentLayoutId");
        UnicodeProperties typeSettingsProperties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"TypeSettingsProperties--");
        if (inheritFromParentLayoutId && parentLayoutId > 0L) {
            Layout parentLayout = this.layoutLocalService.getLayout(groupId, privateLayout, parentLayoutId);
            layout = this.layoutService.addLayout(groupId, privateLayout, parentLayoutId, nameMap, titleMap, parentLayout.getDescriptionMap(), parentLayout.getKeywordsMap(), parentLayout.getRobotsMap(), parentLayout.getType(), parentLayout.getTypeSettings(), hidden, friendlyURLMap, serviceContext);
            this.inheritMobileRuleGroups(layout, serviceContext);
            if (parentLayout.isTypePortlet()) {
                ActionUtil.copyPreferences((PortletRequest)actionRequest, (Layout)layout, (Layout)parentLayout);
                SitesUtil.copyLookAndFeel((Layout)layout, (Layout)parentLayout);
            }
        } else if (layoutPrototypeId > 0L) {
            LayoutPrototype layoutPrototype = this.layoutPrototypeService.getLayoutPrototype(layoutPrototypeId);
            boolean layoutPrototypeLinkEnabled = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)("layoutPrototypeLinkEnabled" + layoutPrototype.getUuid()));
            serviceContext.setAttribute("layoutPrototypeLinkEnabled", (Serializable)Boolean.valueOf(layoutPrototypeLinkEnabled));
            serviceContext.setAttribute("layoutPrototypeUuid", (Serializable)((Object)layoutPrototype.getUuid()));
            layout = this.layoutService.addLayout(groupId, privateLayout, parentLayoutId, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, "portlet", typeSettingsProperties.toString(), hidden, friendlyURLMap, serviceContext);
            SitesUtil.mergeLayoutPrototypeLayout((Group)layout.getGroup(), (Layout)layout);
        } else {
            long copyLayoutId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"copyLayoutId");
            Layout copyLayout = null;
            String layoutTemplateId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"layoutTemplateId", (String)PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID);
            if (copyLayoutId > 0L && (copyLayout = this.layoutLocalService.fetchLayout(groupId, privateLayout, copyLayoutId)) != null && copyLayout.isTypePortlet()) {
                LayoutTypePortlet copyLayoutTypePortlet = (LayoutTypePortlet)copyLayout.getLayoutType();
                layoutTemplateId = copyLayoutTypePortlet.getLayoutTemplateId();
                typeSettingsProperties = copyLayout.getTypeSettingsProperties();
            }
            layout = this.layoutService.addLayout(groupId, privateLayout, parentLayoutId, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, typeSettingsProperties.toString(), hidden, friendlyURLMap, serviceContext);
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlet.setLayoutTemplateId(themeDisplay.getUserId(), layoutTemplateId);
            this.layoutService.updateLayout(groupId, privateLayout, layout.getLayoutId(), layout.getTypeSettings());
            if (copyLayout != null && copyLayout.isTypePortlet()) {
                ActionUtil.copyPreferences((PortletRequest)actionRequest, (Layout)layout, (Layout)copyLayout);
                SitesUtil.copyLookAndFeel((Layout)layout, (Layout)copyLayout);
            }
        }
        this.updateLookAndFeel(actionRequest, themeDisplay.getCompanyId(), liveGroupId, stagingGroupId, privateLayout, layout.getLayoutId(), layout.getTypeSettingsProperties());
        String redirect = this.portal.getLayoutFullURL(layout, themeDisplay);
        if (layout.isTypeURL()) {
            redirect = this.portal.getGroupFriendlyURL(layout.getLayoutSet(), themeDisplay);
        }
        MultiSessionMessages.add((PortletRequest)actionRequest, (String)"layoutAdded", (Object)layout);
        actionRequest.setAttribute("REDIRECT", (Object)redirect);
    }

    public void copyApplications(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long layoutId;
        boolean privateLayout;
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        Layout layout = this.layoutLocalService.getLayout(groupId, privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout"), layoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutId"));
        if (!layout.getType().equals("portlet")) {
            return;
        }
        long copyLayoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"copyLayoutId");
        if (copyLayoutId == 0L || copyLayoutId == layout.getLayoutId()) {
            return;
        }
        Layout copyLayout = this.layoutLocalService.fetchLayout(groupId, privateLayout, copyLayoutId);
        if (copyLayout == null || !copyLayout.isTypePortlet()) {
            return;
        }
        UnicodeProperties sourceLayoutTypeSettingsProperties = copyLayout.getTypeSettingsProperties();
        ActionUtil.removePortletIds((PortletRequest)actionRequest, (Layout)layout);
        ActionUtil.copyPreferences((PortletRequest)actionRequest, (Layout)layout, (Layout)copyLayout);
        SitesUtil.copyLookAndFeel((Layout)layout, (Layout)copyLayout);
        this.layoutService.updateLayout(groupId, privateLayout, layoutId, sourceLayoutTypeSettingsProperties.toString());
    }

    public void deleteLayout(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long selPlid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"selPlid");
        if (selPlid <= 0L) {
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
            long layoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutId");
            Layout layout = this.layoutLocalService.getLayout(groupId, privateLayout, layoutId);
            selPlid = layout.getPlid();
        }
        Layout deleteLayout = this.layoutLocalService.getLayout(selPlid);
        String redirect = this.getRedirect(actionRequest, deleteLayout);
        SitesUtil.deleteLayout((PortletRequest)actionRequest, (PortletResponse)actionResponse);
        MultiSessionMessages.add((PortletRequest)actionRequest, (String)"layoutDeleted", (Object)selPlid);
        actionRequest.setAttribute("REDIRECT", (Object)redirect);
    }

    public void deleteOrphanPortlets(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long selPlid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"selPlid");
        String[] portletIds = null;
        String portletId = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletId");
        portletIds = Validator.isNotNull((String)portletId) ? new String[]{portletId} : ParamUtil.getStringValues((PortletRequest)actionRequest, (String)"rowIds");
        if (portletIds.length > 0) {
            this.portletLocalService.deletePortlets(themeDisplay.getCompanyId(), portletIds, selPlid);
        }
    }

    public void editLayout(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        UploadPortletRequest uploadPortletRequest = this.portal.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        Map keywordsMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"keywords");
        Map robotsMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"robots");
        String type = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"type");
        boolean hidden = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"hidden");
        Map friendlyURLMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"friendlyURL");
        boolean deleteLogo = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"deleteLogo");
        byte[] iconBytes = null;
        long fileEntryId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"fileEntryId");
        if (fileEntryId > 0L) {
            FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
            iconBytes = FileUtil.getBytes((InputStream)fileEntry.getContentStream());
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Layout.class.getName(), (PortletRequest)actionRequest);
        Layout layout = this.layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        String currentType = layout.getType();
        layout = this.layoutService.updateLayout(groupId, privateLayout, layoutId, layout.getParentLayoutId(), nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURLMap, !deleteLogo, iconBytes, serviceContext);
        UnicodeProperties layoutTypeSettingsProperties = layout.getTypeSettingsProperties();
        UnicodeProperties formTypeSettingsProperties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"TypeSettingsProperties--");
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        if (type.equals("portlet")) {
            String layoutTemplateId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"layoutTemplateId", (String)PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID);
            layoutTypePortlet.setLayoutTemplateId(themeDisplay.getUserId(), layoutTemplateId);
            layoutTypeSettingsProperties.putAll((Map)formTypeSettingsProperties);
            boolean layoutCustomizable = GetterUtil.getBoolean((String)((String)layoutTypeSettingsProperties.get((Object)"CUSTOMIZABLE_LAYOUT")));
            if (!layoutCustomizable) {
                layoutTypePortlet.removeCustomization(layoutTypeSettingsProperties);
            }
            layout = this.layoutService.updateLayout(groupId, privateLayout, layoutId, layoutTypeSettingsProperties.toString());
            if (!currentType.equals("portlet")) {
                this.portletPreferencesLocalService.deletePortletPreferences(0L, 3, layout.getPlid());
            }
        } else {
            layout.setTypeSettingsProperties(formTypeSettingsProperties);
            layoutTypeSettingsProperties.putAll((Map)layout.getTypeSettingsProperties());
            layout = this.layoutService.updateLayout(groupId, privateLayout, layoutId, layout.getTypeSettings());
        }
        HttpServletResponse response = this.portal.getHttpServletResponse((PortletResponse)actionResponse);
        EventsProcessorUtil.process((String)"layout.configuration.action.update", (String[])layoutTypePortlet.getConfigurationActionUpdate(), (HttpServletRequest)uploadPortletRequest, (HttpServletResponse)response);
        this.updateLookAndFeel(actionRequest, themeDisplay.getCompanyId(), liveGroupId, stagingGroupId, privateLayout, layout.getLayoutId(), layout.getTypeSettingsProperties());
        String redirect = this.portal.getLayoutFullURL(layout, themeDisplay);
        MultiSessionMessages.add((PortletRequest)actionRequest, (String)"layoutUpdated", (Object)layout);
        actionRequest.setAttribute("REDIRECT", (Object)redirect);
    }

    public void editLayoutSet(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long layoutSetId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutSetId");
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        LayoutSet layoutSet = this.layoutSetLocalService.getLayoutSet(layoutSetId);
        this.updateLogo(actionRequest, liveGroupId, stagingGroupId, privateLayout);
        this.updateLookAndFeel(actionRequest, themeDisplay.getCompanyId(), liveGroupId, stagingGroupId, privateLayout, layoutSet.getSettingsProperties());
        this.updateMergePages(actionRequest, liveGroupId);
        this.updateRobots(actionRequest, liveGroupId, privateLayout);
        this.updateSettings(actionRequest, liveGroupId, stagingGroupId, privateLayout, layoutSet.getSettingsProperties());
    }

    public void enableLayout(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long incompleteLayoutRevisionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"incompleteLayoutRevisionId");
        LayoutRevision incompleteLayoutRevision = this.layoutRevisionLocalService.getLayoutRevision(incompleteLayoutRevisionId);
        long layoutBranchId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutBranchId", (long)incompleteLayoutRevision.getLayoutBranchId());
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        serviceContext.setWorkflowAction(2);
        this.layoutRevisionLocalService.updateLayoutRevision(serviceContext.getUserId(), incompleteLayoutRevision.getLayoutRevisionId(), layoutBranchId, incompleteLayoutRevision.getName(), incompleteLayoutRevision.getTitle(), incompleteLayoutRevision.getDescription(), incompleteLayoutRevision.getKeywords(), incompleteLayoutRevision.getRobots(), incompleteLayoutRevision.getTypeSettings(), incompleteLayoutRevision.getIconImage(), incompleteLayoutRevision.getIconImageId(), incompleteLayoutRevision.getThemeId(), incompleteLayoutRevision.getColorSchemeId(), incompleteLayoutRevision.getCss(), serviceContext);
    }

    public void resetCustomizationView(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)themeDisplay.getLayout(), (String)"CUSTOMIZE")) {
            throw new PrincipalException();
        }
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        if (layoutTypePortlet != null && layoutTypePortlet.isCustomizable() && layoutTypePortlet.isCustomizedView()) {
            layoutTypePortlet.resetUserPreferences();
        }
        MultiSessionMessages.add((PortletRequest)actionRequest, (String)(this.portal.getPortletId((PortletRequest)actionRequest) + "requestProcessed"));
        Layout layout = themeDisplay.getLayout();
        actionResponse.sendRedirect(layout.getRegularURL(this.portal.getHttpServletRequest((PortletRequest)actionRequest)));
    }

    public void resetMergeFailCountAndMerge(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long layoutPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutPrototypeId");
        LayoutPrototype layoutPrototype = this.layoutPrototypeLocalService.getLayoutPrototype(layoutPrototypeId);
        SitesUtil.setMergeFailCount((LayoutPrototype)layoutPrototype, (int)0);
        long selPlid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"selPlid");
        Layout selLayout = this.layoutLocalService.getLayout(selPlid);
        SitesUtil.resetPrototype((Layout)selLayout);
        SitesUtil.mergeLayoutPrototypeLayout((Group)selLayout.getGroup(), (Layout)selLayout);
        layoutPrototype = this.layoutPrototypeService.getLayoutPrototype(layoutPrototypeId);
        int mergeFailCountAfterMerge = SitesUtil.getMergeFailCount((LayoutPrototype)layoutPrototype);
        if (mergeFailCountAfterMerge > 0) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"resetMergeFailCountAndMerge");
        }
    }

    public void resetPrototype(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        SitesUtil.resetPrototype((Layout)themeDisplay.getLayout());
        MultiSessionMessages.add((PortletRequest)actionRequest, (String)(this.portal.getPortletId((PortletRequest)actionRequest) + "requestProcessed"));
    }

    public void selectLayoutSetBranch(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        HttpServletRequest request = this.portal.getHttpServletRequest((PortletRequest)actionRequest);
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        LayoutSet layoutSet = this.layoutSetLocalService.getLayoutSet(groupId, privateLayout);
        long layoutSetBranchId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutSetBranchId");
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchLocalService.getLayoutSetBranch(layoutSetBranchId);
        StagingUtil.setRecentLayoutSetBranchId((HttpServletRequest)request, (long)layoutSet.getLayoutSetId(), (long)layoutSetBranch.getLayoutSetBranchId());
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
    }

    public void toggleCustomizedView(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        actionRequest.setAttribute("REDIRECT", (Object)this.portal.getLayoutURL(themeDisplay.getLayout(), themeDisplay));
    }

    protected void deleteThemeSettingsProperties(UnicodeProperties typeSettingsProperties, String device) {
        String keyPrefix = ThemeSettingImpl.namespaceProperty((String)device);
        Set keys = typeSettingsProperties.keySet();
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (!key.startsWith(keyPrefix)) continue;
            itr.remove();
        }
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            this.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
            }
            throw new PortletException((Throwable)e);
        }
        if (SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchGroupException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses())) {
            this.include("/error.jsp", renderRequest, renderResponse);
        } else {
            block7: {
                try {
                    ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)renderRequest);
                    ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Object)e, (Throwable)e);
                }
            }
            renderRequest.setAttribute("GROUP_PROVIDER", (Object)this.groupProvider);
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected String getColorSchemeId(long companyId, String themeId, String colorSchemeId) throws Exception {
        Theme theme = this.themeLocalService.getTheme(companyId, themeId);
        if (!theme.hasColorSchemes()) {
            colorSchemeId = "";
        }
        if (Validator.isNull((String)colorSchemeId)) {
            ColorScheme colorScheme = this.themeLocalService.getColorScheme(companyId, themeId, colorSchemeId);
            colorSchemeId = colorScheme.getColorSchemeId();
        }
        return colorSchemeId;
    }

    protected String getEmptyLayoutSetURL(PortletRequest portletRequest, long groupId, boolean privateLayout) {
        PortletURL emptyLayoutSetURL = this.portal.getControlPanelPortletURL(portletRequest, "com_liferay_layout_admin_web_portlet_GroupPagesPortlet", "RENDER_PHASE");
        emptyLayoutSetURL.setParameter("mvcPath", "/empty_layout_set.jsp");
        emptyLayoutSetURL.setParameter("selPlid", String.valueOf(0L));
        emptyLayoutSetURL.setParameter("groupId", String.valueOf(groupId));
        emptyLayoutSetURL.setParameter("privateLayout", String.valueOf(privateLayout));
        return emptyLayoutSetURL.toString();
    }

    protected Group getGroup(PortletRequest portletRequest) throws Exception {
        return ActionUtil.getGroup((PortletRequest)portletRequest);
    }

    protected byte[] getIconBytes(UploadPortletRequest uploadPortletRequest, String iconFileName) {
        block3: {
            InputStream inputStream = null;
            try {
                inputStream = uploadPortletRequest.getFileAsStream(iconFileName);
                if (inputStream != null) {
                    return FileUtil.getBytes((InputStream)inputStream);
                }
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to retrieve icon", (Throwable)ioe);
            }
        }
        return new byte[0];
    }

    protected long getNewPlid(Layout layout) {
        Layout parentLayout;
        long newPlid = 0L;
        if (layout.getParentLayoutId() != 0L && (parentLayout = this.layoutLocalService.fetchLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId())) != null) {
            newPlid = parentLayout.getPlid();
        }
        if (newPlid <= 0L) {
            Layout otherLayoutSetFirstLayout;
            Layout firstLayout = this.layoutLocalService.fetchFirstLayout(layout.getGroupId(), layout.isPrivateLayout(), 0L);
            if (firstLayout != null && firstLayout.getPlid() != layout.getPlid()) {
                newPlid = firstLayout.getPlid();
            }
            if (newPlid <= 0L && (otherLayoutSetFirstLayout = this.layoutLocalService.fetchFirstLayout(layout.getGroupId(), !layout.isPrivateLayout(), 0L)) != null && otherLayoutSetFirstLayout.getPlid() != layout.getPlid()) {
                newPlid = otherLayoutSetFirstLayout.getPlid();
            }
        }
        return newPlid;
    }

    protected String getRedirect(ActionRequest actionRequest, Layout layout) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        Layout refererLayout = this.layoutLocalService.fetchLayout(themeDisplay.getRefererPlid());
        if (refererLayout == null) {
            return redirect;
        }
        boolean ancestor = false;
        if (layout.getPlid() == themeDisplay.getRefererPlid()) {
            ancestor = true;
        } else {
            for (Layout parentLayout : refererLayout.getAncestors()) {
                if (parentLayout.getPlid() != layout.getPlid()) continue;
                ancestor = true;
            }
        }
        if (!ancestor) {
            return redirect;
        }
        long newRefererPlid = this.getNewPlid(layout);
        Layout redirectLayout = this.layoutLocalService.fetchLayout(newRefererPlid);
        redirect = redirectLayout != null ? this.portal.getLayoutFullURL(redirectLayout, themeDisplay) : this.getEmptyLayoutSetURL((PortletRequest)actionRequest, layout.getGroupId(), layout.isPrivateLayout());
        return redirect;
    }

    protected void inheritMobileRuleGroups(Layout layout, ServiceContext serviceContext) throws PortalException {
        List parentMDRRuleGroupInstances = this.mdrRuleGroupInstanceLocalService.getRuleGroupInstances(Layout.class.getName(), layout.getParentPlid());
        for (MDRRuleGroupInstance parentMDRRuleGroupInstance : parentMDRRuleGroupInstances) {
            MDRRuleGroupInstance mdrRuleGroupInstance = this.mdrRuleGroupInstanceService.addRuleGroupInstance(layout.getGroupId(), Layout.class.getName(), layout.getPlid(), parentMDRRuleGroupInstance.getRuleGroupId(), parentMDRRuleGroupInstance.getPriority(), serviceContext);
            List parentMDRActions = this.mdrActionLocalService.getActions(parentMDRRuleGroupInstance.getRuleGroupInstanceId());
            for (MDRAction mdrAction : parentMDRActions) {
                this.mdrActionService.addAction(mdrRuleGroupInstance.getRuleGroupInstanceId(), mdrAction.getNameMap(), mdrAction.getDescriptionMap(), mdrAction.getType(), mdrAction.getTypeSettings(), serviceContext);
            }
        }
    }

    protected boolean isAlwaysSendRedirect() {
        return true;
    }

    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof AssetCategoryException || cause instanceof ImageTypeException || cause instanceof LayoutFriendlyURLException || cause instanceof LayoutFriendlyURLsException || cause instanceof LayoutNameException || cause instanceof LayoutParentLayoutIdException || cause instanceof LayoutSetVirtualHostException || cause instanceof LayoutTypeException || cause instanceof NoSuchGroupException || cause instanceof PrincipalException || cause instanceof RequiredLayoutException || cause instanceof SitemapChangeFrequencyException || cause instanceof SitemapIncludeException || cause instanceof SitemapPagePriorityException || cause instanceof UploadException;
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this.dlAppLocalService = dlAppLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupProvider(GroupProvider groupProvider) {
        this.groupProvider = groupProvider;
    }

    @Reference(unbind="-")
    protected void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this.layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutPrototypeLocalService(LayoutPrototypeLocalService layoutPrototypeLocalService) {
        this.layoutPrototypeLocalService = layoutPrototypeLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutPrototypeService(LayoutPrototypeService layoutPrototypeService) {
        this.layoutPrototypeService = layoutPrototypeService;
    }

    @Reference(unbind="-")
    protected void setLayoutRevisionLocalService(LayoutRevisionLocalService layoutRevisionLocalService) {
        this.layoutRevisionLocalService = layoutRevisionLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutService(LayoutService layoutService) {
        this.layoutService = layoutService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetBranchLocalService(LayoutSetBranchLocalService layoutSetBranchLocalService) {
        this.layoutSetBranchLocalService = layoutSetBranchLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetLocalService(LayoutSetLocalService layoutSetLocalService) {
        this.layoutSetLocalService = layoutSetLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetService(LayoutSetService layoutSetService) {
        this.layoutSetService = layoutSetService;
    }

    @Reference(unbind="-")
    protected void setMDRActionLocalService(MDRActionLocalService mdrActionLocalService) {
        this.mdrActionLocalService = mdrActionLocalService;
    }

    @Reference(unbind="-")
    protected void setMDRActionService(MDRActionService mdrActionService) {
        this.mdrActionService = mdrActionService;
    }

    @Reference(unbind="-")
    protected void setMDRRuleGroupInstanceLocalService(MDRRuleGroupInstanceLocalService mdrRuleGroupInstanceLocalService) {
        this.mdrRuleGroupInstanceLocalService = mdrRuleGroupInstanceLocalService;
    }

    @Reference(unbind="-")
    protected void setMDRRuleGroupInstanceService(MDRRuleGroupInstanceService mdrRuleGroupInstanceService) {
        this.mdrRuleGroupInstanceService = mdrRuleGroupInstanceService;
    }

    @Reference(unbind="-")
    protected void setPortletLocalService(PortletLocalService portletLocalService) {
        this.portletLocalService = portletLocalService;
    }

    @Reference(unbind="-")
    protected void setPortletPreferencesLocalService(PortletPreferencesLocalService portletPreferencesLocalService) {
        this.portletPreferencesLocalService = portletPreferencesLocalService;
    }

    @Reference(unbind="-")
    protected void setThemeLocalService(ThemeLocalService themeLocalService) {
        this.themeLocalService = themeLocalService;
    }

    protected void setThemeSettingProperties(ActionRequest actionRequest, UnicodeProperties typeSettingsProperties, Map<String, ThemeSetting> themeSettings, String device, boolean isLayout) throws PortalException {
        Layout layout = null;
        if (isLayout) {
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
            long layoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutId");
            layout = this.layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        }
        for (Map.Entry<String, ThemeSetting> entry : themeSettings.entrySet()) {
            String key = entry.getKey();
            ThemeSetting themeSetting = entry.getValue();
            String property = device + "ThemeSettingsProperties--" + key + "--";
            String value = ParamUtil.getString((PortletRequest)actionRequest, (String)property, (String)themeSetting.getValue());
            if ((!isLayout || Objects.equals(value, layout.getDefaultThemeSetting(key, device, false))) && (isLayout || value.equals(themeSetting.getValue()))) continue;
            typeSettingsProperties.setProperty(ThemeSettingImpl.namespaceProperty((String)device, (String)key), value);
        }
    }

    protected void updateLogo(ActionRequest actionRequest, long liveGroupId, long stagingGroupId, boolean privateLayout) throws Exception {
        boolean deleteLogo = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"deleteLogo");
        byte[] logoBytes = null;
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        if (fileEntryId > 0L) {
            FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
            logoBytes = FileUtil.getBytes((InputStream)fileEntry.getContentStream());
        }
        long groupId = liveGroupId;
        if (stagingGroupId > 0L) {
            groupId = stagingGroupId;
        }
        this.layoutSetService.updateLogo(groupId, privateLayout, !deleteLogo, logoBytes);
    }

    protected void updateLookAndFeel(ActionRequest actionRequest, long companyId, long liveGroupId, long stagingGroupId, boolean privateLayout, long layoutId, UnicodeProperties typeSettingsProperties) throws Exception {
        String[] devices;
        for (String device : devices = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"devices"))) {
            String deviceThemeId = ParamUtil.getString((PortletRequest)actionRequest, (String)(device + "ThemeId"));
            String deviceColorSchemeId = ParamUtil.getString((PortletRequest)actionRequest, (String)(device + "ColorSchemeId"));
            String deviceCss = ParamUtil.getString((PortletRequest)actionRequest, (String)(device + "Css"));
            boolean deviceInheritLookAndFeel = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)(device + "InheritLookAndFeel"));
            if (deviceInheritLookAndFeel) {
                deviceThemeId = ThemeFactoryUtil.getDefaultRegularThemeId((long)companyId);
                deviceColorSchemeId = "";
                this.deleteThemeSettingsProperties(typeSettingsProperties, device);
            } else if (Validator.isNotNull((String)deviceThemeId)) {
                deviceColorSchemeId = this.getColorSchemeId(companyId, deviceThemeId, deviceColorSchemeId);
                this.updateThemeSettingsProperties(actionRequest, companyId, typeSettingsProperties, device, deviceThemeId, true);
            }
            long groupId = liveGroupId;
            if (stagingGroupId > 0L) {
                groupId = stagingGroupId;
            }
            this.layoutService.updateLayout(groupId, privateLayout, layoutId, typeSettingsProperties.toString());
            this.layoutService.updateLookAndFeel(groupId, privateLayout, layoutId, deviceThemeId, deviceColorSchemeId, deviceCss);
        }
    }

    protected void updateLookAndFeel(ActionRequest actionRequest, long companyId, long liveGroupId, long stagingGroupId, boolean privateLayout, UnicodeProperties typeSettingsProperties) throws Exception {
        String[] devices;
        for (String device : devices = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"devices"))) {
            String deviceThemeId = ParamUtil.getString((PortletRequest)actionRequest, (String)(device + "ThemeId"));
            String deviceColorSchemeId = ParamUtil.getString((PortletRequest)actionRequest, (String)(device + "ColorSchemeId"));
            String deviceCss = ParamUtil.getString((PortletRequest)actionRequest, (String)(device + "Css"));
            if (Validator.isNotNull((String)deviceThemeId)) {
                deviceColorSchemeId = this.getColorSchemeId(companyId, deviceThemeId, deviceColorSchemeId);
                this.updateThemeSettingsProperties(actionRequest, companyId, typeSettingsProperties, device, deviceThemeId, false);
            }
            long groupId = liveGroupId;
            if (stagingGroupId > 0L) {
                groupId = stagingGroupId;
            }
            this.layoutSetService.updateLookAndFeel(groupId, privateLayout, deviceThemeId, deviceColorSchemeId, deviceCss);
        }
    }

    protected void updateMergePages(ActionRequest actionRequest, long liveGroupId) throws Exception {
        boolean mergeGuestPublicPages = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"mergeGuestPublicPages");
        Group liveGroup = this.groupLocalService.getGroup(liveGroupId);
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("mergeGuestPublicPages", String.valueOf(mergeGuestPublicPages));
        this.groupService.updateGroup(liveGroupId, liveGroup.getTypeSettings());
    }

    protected void updateRobots(ActionRequest actionRequest, long liveGroupId, boolean privateLayout) throws Exception {
        Group liveGroup = this.groupLocalService.getGroup(liveGroupId);
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        String propertyName = "false-robots.txt";
        if (privateLayout) {
            propertyName = "true-robots.txt";
        }
        String robots = ParamUtil.getString((PortletRequest)actionRequest, (String)"robots", (String)liveGroup.getTypeSettingsProperty(propertyName));
        typeSettingsProperties.setProperty(propertyName, robots);
        this.groupService.updateGroup(liveGroup.getGroupId(), typeSettingsProperties.toString());
    }

    protected void updateSettings(ActionRequest actionRequest, long liveGroupId, long stagingGroupId, boolean privateLayout, UnicodeProperties settingsProperties) throws Exception {
        UnicodeProperties typeSettingsProperties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"TypeSettingsProperties--");
        settingsProperties.putAll((Map)typeSettingsProperties);
        long groupId = liveGroupId;
        if (stagingGroupId > 0L) {
            groupId = stagingGroupId;
        }
        this.layoutSetService.updateSettings(groupId, privateLayout, settingsProperties.toString());
    }

    protected UnicodeProperties updateThemeSettingsProperties(ActionRequest actionRequest, long companyId, UnicodeProperties typeSettingsProperties, String device, String deviceThemeId, boolean layout) throws Exception {
        Theme theme = this.themeLocalService.getTheme(companyId, deviceThemeId);
        this.deleteThemeSettingsProperties(typeSettingsProperties, device);
        Map themeSettings = theme.getConfigurableSettings();
        if (themeSettings.isEmpty()) {
            return typeSettingsProperties;
        }
        this.setThemeSettingProperties(actionRequest, typeSettingsProperties, themeSettings, device, layout);
        return typeSettingsProperties;
    }
}

