/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class LayoutFriendlyURLStagedModelDataHandler
extends BaseStagedModelDataHandler<LayoutFriendlyURL> {
    public static final String[] CLASS_NAMES = new String[]{LayoutFriendlyURL.class.getName()};
    private LayoutFriendlyURLLocalService _layoutFriendlyURLLocalService;
    private LayoutLocalService _layoutLocalService;

    public void deleteStagedModel(LayoutFriendlyURL layoutFriendlyURL) {
        this._layoutFriendlyURLLocalService.deleteLayoutFriendlyURL(layoutFriendlyURL);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        LayoutFriendlyURL layoutFriendlyURL = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        this.deleteStagedModel(layoutFriendlyURL);
    }

    public LayoutFriendlyURL fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._layoutFriendlyURLLocalService.fetchLayoutFriendlyURLByUuidAndGroupId(uuid, groupId);
    }

    public List<LayoutFriendlyURL> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._layoutFriendlyURLLocalService.getLayoutFriendlyURLsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, LayoutFriendlyURL layoutFriendlyURL) throws Exception {
        Element layoutFriendlyURLElement = portletDataContext.getExportDataElement((ClassedModel)layoutFriendlyURL);
        portletDataContext.addClassedModel(layoutFriendlyURLElement, ExportImportPathUtil.getModelPath((StagedModel)layoutFriendlyURL), (ClassedModel)layoutFriendlyURL);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, LayoutFriendlyURL layoutFriendlyURL) throws Exception {
        long userId = portletDataContext.getUserId(layoutFriendlyURL.getUserUuid());
        Map plids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        long plid = MapUtil.getLong((Map)plids, (long)layoutFriendlyURL.getPlid(), (long)layoutFriendlyURL.getPlid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)layoutFriendlyURL);
        LayoutFriendlyURL importedLayoutFriendlyURL = null;
        LayoutFriendlyURL existingLayoutFriendlyURL = this.fetchExistingLayoutFriendlyURL(portletDataContext, layoutFriendlyURL, plid);
        layoutFriendlyURL = this.getUniqueLayoutFriendlyURL(portletDataContext, layoutFriendlyURL, existingLayoutFriendlyURL);
        if (existingLayoutFriendlyURL == null) {
            serviceContext.setUuid(layoutFriendlyURL.getUuid());
            String friendlyURL = layoutFriendlyURL.getFriendlyURL();
            if (Validator.isNumber((String)friendlyURL.substring(1))) {
                Layout layout = this._layoutLocalService.fetchLayout(plid);
                friendlyURL = "/" + layout.getLayoutId();
            }
            importedLayoutFriendlyURL = this._layoutFriendlyURLLocalService.addLayoutFriendlyURL(userId, portletDataContext.getCompanyId(), portletDataContext.getScopeGroupId(), plid, portletDataContext.isPrivateLayout(), friendlyURL, layoutFriendlyURL.getLanguageId(), serviceContext);
        } else {
            importedLayoutFriendlyURL = this._layoutFriendlyURLLocalService.updateLayoutFriendlyURL(userId, portletDataContext.getCompanyId(), portletDataContext.getScopeGroupId(), plid, portletDataContext.isPrivateLayout(), layoutFriendlyURL.getFriendlyURL(), layoutFriendlyURL.getLanguageId(), serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)layoutFriendlyURL, (ClassedModel)importedLayoutFriendlyURL);
    }

    protected LayoutFriendlyURL fetchExistingLayoutFriendlyURL(PortletDataContext portletDataContext, LayoutFriendlyURL layoutFriendlyURL, long plid) {
        LayoutFriendlyURL existingLayoutFriendlyURL = this.fetchStagedModelByUuidAndGroupId(layoutFriendlyURL.getUuid(), portletDataContext.getScopeGroupId());
        if (existingLayoutFriendlyURL == null) {
            existingLayoutFriendlyURL = this._layoutFriendlyURLLocalService.fetchLayoutFriendlyURL(plid, layoutFriendlyURL.getLanguageId(), false);
        }
        return existingLayoutFriendlyURL;
    }

    protected LayoutFriendlyURL getUniqueLayoutFriendlyURL(PortletDataContext portletDataContext, LayoutFriendlyURL layoutFriendlyURL, LayoutFriendlyURL existingLayoutFriendlyURL) throws Exception {
        LayoutFriendlyURL duplicateLayoutFriendlyURL;
        String friendlyURL = layoutFriendlyURL.getFriendlyURL();
        int i = 1;
        while ((duplicateLayoutFriendlyURL = this._layoutFriendlyURLLocalService.fetchLayoutFriendlyURL(portletDataContext.getScopeGroupId(), layoutFriendlyURL.isPrivateLayout(), layoutFriendlyURL.getFriendlyURL(), layoutFriendlyURL.getLanguageId())) != null && (existingLayoutFriendlyURL == null || existingLayoutFriendlyURL.getLayoutFriendlyURLId() != duplicateLayoutFriendlyURL.getLayoutFriendlyURLId())) {
            layoutFriendlyURL.setFriendlyURL(friendlyURL + i);
            ++i;
        }
        return layoutFriendlyURL;
    }

    @Reference(unbind="-")
    protected void setLayoutFriendlyURLLocalService(LayoutFriendlyURLLocalService layoutFriendlyURLLocalService) {
        this._layoutFriendlyURLLocalService = layoutFriendlyURLLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }
}

