/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.display.context;

import com.liferay.layout.admin.web.internal.display.context.BaseLayoutDisplayContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.util.LayoutDescription;
import com.liferay.portal.util.LayoutListUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.layoutsadmin.display.context.GroupDisplayContextHelper;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class LayoutsAdminDisplayContext
extends BaseLayoutDisplayContext {
    private final GroupDisplayContextHelper _groupDisplayContextHelper;
    private List<LayoutDescription> _layoutDescriptions;
    private Long _layoutId;
    private Organization _organization;
    private String _pagesName;
    private String _redirect;
    private User _selUser;
    private UserGroup _userGroup;

    public LayoutsAdminDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws PortalException {
        super(liferayPortletRequest, liferayPortletResponse);
        this._groupDisplayContextHelper = new GroupDisplayContextHelper(PortalUtil.getHttpServletRequest((PortletRequest)liferayPortletRequest));
        this.liferayPortletRequest.setAttribute("LAYOUT_DESCRIPTIONS", this.getLayoutDescriptions());
    }

    @Override
    public PortletURL getAddLayoutURL(long selPlid, Boolean privateLayout) {
        PortletURL addLayoutURL = super.getAddLayoutURL(selPlid, privateLayout);
        addLayoutURL.setParameter("backURL", PortalUtil.getCurrentURL((HttpServletRequest)PortalUtil.getHttpServletRequest((PortletRequest)this.liferayPortletRequest)));
        return addLayoutURL;
    }

    public PortletURL getEditLayoutURL() {
        PortletURL editLayoutURL = super.getEditLayoutURL(this.getSelPlid(), this.isPrivateLayout());
        editLayoutURL.setParameter("redirect", this.getRedirect());
        return editLayoutURL;
    }

    public Group getGroup() {
        return this._groupDisplayContextHelper.getGroup();
    }

    public Long getGroupId() {
        return this._groupDisplayContextHelper.getGroupId();
    }

    public UnicodeProperties getGroupTypeSettings() {
        return this._groupDisplayContextHelper.getGroupTypeSettings();
    }

    public List<LayoutDescription> getLayoutDescriptions() {
        if (this._layoutDescriptions != null) {
            return this._layoutDescriptions;
        }
        this._layoutDescriptions = LayoutListUtil.getLayoutDescriptions((long)this.getGroupId(), (boolean)this.isPrivateLayout(), (String)this.getRootNodeName(), (Locale)this.themeDisplay.getLocale());
        return this._layoutDescriptions;
    }

    @Override
    public Long getLayoutId() {
        if (this._layoutId != null) {
            return this._layoutId;
        }
        this._layoutId = 0L;
        Layout selLayout = this.getSelLayout();
        if (selLayout != null) {
            this._layoutId = selLayout.getLayoutId();
        }
        return this._layoutId;
    }

    @Override
    public Group getLiveGroup() {
        return this._groupDisplayContextHelper.getLiveGroup();
    }

    public Long getLiveGroupId() {
        return this._groupDisplayContextHelper.getLiveGroupId();
    }

    public Organization getOrganization() {
        if (this._organization != null) {
            return this._organization;
        }
        Group liveGroup = this.getLiveGroup();
        if (liveGroup.isOrganization()) {
            this._organization = OrganizationLocalServiceUtil.fetchOrganization((long)liveGroup.getOrganizationId());
        }
        return this._organization;
    }

    public String getPagesName() {
        if (this._pagesName != null) {
            return this._pagesName;
        }
        Group liveGroup = this.getLiveGroup();
        this._pagesName = liveGroup.isLayoutPrototype() || liveGroup.isLayoutSetPrototype() || liveGroup.isUserGroup() ? "pages" : (this.isPrivateLayout() ? (liveGroup.isUser() ? "my-dashboard" : "private-pages") : (liveGroup.isUser() ? "my-profile" : "public-pages"));
        return this._pagesName;
    }

    public String getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((PortletRequest)this.liferayPortletRequest, (String)"redirect");
        return this._redirect;
    }

    public PortletURL getRedirectURL() {
        PortletURL portletURL = this.liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view.jsp");
        portletURL.setParameter("redirect", this.getRedirect());
        portletURL.setParameter("groupId", String.valueOf(this.getSelGroupId()));
        return portletURL;
    }

    @Override
    public Group getSelGroup() {
        return this._groupDisplayContextHelper.getSelGroup();
    }

    @Override
    public long getSelGroupId() {
        Group selGroup = this.getSelGroup();
        if (selGroup != null) {
            return selGroup.getGroupId();
        }
        return 0L;
    }

    public User getSelUser() {
        if (this._selUser != null) {
            return this._selUser;
        }
        Group liveGroup = this.getLiveGroup();
        if (liveGroup.isUser()) {
            this._selUser = UserLocalServiceUtil.fetchUser((long)liveGroup.getClassPK());
        }
        return this._selUser;
    }

    @Override
    public Group getStagingGroup() {
        return this._groupDisplayContextHelper.getStagingGroup();
    }

    public Long getStagingGroupId() {
        return this._groupDisplayContextHelper.getStagingGroupId();
    }

    public UserGroup getUserGroup() {
        if (this._userGroup != null) {
            return this._userGroup;
        }
        Group liveGroup = this.getLiveGroup();
        if (liveGroup.isUserGroup()) {
            this._userGroup = UserGroupLocalServiceUtil.fetchUserGroup((long)liveGroup.getClassPK());
        }
        return this._userGroup;
    }

    protected boolean hasPowerUserRole() {
        try {
            User selUser = this.getSelUser();
            return RoleLocalServiceUtil.hasUserRole((long)selUser.getUserId(), (long)this.themeDisplay.getCompanyId(), (String)"Power User", (boolean)true);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isPrivateLayoutsModifiable() {
        return (!PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_POWER_USER_REQUIRED || this.hasPowerUserRole()) && PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED;
    }

    protected boolean isPublicLayoutsModifiable() {
        return (!PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_POWER_USER_REQUIRED || this.hasPowerUserRole()) && PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED;
    }
}

