/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.asset;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.layout.admin.web.internal.asset.LayoutAssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_admin_web_portlet_LayoutAdminPortlet"}, service={AssetRendererFactory.class})
public class LayoutAssetRendererFactory
extends BaseAssetRendererFactory<Layout> {
    public static final String TYPE = "layout";
    private AssetEntryLocalService _assetEntryLocalService;
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    private ServletContext _servletContext;
    private UserLocalService _userLocalService;

    public LayoutAssetRendererFactory() {
        this.setClassName(Layout.class.getName());
        this.setSelectable(false);
        this.setPortletId("com_liferay_layout_admin_web_portlet_LayoutAdminPortlet");
    }

    public AssetEntry getAssetEntry(long assetEntryId) throws PortalException {
        return this.getAssetEntry(this.getClassName(), assetEntryId);
    }

    public AssetEntry getAssetEntry(String className, long classPK) throws PortalException {
        Layout layout = this._layoutLocalService.getLayout(classPK);
        User user = this._userLocalService.getUserById(layout.getUserId());
        AssetEntry assetEntry = this._assetEntryLocalService.createAssetEntry(classPK);
        assetEntry.setGroupId(layout.getGroupId());
        assetEntry.setCompanyId(user.getCompanyId());
        assetEntry.setUserId(user.getUserId());
        assetEntry.setUserName(user.getFullName());
        assetEntry.setCreateDate(layout.getCreateDate());
        assetEntry.setClassNameId(this._portal.getClassNameId(Layout.class.getName()));
        assetEntry.setClassPK(layout.getLayoutId());
        assetEntry.setTitle(layout.getHTMLTitle(LocaleUtil.getSiteDefault()));
        return assetEntry;
    }

    public AssetRenderer<Layout> getAssetRenderer(long plid, int type) throws PortalException {
        Layout layout = this._layoutLocalService.getLayout(plid);
        LayoutAssetRenderer layoutAssetRenderer = new LayoutAssetRenderer(layout);
        layoutAssetRenderer.setAssetRendererType(type);
        layoutAssetRenderer.setServletContext(this._servletContext);
        return layoutAssetRenderer;
    }

    public String getClassName() {
        return Layout.class.getName();
    }

    public String getType() {
        return TYPE;
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.layout.admin.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    @Reference(unbind="-")
    protected void setAssetEntryLocalService(AssetEntryLocalService assetEntryLocalService) {
        this._assetEntryLocalService = assetEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

