/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.language.LanguageBuilderUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.language.UTF8Control;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassResourceBundleLoader;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleUtil {
    public static final ResourceBundle EMPTY_RESOURCE_BUNDLE = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return Collections.emptyEnumeration();
        }

        @Override
        protected Object handleGetObject(String key) {
            return key;
        }
    };

    public static ResourceBundle getBundle(Locale locale, Class<?> clazz) {
        return ResourceBundleUtil.getBundle("content.Language", locale, clazz);
    }

    public static ResourceBundle getBundle(Locale locale, ClassLoader classLoader) {
        return ResourceBundleUtil.getBundle("content.Language", locale, classLoader);
    }

    public static ResourceBundle getBundle(Locale locale, String symbolicName) {
        return ResourceBundleUtil._getBundle("content.Language", locale, ResourceBundleUtil.class.getClassLoader(), symbolicName);
    }

    public static ResourceBundle getBundle(String baseName, Class<?> clazz) {
        return ResourceBundleUtil.getBundle(baseName, clazz.getClassLoader());
    }

    public static ResourceBundle getBundle(String baseName, ClassLoader classLoader) {
        return ResourceBundleUtil.getBundle(baseName, LocaleUtil.getDefault(), classLoader);
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, Class<?> clazz) {
        return ResourceBundleUtil.getBundle(baseName, locale, clazz.getClassLoader());
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader classLoader) {
        Registry registry = RegistryUtil.getRegistry();
        return ResourceBundleUtil._getBundle(baseName, locale, classLoader, registry.getSymbolicName(classLoader));
    }

    public static Map<Locale, String> getLocalizationMap(ResourceBundleLoader resourceBundleLoader, String key) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
            map.put(locale, ResourceBundleUtil.getString(resourceBundle, key));
        }
        return map;
    }

    public static ResourceBundle getModuleAndPortalResourceBundle(Locale locale, Class<?> clazz) {
        return new AggregateResourceBundle(ResourceBundleUtil.getBundle(locale, clazz), PortalUtil.getResourceBundle(locale));
    }

    public static ResourceBundleLoader getResourceBundleLoader(String baseName, ClassLoader classLoader) {
        return new ClassResourceBundleLoader(baseName, classLoader);
    }

    public static String getString(ResourceBundle resourceBundle, String key) {
        if (!resourceBundle.containsKey(key)) {
            return null;
        }
        try {
            return LanguageBuilderUtil.fixValue(resourceBundle.getString(key));
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static String getString(ResourceBundle resourceBundle, String key, Object ... arguments) {
        String value = ResourceBundleUtil.getString(resourceBundle, key);
        if (value == null) {
            return null;
        }
        if (ArrayUtil.isNotEmpty(arguments)) {
            MessageFormat messageFormat = new MessageFormat(value, resourceBundle.getLocale());
            value = messageFormat.format(arguments);
        }
        return value;
    }

    private static ResourceBundle _getBundle(String baseName, Locale locale, ClassLoader classLoader, String symbolicName) {
        ResourceBundleLoader resourceBundleLoader = null;
        if (symbolicName == null) {
            ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
            if (classLoader == portalClassLoader) {
                resourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
            }
        } else {
            resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByBundleSymbolicName(symbolicName);
        }
        if (resourceBundleLoader == null) {
            return ResourceBundle.getBundle(baseName, locale, classLoader, (ResourceBundle.Control)UTF8Control.INSTANCE);
        }
        return resourceBundleLoader.loadResourceBundle(locale);
    }
}

