/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.lang.builder;

import com.liferay.lang.builder.LangBuilderArgs;
import com.liferay.lang.builder.LangBuilderCategory;
import com.liferay.lang.builder.comparator.LangBuilderCategoryComparator;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.language.LanguageValidator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.GitException;
import com.liferay.portal.tools.GitUtil;
import io.github.firemaples.language.Language;
import io.github.firemaples.translate.Translate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;

public class LangBuilder {
    public static final String AUTOMATIC_COPY = " (Automatic Copy)";
    public static final String AUTOMATIC_TRANSLATION = " (Automatic Translation)";
    private final String[] _excludedLanguageIds;
    private final Set<String> _keysWithUpdatedValues = new HashSet<String>();
    private final String _langDirName;
    private final String _langFileName;
    private final Properties _renameKeys;
    private final boolean _titleCapitalization;
    private final boolean _translate;

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        System.setProperty("line.separator", "\n");
        String excludedLanguageIdsString = GetterUtil.getString(arguments.get("lang.excluded.language.ids"), StringUtil.merge(LangBuilderArgs.EXCLUDED_LANGUAGE_IDS));
        String langDirName = GetterUtil.getString(arguments.get("lang.dir"), "src/content");
        String langFileName = GetterUtil.getString(arguments.get("lang.file"), "Language");
        boolean titleCapitalization = GetterUtil.getBoolean(arguments.get("lang.title.capitalization"), true);
        boolean translate = GetterUtil.getBoolean(arguments.get("lang.translate"), true);
        String translateSubscriptionKey = arguments.get("lang.translate.subscription.key");
        boolean buildCurrentBranch = ArgumentsUtil.getBoolean(arguments, "build.current.branch", false);
        String[] excludedLanguageIds = StringUtil.split(excludedLanguageIdsString);
        if (buildCurrentBranch) {
            String gitWorkingBranchName = ArgumentsUtil.getString(arguments, "git.working.branch.name", "master");
            LangBuilder._processCurrentBranch(excludedLanguageIds, langFileName, titleCapitalization, translate, translateSubscriptionKey, gitWorkingBranchName);
            return;
        }
        try {
            new LangBuilder(excludedLanguageIds, langDirName, langFileName, titleCapitalization, translate, translateSubscriptionKey);
        }
        catch (Exception e) {
            ArgumentsUtil.processMainException(arguments, e);
        }
    }

    public LangBuilder(String[] excludedLanguageIds, String langDirName, String langFileName, boolean titleCapitalization, boolean translate, String translateSubscriptionKey) throws Exception {
        this._excludedLanguageIds = excludedLanguageIds;
        this._langDirName = langDirName;
        this._langFileName = langFileName;
        this._titleCapitalization = titleCapitalization;
        this._translate = translate;
        Translate.setSubscriptionKey((String)translateSubscriptionKey);
        this._initKeysWithUpdatedValues();
        File renameKeysFile = new File(this._langDirName + "/rename.properties");
        this._renameKeys = renameKeysFile.exists() ? this._readProperties(renameKeysFile) : null;
        File propertiesFile = new File(StringBundler.concat(this._langDirName, "/", this._langFileName, ".properties"));
        String content = this._orderProperties(propertiesFile);
        if (Validator.isNull(content)) {
            return;
        }
        this._orderProperties(new File(StringBundler.concat(this._langDirName, "/", this._langFileName, "_en_AU.properties")));
        this._orderProperties(new File(StringBundler.concat(this._langDirName, "/", this._langFileName, "_en_GB.properties")));
        this._orderProperties(new File(StringBundler.concat(this._langDirName, "/", this._langFileName, "_fr_CA.properties")));
        this._copyProperties(propertiesFile, "en");
        this._createProperties(content, "ar");
        this._createProperties(content, "eu");
        this._createProperties(content, "bg");
        this._createProperties(content, "ca");
        this._createProperties(content, "zh_CN");
        this._createProperties(content, "zh_TW");
        this._createProperties(content, "hr");
        this._createProperties(content, "cs");
        this._createProperties(content, "da");
        this._createProperties(content, "nl");
        this._createProperties(content, "nl_BE", "nl");
        this._createProperties(content, "et");
        this._createProperties(content, "fi");
        this._createProperties(content, "fr");
        this._createProperties(content, "gl");
        this._createProperties(content, "de");
        this._createProperties(content, "el");
        this._createProperties(content, "iw");
        this._createProperties(content, "hi_IN");
        this._createProperties(content, "hu");
        this._createProperties(content, "in");
        this._createProperties(content, "it");
        this._createProperties(content, "ja");
        this._createProperties(content, "ko");
        this._createProperties(content, "lo");
        this._createProperties(content, "lt");
        this._createProperties(content, "nb");
        this._createProperties(content, "fa");
        this._createProperties(content, "pl");
        this._createProperties(content, "pt_BR");
        this._createProperties(content, "pt_PT", "pt_BR");
        this._createProperties(content, "ro");
        this._createProperties(content, "ru");
        this._createProperties(content, "sr_RS");
        this._createProperties(content, "sr_RS_latin");
        this._createProperties(content, "sk");
        this._createProperties(content, "sl");
        this._createProperties(content, "es");
        this._createProperties(content, "sv");
        this._createProperties(content, "th");
        this._createProperties(content, "tr");
        this._createProperties(content, "uk");
        this._createProperties(content, "vi");
    }

    private static String _getSpecialPropertyValue(String key) {
        if (key.equals("lang.dir")) {
            return "ltr";
        }
        if (key.equals("lang.line.begin")) {
            return "left";
        }
        if (key.equals("lang.line.end")) {
            return "right";
        }
        return "";
    }

    private static void _processCurrentBranch(String[] excludedLanguageIds, String langFileName, boolean titleCapitalization, boolean translate, String translateSubscriptionKey, String gitWorkingBranchName) throws Exception {
        try {
            String basedir = ".././";
            List<String> fileNames = GitUtil.getCurrentBranchFileNames(basedir, gitWorkingBranchName);
            for (String fileName : fileNames) {
                int pos = fileName.indexOf("content/" + langFileName + ".properties");
                if (pos == -1) continue;
                String langDirName = basedir + fileName.substring(0, pos + 7);
                new LangBuilder(excludedLanguageIds, langDirName, langFileName, titleCapitalization, translate, translateSubscriptionKey);
            }
        }
        catch (GitException ge) {
            System.out.println(ge.getMessage());
        }
    }

    private static boolean _startsWithIgnoreCase(String string, String prefix) {
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    private void _addMessage(Map<LangBuilderCategory, Map<String, String>> messages, String key, String value, boolean useSingleCategory) {
        LangBuilderCategory langBuilderCategory = this._getLangBuilderCategory(key, useSingleCategory);
        Map<String, String> categoryMessages = messages.get((Object)langBuilderCategory);
        if (categoryMessages == null) {
            categoryMessages = new TreeMap<String, String>(new NaturalOrderStringComparator(true, true));
        }
        categoryMessages.put(key, value);
        messages.put(langBuilderCategory, categoryMessages);
    }

    private void _copyProperties(File file, String languageId) throws IOException {
        Path path = Paths.get(this._langDirName, StringBundler.concat(this._langFileName, "_", languageId, ".properties"));
        Files.copy(file.toPath(), path, StandardCopyOption.REPLACE_EXISTING);
    }

    private void _createProperties(String content, String languageId) throws IOException {
        this._createProperties(content, languageId, null);
    }

    private void _createProperties(String content, String languageId, String parentLanguageId) throws IOException {
        File parentPropertiesFile;
        File propertiesFile = new File(StringBundler.concat(this._langDirName, "/", this._langFileName, "_", languageId, ".properties"));
        Properties properties = new Properties();
        if (propertiesFile.exists()) {
            properties = this._readProperties(propertiesFile);
        }
        Properties parentProperties = null;
        if (parentLanguageId != null && (parentPropertiesFile = new File(StringBundler.concat(this._langDirName, "/", this._langFileName, "_", parentLanguageId, ".properties"))).exists()) {
            parentProperties = this._readProperties(parentPropertiesFile);
        }
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String renameKey;
                String[] array = (line = line.trim()).split("=", 2);
                if (array.length != 2) {
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                String key = array[0];
                String value = array[1];
                String translatedText = properties.getProperty(key);
                if (this._keysWithUpdatedValues.contains(key)) {
                    translatedText = null;
                }
                if (translatedText == null && parentProperties != null) {
                    translatedText = parentProperties.getProperty(key);
                }
                if (translatedText == null && this._renameKeys != null && (renameKey = this._renameKeys.getProperty(key)) != null && (translatedText = properties.getProperty(key)) == null && parentProperties != null) {
                    translatedText = parentProperties.getProperty(key);
                }
                if (translatedText != null && translatedText.endsWith(AUTOMATIC_COPY)) {
                    translatedText = "";
                }
                if (translatedText == null || translatedText.equals("")) {
                    if (line.contains("{") || line.contains("<")) {
                        translatedText = value + AUTOMATIC_COPY;
                    } else if (line.contains("[")) {
                        int pos = line.indexOf("[");
                        String baseKey = line.substring(0, pos);
                        String translatedBaseKey = properties.getProperty(baseKey);
                        translatedText = Validator.isNotNull(translatedBaseKey) ? translatedBaseKey : value + AUTOMATIC_COPY;
                    } else if (LanguageValidator.isSpecialPropertyKey(key)) {
                        translatedText = LangBuilder._getSpecialPropertyValue(key);
                    } else if (languageId.equals("el") && (key.equals("enabled") || key.equals("on") || key.equals("on-date"))) {
                        translatedText = "";
                    } else if (languageId.equals("es") && key.equals("am")) {
                        translatedText = "";
                    } else if (languageId.equals("fi") && (key.equals("on") || key.equals("the"))) {
                        translatedText = "";
                    } else if (languageId.equals("it") && key.equals("am")) {
                        translatedText = "";
                    } else if (languageId.equals("ja") && (key.equals("any") || key.equals("anytime") || key.equals("down") || key.equals("on") || key.equals("on-date") || key.equals("the"))) {
                        translatedText = "";
                    } else if (languageId.equals("ko") && key.equals("the")) {
                        translatedText = "";
                    } else {
                        translatedText = this._translate("en", languageId, key, value, 0);
                        if (Validator.isNull(translatedText)) {
                            translatedText = value + AUTOMATIC_COPY;
                        } else if (!key.startsWith("country.") && !key.startsWith("language.")) {
                            translatedText = translatedText + AUTOMATIC_TRANSLATION;
                        }
                    }
                }
                if (!Validator.isNotNull(translatedText)) continue;
                translatedText = this._fixTranslation(translatedText);
                sb.append(key);
                sb.append("=");
                sb.append(translatedText);
                sb.append("\n");
            }
        }
        sb.setIndex(sb.index() - 1);
        content = sb.toString();
        this._write(propertiesFile, content);
    }

    private String _fixEnglishTranslation(String key, String value) {
        if (value.contains(" this ")) {
            if (!(value.contains(".") || value.contains("?") || value.contains(":") || key.equals("the-url-of-the-page-comparing-this-page-content-with-the-previous-version"))) {
                value = StringUtil.replace(value, " this ", " This ");
            }
        } else {
            value = StringUtil.replace(value, " From ", " from ");
        }
        return value;
    }

    private String _fixTranslation(String value) {
        value = StringUtil.replace(value.trim(), new String[]{"  ", "<b>", "</b>", "<i>", "</i>", " url ", "&#39;", "&#39 ;", "&quot;", "&quot ;", "ReCaptcha", "Captcha"}, new String[]{" ", "<strong>", "</strong>", "<em>", "</em>", " URL ", "'", "'", "\"", "\"", "reCAPTCHA", "CAPTCHA"});
        value = StringUtil.replace(value.trim(), new char[]{'\u2018', '\u2019', '\u201a', '\u201b', '\u201c', '\u201d', '\u201e', '\u201f'}, new char[]{'\'', '\'', '\'', '\'', '\"', '\"', '\"', '\"'});
        return value;
    }

    private LangBuilderCategory _getLangBuilderCategory(String key, boolean useSingleCategory) {
        LangBuilderCategory defaultCategory = LangBuilderCategory.MESSAGES;
        if (useSingleCategory) {
            return defaultCategory;
        }
        for (LangBuilderCategory langBuilderCategory : LangBuilderCategory.values()) {
            String prefix = langBuilderCategory.getPrefix();
            if (!Validator.isNotNull(prefix) || !key.startsWith(langBuilderCategory.getPrefix())) continue;
            return langBuilderCategory;
        }
        return defaultCategory;
    }

    private String _getMicrosoftLanguageId(String languageId) {
        if (languageId.equals("pt_BR") || languageId.equals("pt_PT")) {
            return "pt";
        }
        if (languageId.equals("hi_IN")) {
            return "hi";
        }
        if (languageId.equals("in")) {
            return "id";
        }
        if (languageId.equals("iw")) {
            return "he";
        }
        if (languageId.equals("nb")) {
            return "no";
        }
        if (languageId.equals("zh_CN")) {
            return "zh-CHS";
        }
        if (languageId.equals("zh_TW")) {
            return "zh-CHT";
        }
        return languageId;
    }

    private void _initKeysWithUpdatedValues() throws Exception {
        File backupLanguageFile = new File(StringBundler.concat(this._langDirName, "/", this._langFileName, "_en.properties"));
        if (!backupLanguageFile.exists()) {
            return;
        }
        Properties backupLanguageProperties = this._readProperties(backupLanguageFile);
        File languageFile = new File(StringBundler.concat(this._langDirName, "/", this._langFileName, ".properties"));
        Properties languageProperties = this._readProperties(languageFile);
        Set<Map.Entry<Object, Object>> set = languageProperties.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value.equals(backupLanguageProperties.get(key))) continue;
            this._keysWithUpdatedValues.add(key);
        }
    }

    private String _orderProperties(File propertiesFile) throws IOException {
        if (!propertiesFile.exists()) {
            return null;
        }
        boolean useSingleCategory = true;
        String absolutePath = StringUtil.replace(propertiesFile.getAbsolutePath(), '\\', '/');
        if (absolutePath.contains("/portal-impl/src/content/")) {
            useSingleCategory = false;
        }
        String content = this._read(propertiesFile);
        TreeMap<LangBuilderCategory, Map<String, String>> messages = new TreeMap<LangBuilderCategory, Map<String, String>>(new LangBuilderCategoryComparator());
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));
        Object object = null;
        try {
            String string;
            Object var8_8 = null;
            while ((string = unsyncBufferedReader.readLine()) != null) {
                String[] array = string.split("=", 2);
                if (array.length != 2) continue;
                String key = array[0];
                String value = array[1];
                if (Validator.isNull(key) || Validator.isNull(value)) continue;
                value = this._fixTranslation(value);
                if (this._titleCapitalization) {
                    value = this._fixEnglishTranslation(key, value);
                }
                this._addMessage(messages, key, value, useSingleCategory);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (unsyncBufferedReader != null) {
                if (object != null) {
                    try {
                        unsyncBufferedReader.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    unsyncBufferedReader.close();
                }
            }
        }
        if (messages.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler();
        for (Map.Entry entry : messages.entrySet()) {
            if (!useSingleCategory) {
                LangBuilderCategory langBuilderCategory = (LangBuilderCategory)((Object)entry.getKey());
                sb.append("##\n");
                sb.append("## ");
                sb.append(langBuilderCategory.getDescription());
                sb.append("\n");
                sb.append("##\n\n");
            }
            Map categoryMessages = (Map)entry.getValue();
            for (Map.Entry entry2 : categoryMessages.entrySet()) {
                sb.append((String)entry2.getKey());
                sb.append("=");
                sb.append((String)entry2.getValue());
                sb.append("\n");
            }
            sb.append("\n");
        }
        sb.setIndex(sb.index() - 2);
        content = sb.toString();
        this._write(propertiesFile, content);
        return content;
    }

    private String _read(File file) throws IOException {
        String s = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        return StringUtil.replace(s, "\r\n", "\n");
    }

    private Properties _readProperties(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Properties properties = PropertiesUtil.load(fileInputStream, "UTF-8");
            return properties;
        }
    }

    private String _translate(String fromLanguageId, String toLanguageId, String key, String fromText, int limit) {
        if (!this._translate) {
            return null;
        }
        if (ArrayUtil.contains(this._excludedLanguageIds, toLanguageId)) {
            return null;
        }
        if (limit == 3) {
            return null;
        }
        Language fromLanguage = Language.fromString((String)this._getMicrosoftLanguageId(fromLanguageId));
        Language toLanguage = Language.fromString((String)this._getMicrosoftLanguageId(toLanguageId));
        if (toLanguage == null) {
            return null;
        }
        String toText = null;
        try {
            StringBundler sb = new StringBundler(8);
            sb.append("Translating ");
            sb.append(fromLanguageId);
            sb.append("_");
            sb.append(toLanguageId);
            sb.append(" ");
            sb.append(key);
            sb.append(" ");
            sb.append(fromText);
            System.out.println(sb.toString());
            toText = Translate.execute((String)fromText, (Language)fromLanguage, (Language)toLanguage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (toText == null) {
            return this._translate(fromLanguageId, toLanguageId, key, fromText, ++limit);
        }
        return toText;
    }

    private void _write(File file, String s) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)s, (String)"UTF-8");
    }
}

