/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.exportimport.portlet.preferences.processor;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_knowledge_base_web_portlet_ArticlePortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class KBArticleExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    @Reference(target="(name=ReferencedStagedModelImporter)")
    private Capability _capability;
    private KBArticleLocalService _kbArticleLocalService;

    public List<Capability> getExportCapabilities() {
        return null;
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._capability});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        long resourcePrimKey = GetterUtil.getLong((String)portletPreferences.getValue("resourcePrimKey", ""));
        if (resourcePrimKey != 0L) {
            List kbArticles = this._kbArticleLocalService.getKBArticleAndAllDescendantKBArticles(resourcePrimKey, 0, null);
            for (KBArticle kbArticle : kbArticles) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletDataContext.getPortletId(), (StagedModel)kbArticle);
            }
        }
        return portletPreferences;
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        long resourcePrimKey = GetterUtil.getLong((String)portletPreferences.getValue("resourcePrimKey", ""));
        Map kbArticleResourcePrimKeys = portletDataContext.getNewPrimaryKeysMap(KBArticle.class);
        resourcePrimKey = MapUtil.getLong((Map)kbArticleResourcePrimKeys, (long)resourcePrimKey, (long)resourcePrimKey);
        try {
            portletPreferences.setValue("resourcePrimKey", String.valueOf(resourcePrimKey));
        }
        catch (ReadOnlyException roe) {
            StringBundler sb = new StringBundler(7);
            sb.append("Unable to save converted portlet preference ");
            sb.append("resourcePrimKey=");
            sb.append(resourcePrimKey);
            sb.append(" (the root article) while importing KB Article ");
            sb.append("portlet. (portletId=");
            sb.append(portletDataContext.getPortletId());
            sb.append(")");
            throw new PortletDataException(sb.toString(), (Throwable)roe);
        }
        return portletPreferences;
    }

    @Reference(unbind="-")
    protected void seKBArticleLocalService(KBArticleLocalService kbArticleLocalService) {
        this._kbArticleLocalService = kbArticleLocalService;
    }
}

