/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.knowledge.base.model.KBTemplate;
import com.liferay.knowledge.base.model.KBTemplateSearchDisplay;
import com.liferay.knowledge.base.service.KBTemplateServiceUtil;
import com.liferay.knowledge.base.web.internal.search.KBTemplateSearch;
import com.liferay.knowledge.base.web.internal.security.permission.resource.AdminPermission;
import com.liferay.knowledge.base.web.internal.security.permission.resource.KBTemplatePermission;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class KBTemplatesManagementToolbarDisplayContext {
    private final PortletURL _currentURLObj;
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private SearchContainer _searchContainer;
    private final String _templatePath;
    private final ThemeDisplay _themeDisplay;

    public KBTemplatesManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest httpServletRequest, String templatePath) throws PortalException {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._httpServletRequest = httpServletRequest;
        this._templatePath = templatePath;
        this._currentURLObj = PortletURLUtil.getCurrent((LiferayPortletRequest)this._liferayPortletRequest, (LiferayPortletResponse)this._liferayPortletResponse);
        this._themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._createSearchContainer();
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteKBTemplates");
                    dropdownItem.setIcon("times-circle");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)KBTemplatesManagementToolbarDisplayContext.this._httpServletRequest, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public List<String> getAvailableActions(KBTemplate kbTemplate) throws PortalException {
        ArrayList<String> availableActionDropdownItems = new ArrayList<String>();
        PermissionChecker permissionChecker = this._themeDisplay.getPermissionChecker();
        if (KBTemplatePermission.contains(permissionChecker, kbTemplate, "DELETE")) {
            availableActionDropdownItems.add("deleteKBTemplates");
        }
        return availableActionDropdownItems;
    }

    public CreationMenu getCreationMenu() {
        if (Validator.isNotNull((String)this._getKeywords()) || !AdminPermission.contains(this._themeDisplay.getPermissionChecker(), this._themeDisplay.getScopeGroupId(), "ADD_KB_TEMPLATE")) {
            return null;
        }
        return new CreationMenu(){
            {
                this.addDropdownItem(dropdownItem -> {
                    PortletURL addKBTemplateURL = KBTemplatesManagementToolbarDisplayContext.this._liferayPortletResponse.createRenderURL();
                    addKBTemplateURL.setParameter("mvcPath", KBTemplatesManagementToolbarDisplayContext.this._templatePath + "edit_template.jsp");
                    addKBTemplateURL.setParameter("redirect", PortalUtil.getCurrentURL((HttpServletRequest)KBTemplatesManagementToolbarDisplayContext.this._httpServletRequest));
                    dropdownItem.setHref((Object)addKBTemplateURL);
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)KBTemplatesManagementToolbarDisplayContext.this._httpServletRequest, (String)"add-template"));
                });
            }
        };
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(KBTemplatesManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)KBTemplatesManagementToolbarDisplayContext.this._httpServletRequest, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByType() {
        return this._searchContainer.getOrderByType();
    }

    public SearchContainer getSearchContainer() {
        return this._searchContainer;
    }

    public PortletURL getSearchURL() {
        PortletURL searchURL = this._liferayPortletResponse.createRenderURL();
        searchURL.setParameter("mvcPath", "/admin/view_templates.jsp");
        return searchURL;
    }

    public PortletURL getSortingURL() throws PortletException {
        PortletURL sortingURL = this._getCurrentSortingURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL;
    }

    public int getTotal() {
        return this._searchContainer.getTotal();
    }

    public boolean isDisabled() {
        return !this._searchContainer.hasResults();
    }

    private void _createSearchContainer() throws PortalException {
        PortletURL iteratorURL = this._liferayPortletResponse.createRenderURL();
        iteratorURL.setParameter("mvcPath", "/admin/view_templates.jsp");
        this._searchContainer = new KBTemplateSearch((PortletRequest)this._liferayPortletRequest, iteratorURL);
        String keywords = this._getKeywords();
        if (Validator.isNull((String)keywords)) {
            this._searchContainer.setTotal(KBTemplateServiceUtil.getGroupKBTemplatesCount((long)this._themeDisplay.getScopeGroupId()));
            this._searchContainer.setResults(KBTemplateServiceUtil.getGroupKBTemplates((long)this._themeDisplay.getScopeGroupId(), (int)this._searchContainer.getStart(), (int)this._searchContainer.getEnd(), (OrderByComparator)this._searchContainer.getOrderByComparator()));
        } else {
            KBTemplateSearchDisplay kbTemplateSearchDisplay = KBTemplateServiceUtil.getKBTemplateSearchDisplay((long)this._themeDisplay.getScopeGroupId(), (String)keywords, (String)keywords, null, null, (boolean)false, (int[])new int[0], (int)this._searchContainer.getCur(), (int)this._searchContainer.getDelta(), (OrderByComparator)this._searchContainer.getOrderByComparator());
            this._searchContainer.setResults(kbTemplateSearchDisplay.getResults());
            this._searchContainer.setTotal(kbTemplateSearchDisplay.getTotal());
        }
    }

    private PortletURL _getCurrentSortingURL() throws PortletException {
        PortletURL sortingURL = PortletURLUtil.clone((PortletURL)this._currentURLObj, (LiferayPortletResponse)this._liferayPortletResponse);
        sortingURL.setParameter("mvcPath", "/admin/view_templates.jsp");
        return sortingURL;
    }

    private String _getKeywords() {
        return ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
    }

    private String _getOrderByCol() {
        return this._searchContainer.getOrderByCol();
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                HashMap<String, String> orderColumnsMap = new HashMap<String, String>();
                orderColumnsMap.put("create-date", "create-date");
                orderColumnsMap.put("modified-date", "modified-date");
                orderColumnsMap.put("title", "title");
                orderColumnsMap.put("user-name", "user-name");
                for (Map.Entry orderByColEntry : orderColumnsMap.entrySet()) {
                    this.add(dropdownItem -> {
                        String orderByCol = (String)orderByColEntry.getKey();
                        dropdownItem.setActive(orderByCol.equals(KBTemplatesManagementToolbarDisplayContext.this._getOrderByCol()));
                        dropdownItem.setHref(KBTemplatesManagementToolbarDisplayContext.this._getCurrentSortingURL(), new Object[]{"orderByCol", orderByColEntry.getValue()});
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)KBTemplatesManagementToolbarDisplayContext.this._httpServletRequest, (String)orderByCol));
                    });
                }
            }
        };
    }
}

