/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItemList;
import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.web.internal.security.permission.resource.KBCommentPermission;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class KBSuggestionListManagementToolbarDisplayContext {
    private final PortletURL _currentURLObj;
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final SearchContainer _searchContainer;
    private final ThemeDisplay _themeDisplay;

    public KBSuggestionListManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest httpServletRequest, SearchContainer searchContainer) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._httpServletRequest = httpServletRequest;
        this._searchContainer = searchContainer;
        this._currentURLObj = PortletURLUtil.getCurrent((LiferayPortletRequest)this._liferayPortletRequest, (LiferayPortletResponse)this._liferayPortletResponse);
        this._themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteKBComments");
                    dropdownItem.setIcon("times-circle");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)KBSuggestionListManagementToolbarDisplayContext.this._httpServletRequest, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public List<String> getAvailableActions(KBComment kbComment) throws PortalException {
        ArrayList<String> availableActionDropdownItems = new ArrayList<String>();
        PermissionChecker permissionChecker = this._themeDisplay.getPermissionChecker();
        if (KBCommentPermission.contains(permissionChecker, kbComment, "DELETE")) {
            availableActionDropdownItems.add("deleteKBComments");
        }
        return availableActionDropdownItems;
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this._liferayPortletResponse.createRenderURL();
        clearResultsURL.setParameter("mvcPath", "/admin/view_suggestions.jsp");
        return clearResultsURL.toString();
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(KBSuggestionListManagementToolbarDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)KBSuggestionListManagementToolbarDisplayContext.this._httpServletRequest, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(KBSuggestionListManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)KBSuggestionListManagementToolbarDisplayContext.this._httpServletRequest, (String)"order-by"));
                });
            }
        };
    }

    public List<LabelItem> getFilterLabelItems() {
        return new LabelItemList(){
            {
                String navigation = KBSuggestionListManagementToolbarDisplayContext.this._getNavigation();
                if (!navigation.equals("all")) {
                    this.add(labelItem -> {
                        PortletURL removeLabelURL = PortletURLUtil.clone((PortletURL)KBSuggestionListManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)KBSuggestionListManagementToolbarDisplayContext.this._liferayPortletResponse);
                        removeLabelURL.setParameter("navigation", (String)null);
                        labelItem.putData("removeLabelURL", removeLabelURL.toString());
                        labelItem.setCloseable(true);
                        labelItem.setLabel(LanguageUtil.get((HttpServletRequest)KBSuggestionListManagementToolbarDisplayContext.this._httpServletRequest, (String)navigation));
                    });
                }
            }
        };
    }

    public String getOrderByType() {
        return this._searchContainer.getOrderByType();
    }

    public SearchContainer getSearchContainer() {
        return this._searchContainer;
    }

    public PortletURL getSortingURL() throws PortletException {
        PortletURL sortingURL = this._getCurrentSortingURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL;
    }

    public int getTotal() {
        return this._searchContainer.getTotal();
    }

    public boolean isDisabled() {
        String navigation = this._getNavigation();
        return navigation.equals("all") && !this._searchContainer.hasResults();
    }

    private PortletURL _getCurrentSortingURL() throws PortletException {
        PortletURL sortingURL = PortletURLUtil.clone((PortletURL)this._currentURLObj, (LiferayPortletResponse)this._liferayPortletResponse);
        sortingURL.setParameter("storeOrderByPreference", Boolean.TRUE.toString());
        return sortingURL;
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() throws PortletException {
        return new DropdownItemList(){
            {
                String navigation = KBSuggestionListManagementToolbarDisplayContext.this._getNavigation();
                String[] navigationKeys = new String[]{"all", "new", "in-progress", "resolved"};
                PortletURL navigationURL = PortletURLUtil.clone((PortletURL)KBSuggestionListManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)KBSuggestionListManagementToolbarDisplayContext.this._liferayPortletResponse);
                navigationURL.setParameter("storeOrderByPreference", Boolean.FALSE.toString());
                for (String navigationKey : navigationKeys) {
                    this.add(dropdownItem -> {
                        dropdownItem.setActive(navigation.equals(navigationKey));
                        dropdownItem.setHref(navigationURL, new Object[]{"navigation", navigationKey});
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)KBSuggestionListManagementToolbarDisplayContext.this._httpServletRequest, (String)navigationKey));
                    });
                }
            }
        };
    }

    private String _getNavigation() {
        return ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"navigation", (String)"all");
    }

    private String _getOrderByCol() {
        return this._searchContainer.getOrderByCol();
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                HashMap<String, String> orderColumnsMap = new HashMap<String, String>();
                String navigation = KBSuggestionListManagementToolbarDisplayContext.this._getNavigation();
                if (navigation.equals("all")) {
                    orderColumnsMap.put("status", "status");
                }
                orderColumnsMap.put("modified-date", "modified-date");
                orderColumnsMap.put("user-name", "user-name");
                for (Map.Entry orderByColEntry : orderColumnsMap.entrySet()) {
                    this.add(dropdownItem -> {
                        String orderByCol = (String)orderByColEntry.getKey();
                        dropdownItem.setActive(orderByCol.equals(KBSuggestionListManagementToolbarDisplayContext.this._getOrderByCol()));
                        dropdownItem.setHref(KBSuggestionListManagementToolbarDisplayContext.this._getCurrentSortingURL(), new Object[]{"orderByCol", orderByColEntry.getValue()});
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)KBSuggestionListManagementToolbarDisplayContext.this._httpServletRequest, (String)orderByCol));
                    });
                }
            }
        };
    }
}

