/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.display.context;

import com.liferay.knowledge.base.constants.KBArticleConstants;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.service.KBCommentServiceUtil;
import com.liferay.knowledge.base.web.internal.KBUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.servlet.http.HttpServletRequest;

public class KBSuggestionListDisplayContext {
    private final long _groupId;
    private final HttpServletRequest _httpServletRequest;
    private KBArticle _kbArticle;
    private final String _navigation;
    private final String _templatePath;

    public KBSuggestionListDisplayContext(HttpServletRequest httpServletRequest, String templatePath, KBArticle kbArticle) {
        this._httpServletRequest = httpServletRequest;
        this._templatePath = templatePath;
        this._kbArticle = kbArticle;
        this._groupId = kbArticle.getGroupId();
        this._navigation = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"navigation", (String)"all");
    }

    public KBSuggestionListDisplayContext(HttpServletRequest httpServletRequest, String templatePath, long groupId) {
        this._httpServletRequest = httpServletRequest;
        this._templatePath = templatePath;
        this._groupId = groupId;
        this._navigation = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"navigation", (String)"all");
    }

    public int getCompletedKBCommentsCount() throws PortalException {
        return this.getKBCommentsCount(0);
    }

    public String getEmptyResultsMessage() {
        if (this._navigation.equals("new")) {
            return "there-are-no-new-suggestions";
        }
        if (this._navigation.equals("in-progress")) {
            return "there-are-no-suggestions-in-progress";
        }
        if (this._navigation.equals("resolved")) {
            return "there-are-no-resolved-suggestions";
        }
        return "there-are-no-suggestions";
    }

    public long getGroupId() {
        return this._groupId;
    }

    public int getInProgressKBCommentsCount() throws PortalException {
        return this.getKBCommentsCount(2);
    }

    public int getKBCommentsCount(int status) throws PortalException {
        if (this._kbArticle == null) {
            return KBCommentServiceUtil.getKBCommentsCount((long)this._groupId, (int)status);
        }
        return KBCommentServiceUtil.getKBCommentsCount((long)this._groupId, (String)KBArticleConstants.getClassName(), (long)this._kbArticle.getResourcePrimKey(), (int)status);
    }

    public int getNewKBCommentsCount() throws PortalException {
        return this.getKBCommentsCount(1);
    }

    public boolean isShowKBArticleTitle() {
        return this._kbArticle == null;
    }

    public void populateResultsAndTotal(SearchContainer<KBComment> searchContainer) throws PortalException {
        int status = this._getStatus();
        if (this._kbArticle == null) {
            if (status == -1) {
                searchContainer.setTotal(KBCommentServiceUtil.getKBCommentsCount((long)this._groupId));
                searchContainer.setResults(KBCommentServiceUtil.getKBComments((long)this._groupId, (int)searchContainer.getStart(), (int)searchContainer.getEnd(), KBUtil.getKBCommentOrderByComparator(searchContainer.getOrderByCol(), searchContainer.getOrderByType())));
            } else {
                searchContainer.setTotal(this.getKBCommentsCount(status));
                searchContainer.setResults(KBCommentServiceUtil.getKBComments((long)this._groupId, (int)status, (int)searchContainer.getStart(), (int)searchContainer.getEnd(), KBUtil.getKBCommentOrderByComparator(searchContainer.getOrderByCol(), searchContainer.getOrderByType())));
            }
        } else if (status == -1) {
            searchContainer.setTotal(KBCommentServiceUtil.getKBCommentsCount((long)this._groupId, (String)KBArticleConstants.getClassName(), (long)this._kbArticle.getResourcePrimKey()));
            searchContainer.setResults(KBCommentServiceUtil.getKBComments((long)this._groupId, (String)KBArticleConstants.getClassName(), (long)this._kbArticle.getResourcePrimKey(), (int)searchContainer.getStart(), (int)searchContainer.getEnd(), KBUtil.getKBCommentOrderByComparator(searchContainer.getOrderByCol(), searchContainer.getOrderByType())));
        } else {
            searchContainer.setTotal(this.getKBCommentsCount(status));
            searchContainer.setResults(KBCommentServiceUtil.getKBComments((long)this._groupId, (String)KBArticleConstants.getClassName(), (long)this._kbArticle.getResourcePrimKey(), (int)status, (int)searchContainer.getStart(), (int)searchContainer.getEnd(), KBUtil.getKBCommentOrderByComparator(searchContainer.getOrderByCol(), searchContainer.getOrderByType())));
        }
    }

    private int _getStatus() {
        if (this._navigation.equals("new")) {
            return 1;
        }
        if (this._navigation.equals("in-progress")) {
            return 2;
        }
        if (this._navigation.equals("resolved")) {
            return 0;
        }
        return -1;
    }
}

