/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.knowledge.base.web.internal.security.permission.resource.AdminPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class KBAdminNavigationDisplayContext {
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;

    public KBAdminNavigationDisplayContext(HttpServletRequest httpServletRequest, LiferayPortletResponse liferayPortletResponse) {
        this._httpServletRequest = httpServletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
    }

    public List<NavigationItem> getInfoPanelNavigationItems() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ArrayList<NavigationItem> navigationItems = new ArrayList<NavigationItem>();
        NavigationItem navigationItem = new NavigationItem();
        navigationItem.setActive(true);
        navigationItem.setHref((Object)themeDisplay.getURLCurrent());
        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"details"));
        navigationItems.add(navigationItem);
        return navigationItems;
    }

    public List<NavigationItem> getNavigationItems() throws PortalException {
        PortletURL viewKBTemplatesURL;
        boolean active;
        ArrayList<NavigationItem> navigationItems = new ArrayList<NavigationItem>();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        String mvcPath = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"mvcPath");
        if (PortletPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getPlid(), (String)portletDisplay.getId(), (String)"VIEW")) {
            NavigationItem kbObjectsNavigationItem = new NavigationItem();
            active = false;
            if (!mvcPath.equals("/admin/view_suggestions.jsp") && !mvcPath.equals("/admin/view_templates.jsp")) {
                active = true;
            }
            kbObjectsNavigationItem.setActive(active);
            PortletURL viewKBObjectsURL = this._liferayPortletResponse.createRenderURL();
            viewKBObjectsURL.setParameter("mvcPath", "/admin/view.jsp");
            kbObjectsNavigationItem.setHref((Object)viewKBObjectsURL.toString());
            kbObjectsNavigationItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"articles"));
            navigationItems.add(kbObjectsNavigationItem);
        }
        if (AdminPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "VIEW_KB_TEMPLATES")) {
            NavigationItem kbTemplatesNavigationItem = new NavigationItem();
            active = false;
            if (mvcPath.equals("/admin/view_templates.jsp")) {
                active = true;
            }
            kbTemplatesNavigationItem.setActive(active);
            viewKBTemplatesURL = this._liferayPortletResponse.createRenderURL();
            viewKBTemplatesURL.setParameter("mvcPath", "/admin/view_templates.jsp");
            kbTemplatesNavigationItem.setHref((Object)viewKBTemplatesURL.toString());
            kbTemplatesNavigationItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"templates"));
            navigationItems.add(kbTemplatesNavigationItem);
        }
        if (AdminPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "VIEW_SUGGESTIONS")) {
            NavigationItem kbSuggestionsNavigationItem = new NavigationItem();
            active = false;
            if (mvcPath.equals("/admin/view_suggestions.jsp")) {
                active = true;
            }
            kbSuggestionsNavigationItem.setActive(active);
            viewKBTemplatesURL = this._liferayPortletResponse.createRenderURL();
            viewKBTemplatesURL.setParameter("mvcPath", "/admin/view_suggestions.jsp");
            kbSuggestionsNavigationItem.setHref((Object)viewKBTemplatesURL.toString());
            kbSuggestionsNavigationItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"suggestions"));
            navigationItems.add(kbSuggestionsNavigationItem);
        }
        return navigationItems;
    }
}

