/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBArticleSearchDisplay;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.model.KBTemplate;
import com.liferay.knowledge.base.service.KBArticleServiceUtil;
import com.liferay.knowledge.base.service.KBFolderServiceUtil;
import com.liferay.knowledge.base.service.KBTemplateServiceUtil;
import com.liferay.knowledge.base.web.internal.search.EntriesChecker;
import com.liferay.knowledge.base.web.internal.search.KBObjectsSearch;
import com.liferay.knowledge.base.web.internal.security.permission.resource.AdminPermission;
import com.liferay.knowledge.base.web.internal.security.permission.resource.KBArticlePermission;
import com.liferay.knowledge.base.web.internal.security.permission.resource.KBFolderPermission;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.OrderByComparatorFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class KBAdminManagementToolbarDisplayContext {
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final PortletConfig _portletConfig;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private SearchContainer _searchContainer;
    private final ThemeDisplay _themeDisplay;

    public KBAdminManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest httpServletRequest, RenderRequest renderRequest, RenderResponse renderResponse, PortletConfig portletConfig) throws PortalException, PortletException {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._httpServletRequest = httpServletRequest;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._portletConfig = portletConfig;
        this._themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._createSearchContainer();
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteEntries");
                    dropdownItem.setIcon("times-circle");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)KBAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public List<String> getAvailableActions(KBArticle kbArticle) throws PortalException {
        ArrayList<String> availableActionDropdownItems = new ArrayList<String>();
        PermissionChecker permissionChecker = this._themeDisplay.getPermissionChecker();
        if (KBArticlePermission.contains(permissionChecker, kbArticle, "DELETE")) {
            availableActionDropdownItems.add("deleteEntries");
        }
        return availableActionDropdownItems;
    }

    public List<String> getAvailableActions(KBFolder kbFolder) throws PortalException {
        ArrayList<String> availableActionDropdownItems = new ArrayList<String>();
        PermissionChecker permissionChecker = this._themeDisplay.getPermissionChecker();
        if (KBFolderPermission.contains(permissionChecker, kbFolder, "DELETE")) {
            availableActionDropdownItems.add("deleteEntries");
        }
        return availableActionDropdownItems;
    }

    public CreationMenu getCreationMenu() throws PortalException {
        CreationMenu creationMenu = null;
        long kbFolderClassNameId = PortalUtil.getClassNameId((String)KBFolderConstants.getClassName());
        long parentResourceClassNameId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"parentResourceClassNameId", (long)kbFolderClassNameId);
        long parentResourcePrimKey = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"parentResourcePrimKey", (long)0L);
        boolean hasAddKBArticlePermission = false;
        boolean hasAddKBFolderPermission = false;
        PermissionChecker permissionChecker = this._themeDisplay.getPermissionChecker();
        if (parentResourceClassNameId == kbFolderClassNameId) {
            hasAddKBArticlePermission = KBFolderPermission.contains(permissionChecker, this._themeDisplay.getScopeGroupId(), parentResourcePrimKey, "ADD_KB_ARTICLE");
            hasAddKBFolderPermission = KBFolderPermission.contains(permissionChecker, this._themeDisplay.getScopeGroupId(), parentResourcePrimKey, "ADD_KB_FOLDER");
        } else {
            hasAddKBArticlePermission = AdminPermission.contains(permissionChecker, this._themeDisplay.getScopeGroupId(), "ADD_KB_ARTICLE");
        }
        if (hasAddKBFolderPermission) {
            if (creationMenu == null) {
                creationMenu = new CreationMenu();
            }
            creationMenu.addDropdownItem(dropdownItem -> {
                PortletURL addFolderURL = this._liferayPortletResponse.createRenderURL();
                addFolderURL.setParameter("mvcPath", "/admin/common/edit_folder.jsp");
                addFolderURL.setParameter("redirect", PortalUtil.getCurrentURL((HttpServletRequest)this._httpServletRequest));
                addFolderURL.setParameter("parentResourceClassNameId", String.valueOf(PortalUtil.getClassNameId((String)KBFolderConstants.getClassName())));
                addFolderURL.setParameter("parentResourcePrimKey", String.valueOf(parentResourcePrimKey));
                dropdownItem.setHref((Object)addFolderURL);
                dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"folder"));
            });
        }
        if (hasAddKBArticlePermission) {
            if (creationMenu == null) {
                creationMenu = new CreationMenu();
            }
            String templatePath = this._getTemplatePath();
            creationMenu.addDropdownItem(dropdownItem -> {
                PortletURL addBasicKBArticleURL = this._liferayPortletResponse.createRenderURL();
                addBasicKBArticleURL.setParameter("mvcPath", templatePath + "edit_article.jsp");
                addBasicKBArticleURL.setParameter("redirect", PortalUtil.getCurrentURL((HttpServletRequest)this._httpServletRequest));
                addBasicKBArticleURL.setParameter("parentResourceClassNameId", String.valueOf(parentResourceClassNameId));
                addBasicKBArticleURL.setParameter("parentResourcePrimKey", String.valueOf(parentResourcePrimKey));
                dropdownItem.setHref((Object)addBasicKBArticleURL);
                dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"basic-article"));
            });
            OrderByComparator obc = OrderByComparatorFactoryUtil.create((String)"KBTemplate", (Object[])new Object[]{"title", false});
            List kbTemplates = KBTemplateServiceUtil.getGroupKBTemplates((long)this._themeDisplay.getScopeGroupId(), (int)-1, (int)-1, (OrderByComparator)obc);
            if (!kbTemplates.isEmpty()) {
                for (KBTemplate kbTemplate : kbTemplates) {
                    creationMenu.addDropdownItem(dropdownItem -> {
                        PortletURL addKBArticleURL = this._liferayPortletResponse.createRenderURL();
                        addKBArticleURL.setParameter("mvcPath", templatePath + "edit_article.jsp");
                        addKBArticleURL.setParameter("redirect", PortalUtil.getCurrentURL((HttpServletRequest)this._httpServletRequest));
                        addKBArticleURL.setParameter("parentResourceClassNameId", String.valueOf(parentResourceClassNameId));
                        addKBArticleURL.setParameter("parentResourcePrimKey", String.valueOf(parentResourcePrimKey));
                        addKBArticleURL.setParameter("kbTemplateId", String.valueOf(kbTemplate.getKbTemplateId()));
                        dropdownItem.setHref((Object)addKBArticleURL);
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)kbTemplate.getTitle()));
                    });
                }
            }
        }
        if (parentResourceClassNameId == kbFolderClassNameId && AdminPermission.contains(permissionChecker, this._themeDisplay.getScopeGroupId(), "ADD_KB_ARTICLE")) {
            if (creationMenu == null) {
                creationMenu = new CreationMenu();
            }
            creationMenu.addDropdownItem(dropdownItem -> {
                PortletURL importURL = this._liferayPortletResponse.createRenderURL();
                importURL.setParameter("mvcPath", "/admin/import.jsp");
                importURL.setParameter("redirect", PortalUtil.getCurrentURL((HttpServletRequest)this._httpServletRequest));
                importURL.setParameter("parentKBFolderId", String.valueOf(parentResourcePrimKey));
                dropdownItem.setHref((Object)importURL);
                dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"import"));
            });
        }
        return creationMenu;
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(KBAdminManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)KBAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByType() {
        return this._searchContainer.getOrderByType();
    }

    public SearchContainer getSearchContainer() {
        return this._searchContainer;
    }

    public PortletURL getSearchURL() {
        PortletURL searchURL = this._liferayPortletResponse.createRenderURL();
        searchURL.setParameter("mvcPath", "/admin/search.jsp");
        searchURL.setParameter("redirect", this._getRedirect());
        return searchURL;
    }

    public PortletURL getSortingURL() throws PortletException {
        PortletURL sortingURL = this._getCurrentSortingURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL;
    }

    public int getTotal() {
        return this._searchContainer.getTotal();
    }

    public boolean isDisabled() {
        return !this._searchContainer.hasResults();
    }

    public boolean isShowInfoButton() {
        String keywords = this._getKeywords();
        return Validator.isNull((String)keywords);
    }

    private SearchContainer _createSearchContainer() throws PortalException, PortletException {
        String keywords;
        long kbFolderClassNameId = PortalUtil.getClassNameId((String)KBFolderConstants.getClassName());
        long parentResourceClassNameId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"parentResourceClassNameId", (long)kbFolderClassNameId);
        long parentResourcePrimKey = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"parentResourcePrimKey", (long)0L);
        this._searchContainer = new KBObjectsSearch((PortletRequest)this._renderRequest, PortletURLUtil.clone((PortletURL)PortletURLUtil.getCurrent((LiferayPortletRequest)this._liferayPortletRequest, (LiferayPortletResponse)this._liferayPortletResponse), (MimeResponse)this._renderResponse));
        boolean kbFolderView = false;
        if (parentResourceClassNameId == kbFolderClassNameId) {
            kbFolderView = true;
        }
        if (Validator.isNotNull((String)(keywords = this._getKeywords()))) {
            KBArticleSearchDisplay kbArticleSearchDisplay = KBArticleServiceUtil.getKBArticleSearchDisplay((long)this._themeDisplay.getScopeGroupId(), (String)keywords, (String)keywords, (int)-1, null, null, (boolean)false, (int[])new int[0], (int)this._searchContainer.getCur(), (int)this._searchContainer.getDelta(), (OrderByComparator)this._searchContainer.getOrderByComparator());
            this._searchContainer.setResults(kbArticleSearchDisplay.getResults());
            this._searchContainer.setTotal(kbArticleSearchDisplay.getTotal());
        } else if (kbFolderView) {
            this._searchContainer.setTotal(KBFolderServiceUtil.getKBFoldersAndKBArticlesCount((long)this._themeDisplay.getScopeGroupId(), (long)parentResourcePrimKey, (int)-1));
            this._searchContainer.setResults(KBFolderServiceUtil.getKBFoldersAndKBArticles((long)this._themeDisplay.getScopeGroupId(), (long)parentResourcePrimKey, (int)-1, (int)this._searchContainer.getStart(), (int)this._searchContainer.getEnd(), (OrderByComparator)this._searchContainer.getOrderByComparator()));
        } else {
            this._searchContainer.setTotal(KBArticleServiceUtil.getKBArticlesCount((long)this._themeDisplay.getScopeGroupId(), (long)parentResourcePrimKey, (int)-1));
            this._searchContainer.setResults(KBArticleServiceUtil.getKBArticles((long)this._themeDisplay.getScopeGroupId(), (long)parentResourcePrimKey, (int)-1, (int)this._searchContainer.getStart(), (int)this._searchContainer.getEnd(), (OrderByComparator)this._searchContainer.getOrderByComparator()));
        }
        this._searchContainer.setRowChecker((RowChecker)new EntriesChecker(this._liferayPortletRequest, this._liferayPortletResponse));
        return this._searchContainer;
    }

    private PortletURL _getCurrentSortingURL() throws PortletException {
        PortletURL sortingURL = PortletURLUtil.clone((PortletURL)PortletURLUtil.getCurrent((LiferayPortletRequest)this._liferayPortletRequest, (LiferayPortletResponse)this._liferayPortletResponse), (LiferayPortletResponse)this._liferayPortletResponse);
        String keywords = this._getKeywords();
        if (Validator.isNotNull((String)keywords)) {
            sortingURL.setParameter("keywords", keywords);
        }
        return sortingURL;
    }

    private String _getKeywords() {
        return ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
    }

    private String _getOrderByCol() {
        return this._searchContainer.getOrderByCol();
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                String[] orderColumns;
                HashMap<String, String> orderColumnsMap = new HashMap<String, String>();
                orderColumnsMap.put("modifiedDate", "modified-date");
                orderColumnsMap.put("priority", "priority");
                orderColumnsMap.put("title", "title");
                orderColumnsMap.put("viewCount", "view-count");
                for (String orderByCol : orderColumns = new String[]{"priority", "modifiedDate", "title", "viewCount"}) {
                    this.add(dropdownItem -> {
                        dropdownItem.setActive(orderByCol.equals(KBAdminManagementToolbarDisplayContext.this._getOrderByCol()));
                        dropdownItem.setHref(KBAdminManagementToolbarDisplayContext.this._getCurrentSortingURL(), new Object[]{"orderByCol", orderByCol});
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)KBAdminManagementToolbarDisplayContext.this._httpServletRequest, (String)((String)orderColumnsMap.get(orderByCol))));
                    });
                }
            }
        };
    }

    private String _getRedirect() {
        return PortalUtil.escapeRedirect((String)ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"redirect", (String)PortalUtil.getCurrentURL((HttpServletRequest)this._httpServletRequest)));
    }

    private String _getTemplatePath() {
        return this._portletConfig.getInitParameter("template-path");
    }
}

