/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal;

import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.model.KBTemplate;
import com.liferay.knowledge.base.service.KBFolderServiceUtil;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.knowledge.base.util.comparator.KBArticleCreateDateComparator;
import com.liferay.knowledge.base.util.comparator.KBArticleModifiedDateComparator;
import com.liferay.knowledge.base.util.comparator.KBArticlePriorityComparator;
import com.liferay.knowledge.base.util.comparator.KBArticleStatusComparator;
import com.liferay.knowledge.base.util.comparator.KBArticleTitleComparator;
import com.liferay.knowledge.base.util.comparator.KBArticleUserNameComparator;
import com.liferay.knowledge.base.util.comparator.KBArticleVersionComparator;
import com.liferay.knowledge.base.util.comparator.KBArticleViewCountComparator;
import com.liferay.knowledge.base.util.comparator.KBCommentCreateDateComparator;
import com.liferay.knowledge.base.util.comparator.KBCommentModifiedDateComparator;
import com.liferay.knowledge.base.util.comparator.KBCommentStatusComparator;
import com.liferay.knowledge.base.util.comparator.KBCommentUserNameComparator;
import com.liferay.knowledge.base.util.comparator.KBFolderNameComparator;
import com.liferay.knowledge.base.util.comparator.KBObjectsModifiedDateComparator;
import com.liferay.knowledge.base.util.comparator.KBObjectsPriorityComparator;
import com.liferay.knowledge.base.util.comparator.KBObjectsTitleComparator;
import com.liferay.knowledge.base.util.comparator.KBObjectsViewCountComparator;
import com.liferay.knowledge.base.util.comparator.KBTemplateCreateDateComparator;
import com.liferay.knowledge.base.util.comparator.KBTemplateModifiedDateComparator;
import com.liferay.knowledge.base.util.comparator.KBTemplateTitleComparator;
import com.liferay.knowledge.base.util.comparator.KBTemplateUserNameComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;

public class KBUtil {
    public static List<KBFolder> getAlternateRootKBFolders(long groupId, long kbFolderId) throws PortalException {
        ArrayList kbFolders = KBFolderServiceUtil.getKBFolders((long)groupId, (long)kbFolderId, (int)-1, (int)-1);
        kbFolders = new ArrayList(kbFolders);
        Iterator itr = kbFolders.iterator();
        while (itr.hasNext()) {
            KBFolder kbFolder = (KBFolder)itr.next();
            if (!kbFolder.isEmpty()) continue;
            itr.remove();
        }
        return ListUtil.sort(kbFolders, (Comparator)new KBFolderNameComparator(false));
    }

    public static OrderByComparator getKBArticleOrderByComparator(String orderByCol, String orderByType) {
        if (Validator.isNull((String)orderByCol) || Validator.isNull((String)orderByType)) {
            return null;
        }
        boolean ascending = false;
        if (orderByType.equals("asc")) {
            ascending = true;
        }
        if (orderByCol.equals("create-date")) {
            return new KBArticleCreateDateComparator(ascending);
        }
        if (orderByCol.equals("modified-date")) {
            return new KBArticleModifiedDateComparator(ascending);
        }
        if (orderByCol.equals("priority")) {
            return new KBArticlePriorityComparator(ascending);
        }
        if (orderByCol.equals("status")) {
            return new KBArticleStatusComparator(ascending);
        }
        if (orderByCol.equals("title")) {
            return new KBArticleTitleComparator(ascending);
        }
        if (orderByCol.equals("user-name")) {
            return new KBArticleUserNameComparator(ascending);
        }
        if (orderByCol.equals("version")) {
            return new KBArticleVersionComparator(ascending);
        }
        if (orderByCol.equals("view-count")) {
            return new KBArticleViewCountComparator(ascending);
        }
        return null;
    }

    public static Sort[] getKBArticleSorts(String orderByCol, String orderByType) {
        if (Validator.isNull((String)orderByCol) || Validator.isNull((String)orderByType)) {
            return SortFactoryUtil.getDefaultSorts();
        }
        boolean reverse = true;
        if (orderByType.equals("asc")) {
            reverse = false;
        }
        if (orderByCol.equals("create-date")) {
            String fieldName = "createDate";
            return new Sort[]{SortFactoryUtil.create((String)fieldName, (int)6, (boolean)reverse), SortFactoryUtil.create(null, (int)0, (boolean)false)};
        }
        if (orderByCol.equals("modified-date")) {
            String fieldName = "modified";
            return new Sort[]{SortFactoryUtil.create((String)fieldName, (int)6, (boolean)reverse), SortFactoryUtil.create(null, (int)0, (boolean)false)};
        }
        if (orderByCol.equals("score")) {
            String fieldName = null;
            return new Sort[]{SortFactoryUtil.create(fieldName, (int)0, (!reverse ? 1 : 0) != 0), SortFactoryUtil.create((String)"modified", (int)6, (boolean)true)};
        }
        if (orderByCol.equals("title")) {
            String fieldName = "titleKeyword";
            return new Sort[]{SortFactoryUtil.create((String)fieldName, (int)3, (boolean)reverse), SortFactoryUtil.create(null, (int)0, (boolean)false)};
        }
        if (orderByCol.equals("user-name")) {
            String fieldName = "userName";
            return new Sort[]{SortFactoryUtil.create((String)fieldName, (int)3, (boolean)reverse), SortFactoryUtil.create(null, (int)0, (boolean)false)};
        }
        return SortFactoryUtil.getDefaultSorts();
    }

    public static OrderByComparator<KBComment> getKBCommentOrderByComparator(String orderByCol, String orderByType) {
        if (Validator.isNull((String)orderByCol) || Validator.isNull((String)orderByType)) {
            return new KBCommentStatusComparator();
        }
        boolean ascending = false;
        if (orderByType.equals("asc")) {
            ascending = true;
        }
        if (orderByCol.equals("create-date")) {
            return new KBCommentCreateDateComparator(ascending);
        }
        if (orderByCol.equals("modified-date")) {
            return new KBCommentModifiedDateComparator(ascending);
        }
        if (orderByCol.equals("status")) {
            return new KBCommentStatusComparator(ascending);
        }
        if (orderByCol.equals("user-name")) {
            return new KBCommentUserNameComparator(ascending);
        }
        return null;
    }

    public static OrderByComparator<Object> getKBObjectsOrderByComparator(String orderByCol, String orderByType) {
        if (Validator.isNull((String)orderByCol) || Validator.isNull((String)orderByType)) {
            return null;
        }
        boolean ascending = false;
        if (orderByType.equals("asc")) {
            ascending = true;
        }
        if (orderByCol.equals("modified-date")) {
            return new KBObjectsModifiedDateComparator(ascending, true);
        }
        if (orderByCol.equals("priority")) {
            return new KBObjectsPriorityComparator(ascending);
        }
        if (orderByCol.equals("title")) {
            return new KBObjectsTitleComparator(ascending, true);
        }
        if (orderByCol.equals("view-count")) {
            return new KBObjectsViewCountComparator(ascending);
        }
        return null;
    }

    public static OrderByComparator<KBTemplate> getKBTemplateOrderByComparator(String orderByCol, String orderByType) {
        if (Validator.isNull((String)orderByCol) || Validator.isNull((String)orderByType)) {
            return null;
        }
        boolean ascending = false;
        if (orderByType.equals("asc")) {
            ascending = true;
        }
        if (orderByCol.equals("create-date")) {
            return new KBTemplateCreateDateComparator(ascending);
        }
        if (orderByCol.equals("modified-date")) {
            return new KBTemplateModifiedDateComparator(ascending);
        }
        if (orderByCol.equals("title")) {
            return new KBTemplateTitleComparator(ascending);
        }
        if (orderByCol.equals("user-name")) {
            return new KBTemplateUserNameComparator(ascending);
        }
        return null;
    }

    public static final int getNextStatus(int status) {
        if (status == 2) {
            return 0;
        }
        if (status == 1) {
            return 2;
        }
        return -2;
    }

    public static String getPreferredKBFolderURLTitle(PortalPreferences portalPreferences, String contentRootPrefix) throws JSONException {
        String preferredKBFolderURLTitle = portalPreferences.getValue("com_liferay_knowledge_base_web_portlet_DisplayPortlet", "preferredKBFolderURLTitle", "{}");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)preferredKBFolderURLTitle);
        return jsonObject.getString(contentRootPrefix, "");
    }

    public static final int getPreviousStatus(int status) {
        if (status == 0) {
            return 2;
        }
        if (status == 2) {
            return 1;
        }
        return -2;
    }

    public static long getRootResourcePrimKey(PortletRequest portletRequest, long groupId, long resourceClassNameId, long resourcePrimKey) throws PortalException {
        long kbFolderClassNameId = PortalUtil.getClassNameId((String)KBFolderConstants.getClassName());
        if (resourceClassNameId == kbFolderClassNameId) {
            return KBUtil._getCurrentRootKBFolder(portletRequest, groupId, resourcePrimKey);
        }
        return KnowledgeBaseUtil.getKBFolderId((long)resourceClassNameId, (long)resourcePrimKey);
    }

    public static final String getStatusLabel(int status) {
        if (status == 0) {
            return "resolved";
        }
        if (status == 2) {
            return "in-progress";
        }
        if (status == 1) {
            return "new";
        }
        throw new IllegalArgumentException(String.format("Invalid suggestion status %s", status));
    }

    public static final String getStatusTransitionLabel(int status) {
        if (status == 0) {
            return "resolve";
        }
        if (status == 2) {
            return "move-to-in-progress";
        }
        if (status == 1) {
            return "move-to-new";
        }
        throw new IllegalArgumentException(String.format("Invalid suggestion status %s", status));
    }

    private static long _getCurrentRootKBFolder(PortletRequest portletRequest, long groupId, long kbFolderId) throws PortalException {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
        PortletPreferences portletPreferences = portletRequest.getPreferences();
        String contentRootPrefix = GetterUtil.getString((String)portletPreferences.getValue("contentRootPrefix", null));
        String kbFolderURLTitle = KBUtil.getPreferredKBFolderURLTitle(portalPreferences, contentRootPrefix);
        long childKbFolderId = 0L;
        if (kbFolderURLTitle == null) {
            List<KBFolder> kbFolders = KBUtil.getAlternateRootKBFolders(groupId, kbFolderId);
            if (!kbFolders.isEmpty()) {
                KBFolder kbFolder = kbFolders.get(0);
                childKbFolderId = kbFolder.getKbFolderId();
            }
        } else {
            KBFolder kbFolder = KBFolderServiceUtil.fetchKBFolderByUrlTitle((long)groupId, (long)kbFolderId, (String)kbFolderURLTitle);
            if (kbFolder != null) {
                childKbFolderId = kbFolder.getKbFolderId();
            }
        }
        return childKbFolderId;
    }
}

