<%--
/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
--%>

<%@ include file="/display/init.jsp" %>

<%
KBArticle kbArticle = (KBArticle)request.getAttribute(KBWebKeys.KNOWLEDGE_BASE_KB_ARTICLE);

KBNavigationDisplayContext kbNavigationDisplayContext = (KBNavigationDisplayContext)request.getAttribute(KBWebKeys.KNOWLEDGE_BASE_KB_NAVIGATION_DISPLAY_CONTEXT);

String currentKBFolderURLTitle = kbNavigationDisplayContext.getCurrentKBFolderURLTitle();

List<KBFolder> kbFolders = KBUtil.getAlternateRootKBFolders(scopeGroupId, kbDisplayPortletInstanceConfiguration.resourcePrimKey());
%>

<c:if test="<%= kbFolders.size() > 1 %>">
	<liferay-portlet:actionURL name="updateRootKBFolderId" var="updateRootKBFolderIdURL">
		<c:if test="<%= kbArticle != null %>">
			<portlet:param name="urlTitle" value="<%= kbArticle.getUrlTitle() %>" />
		</c:if>
	</liferay-portlet:actionURL>

	<div class="kbarticle-root-selector">
		<aui:form action="<%= updateRootKBFolderIdURL %>" name="updateRootKBFolderIdFm">
			<aui:select label="" name="rootKBFolderId">

				<%
				for (KBFolder kbFolder : kbFolders) {
				%>

					<aui:option selected="<%= currentKBFolderURLTitle.equals(kbFolder.getUrlTitle()) %>" value="<%= kbFolder.getKbFolderId() %>">
						<%= HtmlUtil.escape(kbDisplayPortletInstanceConfiguration.contentRootPrefix() + " " + kbFolder.getName()) %>
					</aui:option>

				<%
				}
				%>

			</aui:select>
		</aui:form>
	</div>

	<aui:script>
		var <portlet:namespace />form = document.querySelector('#<portlet:namespace />updateRootKBFolderIdFm');

		if (<portlet:namespace />form) {
			<portlet:namespace />form.querySelector('#<portlet:namespace />rootKBFolderId').addEventListener(
				'change',
				function() {
					<portlet:namespace />form.submit();
				}
			);
		}
	</aui:script>
</c:if>