/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.upload;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.upload.UniqueFileNameProvider;
import com.liferay.upload.UploadFileEntryHandler;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={KBArticleAttachmentKBUploadFileEntryHandler.class})
public class KBArticleAttachmentKBUploadFileEntryHandler
implements UploadFileEntryHandler {
    private static final String _PARAMETER_NAME = "imageSelectorFileName";
    private static final Log _log = LogFactoryUtil.getLog(KBArticleAttachmentKBUploadFileEntryHandler.class);
    @Reference
    private KBArticleLocalService _kbArticleLocalService;
    @Reference(target="(model.class.name=com.liferay.knowledge.base.model.KBArticle)")
    private ModelResourcePermission<KBArticle> _kbArticleModelResourcePermission;
    @Reference
    private UniqueFileNameProvider _uniqueFileNameProvider;

    public FileEntry upload(UploadPortletRequest uploadPortletRequest) throws IOException, PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)uploadPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long resourcePrimKey = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"resourcePrimKey");
        KBArticle kbArticle = this._kbArticleLocalService.getLatestKBArticle(resourcePrimKey, 0);
        this._kbArticleModelResourcePermission.check(themeDisplay.getPermissionChecker(), (ClassedModel)kbArticle, "UPDATE");
        String fileName = uploadPortletRequest.getFileName(_PARAMETER_NAME);
        String contentType = uploadPortletRequest.getContentType(_PARAMETER_NAME);
        try (InputStream inputStream = uploadPortletRequest.getFileAsStream(_PARAMETER_NAME);){
            String uniqueFileName = this._uniqueFileNameProvider.provide(fileName, curFileName -> this._exists(themeDisplay, kbArticle, (String)curFileName));
            FileEntry fileEntry = this._kbArticleLocalService.addAttachment(themeDisplay.getUserId(), resourcePrimKey, uniqueFileName, inputStream, contentType);
            return fileEntry;
        }
    }

    private boolean _exists(ThemeDisplay themeDisplay, KBArticle kbArticle, String fileName) {
        try {
            return PortletFileRepositoryUtil.getPortletFileEntry((long)themeDisplay.getScopeGroupId(), (long)kbArticle.getAttachmentsFolderId(), (String)fileName) != null;
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
    }
}

