/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.portlet;

import com.liferay.knowledge.base.exception.NoSuchArticleException;
import com.liferay.knowledge.base.exception.NoSuchCommentException;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.web.internal.portlet.BaseKBPortlet;
import com.liferay.portal.kernel.exception.NoSuchSubscriptionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=knowledge-base-portlet knowledge-base-portlet-article", "com.liferay.portlet.display-category=category.cms", "com.liferay.portlet.header-portlet-css=/admin/css/common.css", "com.liferay.portlet.header-portlet-css=/article/css/main.css", "com.liferay.portlet.icon=/icons/article.png", "com.liferay.portlet.instanceable=true", "com.liferay.portlet.scopeable=true", "com.liferay.portlet.struts-path=knowledge_base", "javax.portlet.display-name=Knowledge Base Article", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.always-send-redirect=true", "javax.portlet.init-param.copy-request-parameters=true", "javax.portlet.init-param.template-path=/article/", "javax.portlet.init-param.view-template=/article/view.jsp", "javax.portlet.name=com_liferay_knowledge_base_web_portlet_ArticlePortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator,guest,power-user,user", "javax.portlet.supported-public-render-parameter=categoryId", "javax.portlet.supported-public-render-parameter=tag", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class ArticlePortlet
extends BaseKBPortlet {
    private KBArticleLocalService _kbArticleLocalService;
    @Reference(target="(model.class.name=com.liferay.knowledge.base.model.KBArticle)")
    private ModelResourcePermission<KBArticle> _kbArticleModelResourcePermission;
    @Reference
    private Portal _portal;

    protected void addSuccessMessage(ActionRequest actionRequest, ActionResponse actionResponse) {
        String actionName = ParamUtil.getString((PortletRequest)actionRequest, (String)"javax.portlet.action");
        if (actionName.equals("deleteKBArticle")) {
            return;
        }
        super.addSuccessMessage(actionRequest, actionResponse);
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchArticleException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchCommentException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchSubscriptionException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses())) {
            this.include(this.templatePath + "error.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    @Override
    protected void doRender(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            renderRequest.setAttribute("DL_MIME_TYPE_DISPLAY_CONTEXT", (Object)this.dlMimeTypeDisplayContext);
            KBArticle kbArticle = null;
            long resourcePrimKey = this.getResourcePrimKey(renderRequest);
            if (resourcePrimKey > 0L) {
                kbArticle = this.kbArticleService.getLatestKBArticle(resourcePrimKey, 0);
            }
            renderRequest.setAttribute("KNOWLEDGE_BASE_KB_ARTICLE", kbArticle);
            renderRequest.setAttribute("KNOWLEDGE_BASE_STATUS", (Object)0);
        }
        catch (Exception e) {
            if (e instanceof NoSuchArticleException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                SessionMessages.add((PortletRequest)renderRequest, (String)(this.portal.getPortletId((PortletRequest)renderRequest) + ".hideDefaultErrorMessage"));
            }
            throw new PortletException((Throwable)e);
        }
    }

    protected long getResourcePrimKey(RenderRequest renderRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletPreferences preferences = renderRequest.getPreferences();
        long defaultValue = GetterUtil.getLong((String)preferences.getValue("resourcePrimKey", null));
        KBArticle defaultKBArticle = this.kbArticleService.fetchLatestKBArticle(defaultValue, -1);
        if (defaultKBArticle == null) {
            defaultValue = 0L;
        }
        String mvcPath = ParamUtil.getString((PortletRequest)renderRequest, (String)"mvcPath");
        if (defaultValue == 0L && mvcPath.equals(this.viewTemplate)) {
            return 0L;
        }
        long resourcePrimKey = this.getResourcePrimKeyFromUrlTitle(renderRequest);
        if (resourcePrimKey == 0L) {
            resourcePrimKey = ParamUtil.getLong((PortletRequest)renderRequest, (String)"resourcePrimKey", (long)defaultValue);
        }
        if (resourcePrimKey == 0L || resourcePrimKey != defaultValue) {
            return resourcePrimKey;
        }
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!this._kbArticleModelResourcePermission.contains(permissionChecker, defaultValue, "VIEW")) {
            return 0L;
        }
        return defaultValue;
    }

    protected long getResourcePrimKeyFromUrlTitle(RenderRequest renderRequest) throws PortalException {
        String urlTitle = ParamUtil.getString((PortletRequest)renderRequest, (String)"urlTitle");
        if (Validator.isNull((String)urlTitle)) {
            return 0L;
        }
        String kbFolderUrlTitle = ParamUtil.getString((PortletRequest)renderRequest, (String)"kbFolderUrlTitle");
        KBArticle kbArticle = null;
        kbArticle = Validator.isNull((String)kbFolderUrlTitle) ? this._kbArticleLocalService.fetchKBArticleByUrlTitle(this._portal.getScopeGroupId((PortletRequest)renderRequest), 0L, urlTitle) : this._kbArticleLocalService.fetchKBArticleByUrlTitle(this._portal.getScopeGroupId((PortletRequest)renderRequest), kbFolderUrlTitle, urlTitle);
        if (kbArticle != null) {
            return kbArticle.getResourcePrimKey();
        }
        return 0L;
    }

    @Reference(unbind="-")
    protected void setKBArticleLocalService(KBArticleLocalService kbArticleLocalService) {
        this._kbArticleLocalService = kbArticleLocalService;
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.knowledge.base.web)(release.schema.version=1.2.0))", unbind="-")
    protected void setRelease(Release release) {
    }
}

