/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.exportimport.portlet.preferences.processor;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.knowledge.base.constants.KBArticleConstants;
import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.service.KBFolderLocalService;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_knowledge_base_web_portlet_DisplayPortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class KBDisplayExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    @Reference(target="(name=ReferencedStagedModelImporter)")
    private Capability _capability;
    private KBArticleLocalService _kbArticleLocalService;
    private KBFolderLocalService _kbFolderLocalService;
    @Reference
    private Portal _portal;

    public List<Capability> getExportCapabilities() {
        return null;
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._capability});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        long resourcePrimKey = GetterUtil.getLong((String)portletPreferences.getValue("resourcePrimKey", ""));
        long resourceClassNameId = GetterUtil.getLong((String)portletPreferences.getValue("resourceClassNameId", ""));
        String resourceClassName = resourcePrimKey == 0L && resourceClassNameId == 0L ? KBFolderConstants.getClassName() : this._portal.getClassName(resourceClassNameId);
        try {
            portletPreferences.setValue("resourceClassNameId", resourceClassName);
        }
        catch (ReadOnlyException roe) {
            StringBundler sb = new StringBundler(7);
            sb.append("Unable to save converted portlet preference ");
            sb.append("\"resourceClassNameId\" from ");
            sb.append(resourceClassNameId);
            sb.append(" to ");
            sb.append(resourceClassName);
            sb.append(" while exporting KB Display portlet ");
            sb.append(portletDataContext.getPortletId());
            throw new PortletDataException(sb.toString(), (Throwable)roe);
        }
        if (resourceClassName.equals(KBArticleConstants.getClassName())) {
            if (resourcePrimKey != 0L) {
                List kbArticles = this._kbArticleLocalService.getKBArticleAndAllDescendantKBArticles(resourcePrimKey, 0, null);
                for (KBArticle kbArticle : kbArticles) {
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletDataContext.getPortletId(), (StagedModel)kbArticle);
                }
            }
        } else if (resourceClassName.equals(KBFolderConstants.getClassName()) && resourcePrimKey != 0L) {
            KBFolder rootFolder = this._kbFolderLocalService.fetchKBFolder(resourcePrimKey);
            if (rootFolder == null) {
                StringBundler sb = new StringBundler(4);
                sb.append("KB Display portlet with ID ");
                sb.append(portletDataContext.getPortletId());
                sb.append(" refers to an inexistent root folder: ");
                sb.append(resourcePrimKey);
                throw new PortletDataException(sb.toString());
            }
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletDataContext.getPortletId(), (StagedModel)rootFolder);
        }
        return portletPreferences;
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        String resourceClassName = GetterUtil.getString((String)portletPreferences.getValue("resourceClassNameId", ""));
        try {
            portletPreferences.setValue("resourceClassNameId", String.valueOf(this._portal.getClassNameId(resourceClassName)));
        }
        catch (ReadOnlyException roe) {
            StringBundler sb = new StringBundler(7);
            sb.append("Unable to save reconverted portlet preference ");
            sb.append("\"resourceClassNameId\" from ");
            sb.append(resourceClassName);
            sb.append(" to ");
            sb.append(this._portal.getClassNameId(resourceClassName));
            sb.append(" while importing KB Display portlet ");
            sb.append(portletDataContext.getPortletId());
            throw new PortletDataException(sb.toString(), (Throwable)roe);
        }
        long resourcePrimKey = GetterUtil.getLong((String)portletPreferences.getValue("resourcePrimKey", ""));
        Map resourcePrimKeys = new HashMap();
        if (resourceClassName.equals(KBArticleConstants.getClassName())) {
            resourcePrimKeys = portletDataContext.getNewPrimaryKeysMap(KBArticle.class);
        } else if (resourceClassName.equals(KBFolderConstants.getClassName())) {
            resourcePrimKeys = portletDataContext.getNewPrimaryKeysMap(KBFolder.class);
        }
        resourcePrimKey = MapUtil.getLong(resourcePrimKeys, (long)resourcePrimKey, (long)resourcePrimKey);
        try {
            portletPreferences.setValue("resourcePrimKey", String.valueOf(resourcePrimKey));
        }
        catch (ReadOnlyException roe) {
            StringBundler sb = new StringBundler(5);
            sb.append("Unable to save converted portlet preference ");
            sb.append("\"resourcePrimKey\" ");
            sb.append(resourcePrimKey);
            sb.append(" while importing KB Display portlet ");
            sb.append(portletDataContext.getPortletId());
            throw new PortletDataException(sb.toString(), (Throwable)roe);
        }
        return portletPreferences;
    }

    @Reference(unbind="-")
    protected void seKBArticleLocalService(KBArticleLocalService kbArticleLocalService) {
        this._kbArticleLocalService = kbArticleLocalService;
    }

    @Reference(unbind="-")
    protected void seKBFolderLocalService(KBFolderLocalService kbFolderLocalService) {
        this._kbFolderLocalService = kbFolderLocalService;
    }
}

