/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.display.context.util;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBFolderServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class KBArticleURLHelper {
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final String _templatePath;

    public KBArticleURLHelper(RenderRequest renderRequest, RenderResponse renderResponse, String templatePath) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._templatePath = templatePath;
    }

    public PortletURL createViewURL(KBArticle kbArticle) throws PortalException {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        String portletId = PortalUtil.getPortletId((PortletRequest)this._renderRequest);
        if (portletId.startsWith("com_liferay_knowledge_base_web_portlet_AdminPortlet") || portletId.startsWith("com_liferay_knowledge_base_web_portlet_SearchPortlet") || portletId.startsWith("com_liferay_knowledge_base_web_portlet_SectionPortlet")) {
            portletURL.setParameter("mvcPath", this._templatePath + "view_article.jsp");
        }
        if (Validator.isNull((String)kbArticle.getUrlTitle()) || portletId.equals("com_liferay_knowledge_base_web_portlet_AdminPortlet") || portletId.equals("com_liferay_knowledge_base_web_portlet_SearchPortlet")) {
            portletURL.setParameter("resourceClassNameId", String.valueOf(kbArticle.getClassNameId()));
            portletURL.setParameter("resourcePrimKey", String.valueOf(kbArticle.getResourcePrimKey()));
        } else {
            portletURL.setParameter("urlTitle", kbArticle.getUrlTitle());
            if (kbArticle.getKbFolderId() != 0L) {
                KBFolder kbFolder = KBFolderServiceUtil.getKBFolder((long)kbArticle.getKbFolderId());
                portletURL.setParameter("kbFolderUrlTitle", kbFolder.getUrlTitle());
            }
        }
        return portletURL;
    }

    public PortletURL createViewWithCommentsURL(KBArticle kbArticle) throws PortalException {
        PortletURL portletURL = this.createViewURL(kbArticle);
        portletURL.setParameter("expanded", Boolean.TRUE.toString());
        return portletURL;
    }

    public PortletURL createViewWithRedirectURL(KBArticle kbArticle, String redirect) throws PortalException {
        PortletURL portletURL = this.createViewURL(kbArticle);
        if (Validator.isNotNull((String)redirect)) {
            portletURL.setParameter("redirect", redirect);
        }
        return portletURL;
    }
}

