/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.display.context;

import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleServiceUtil;
import com.liferay.knowledge.base.service.KBFolderServiceUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class KBSelectParentDisplayContext {
    private final LiferayPortletResponse _liferayPortletResponse;
    private final long _parentResourceClassNameId;
    private final long _parentResourcePrimKey;
    private final HttpServletRequest _request;

    public KBSelectParentDisplayContext(long parentResourceClassNameId, long parentResourcePrimKey, HttpServletRequest request, LiferayPortletResponse liferayPortletResponse) {
        this._parentResourceClassNameId = parentResourceClassNameId;
        this._parentResourcePrimKey = parentResourcePrimKey;
        this._request = request;
        this._liferayPortletResponse = liferayPortletResponse;
    }

    public void populatePortletBreadcrumbEntries(PortletURL portletURL) throws Exception {
        this._populatePortletBreadcrumbEntries(this._parentResourceClassNameId, this._parentResourcePrimKey, portletURL);
    }

    private void _populatePortletBreadcrumbEntries(long parentResourceClassNameId, long parentResourcePrimKey, PortletURL portletURL) throws Exception {
        PortletURL currentURL = PortletURLUtil.clone((PortletURL)portletURL, (LiferayPortletResponse)this._liferayPortletResponse);
        currentURL.setParameter("parentResourceClassNameId", String.valueOf(parentResourceClassNameId));
        currentURL.setParameter("parentResourcePrimKey", String.valueOf(parentResourcePrimKey));
        long kbFolderClassNameId = PortalUtil.getClassNameId((String)KBFolderConstants.getClassName());
        if (parentResourcePrimKey == 0L) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)this._request, (String)themeDisplay.translate("home"), (String)currentURL.toString());
        } else if (parentResourceClassNameId == kbFolderClassNameId) {
            KBFolder kbFolder = KBFolderServiceUtil.getKBFolder((long)parentResourcePrimKey);
            this._populatePortletBreadcrumbEntries(kbFolder.getClassNameId(), kbFolder.getParentKBFolderId(), currentURL);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)this._request, (String)kbFolder.getName(), (String)currentURL.toString());
        } else {
            KBArticle kbArticle = KBArticleServiceUtil.getLatestKBArticle((long)parentResourcePrimKey, (int)-1);
            this._populatePortletBreadcrumbEntries(kbArticle.getParentResourceClassNameId(), kbArticle.getParentResourcePrimKey(), currentURL);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)this._request, (String)kbArticle.getTitle(), (String)currentURL.toString());
        }
    }
}

