/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.social;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.model.KBTemplate;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.service.KBCommentLocalService;
import com.liferay.knowledge.base.service.KBTemplateLocalService;
import com.liferay.knowledge.base.service.permission.KBArticlePermission;
import com.liferay.knowledge.base.service.permission.KBTemplatePermission;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ClassResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.social.kernel.model.BaseSocialActivityInterpreter;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_knowledge_base_web_portlet_AdminPortlet"}, service={SocialActivityInterpreter.class})
public class KBActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{KBArticle.class.getName(), KBComment.class.getName(), KBTemplate.class.getName()};
    private KBArticleLocalService _kbArticleLocalService;
    private KBCommentLocalService _kbCommentLocalService;
    private KBTemplateLocalService _kbTemplateLocalService;
    private final ResourceBundleLoader _resourceBundleLoader = new ClassResourceBundleLoader("content.Language", KBActivityInterpreter.class);

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getEntryTitle(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        String title = "";
        String className = activity.getClassName();
        if (className.equals(KBArticle.class.getName())) {
            KBArticle kbArticle = this._kbArticleLocalService.getLatestKBArticle(activity.getClassPK(), 0);
            title = kbArticle.getTitle();
        } else if (className.equals(KBComment.class.getName())) {
            KBComment kbComment = this._kbCommentLocalService.getKBComment(activity.getClassPK());
            String kbCommentClassName = kbComment.getClassName();
            if (kbCommentClassName.equals(KBArticle.class.getName())) {
                KBArticle kbArticle = this._kbArticleLocalService.getLatestKBArticle(kbComment.getClassPK(), 0);
                title = kbArticle.getTitle();
            } else if (kbCommentClassName.equals(KBTemplate.class.getName())) {
                KBTemplate kbTemplate = this._kbTemplateLocalService.getKBTemplate(kbComment.getClassPK());
                title = kbTemplate.getTitle();
            }
        } else if (className.equals(KBTemplate.class.getName())) {
            KBTemplate kbTemplate = this._kbTemplateLocalService.getKBTemplate(activity.getClassPK());
            title = kbTemplate.getTitle();
        }
        return this.getJSONValue(activity.getExtraData(), "title", title);
    }

    protected String getLink(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        KBComment kbComment;
        String kbCommentClassName;
        String className = activity.getClassName();
        if (className.equals(KBArticle.class.getName())) {
            KBArticle kbArticle = this._kbArticleLocalService.getLatestKBArticle(activity.getClassPK(), 0);
            return KnowledgeBaseUtil.getKBArticleURL((long)serviceContext.getPlid(), (long)kbArticle.getResourcePrimKey(), (int)kbArticle.getStatus(), (String)serviceContext.getPortalURL(), (boolean)false);
        }
        if (className.equals(KBComment.class.getName()) && (kbCommentClassName = (kbComment = this._kbCommentLocalService.getKBComment(activity.getClassPK())).getClassName()).equals(KBArticle.class.getName())) {
            KBArticle kbArticle = this._kbArticleLocalService.getLatestKBArticle(activity.getClassPK(), 0);
            return KnowledgeBaseUtil.getKBArticleURL((long)serviceContext.getPlid(), (long)kbArticle.getResourcePrimKey(), (int)kbArticle.getStatus(), (String)serviceContext.getPortalURL(), (boolean)false);
        }
        return "";
    }

    protected ResourceBundleLoader getResourceBundleLoader() {
        return this._resourceBundleLoader;
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) {
        String className = activity.getClassName();
        if (className.equals(KBArticle.class.getName())) {
            if (activity.getType() == 1) {
                if (Validator.isNull((String)groupName)) {
                    return "activity-knowledge-base-admin-add-kb-article";
                }
                return "activity-knowledge-base-admin-add-kb-article-in";
            }
            if (activity.getType() == 7) {
                if (Validator.isNull((String)groupName)) {
                    return "activity-knowledge-base-admin-move-kb-article";
                }
                return "activity-knowledge-base-admin-move-kb-article-in";
            }
            if (activity.getType() == 3) {
                if (Validator.isNull((String)groupName)) {
                    return "activity-knowledge-base-admin-update-kb-article";
                }
                return "activity-knowledge-base-admin-update-kb-article-in";
            }
        } else if (className.equals(KBComment.class.getName())) {
            if (activity.getType() == 5) {
                if (Validator.isNull((String)groupName)) {
                    return "activity-knowledge-base-admin-add-kb-comment";
                }
                return "activity-knowledge-base-admin-add-kb-comment-in";
            }
            if (activity.getType() == 6) {
                if (Validator.isNull((String)groupName)) {
                    return "activity-knowledge-base-admin-update-kb-comment";
                }
                return "activity-knowledge-base-admin-update-kb-comment-in";
            }
        } else if (className.equals(KBTemplate.class.getName())) {
            if (activity.getType() == 2) {
                if (Validator.isNull((String)groupName)) {
                    return "activity-knowledge-base-admin-add-kb-template";
                }
                return "activity-knowledge-base-admin-add-kb-template-in";
            }
            if (activity.getType() == 4) {
                if (Validator.isNull((String)groupName)) {
                    return "activity-knowledge-base-admin-update-kb-template";
                }
                return "activity-knowledge-base-admin-update-kb-template-in";
            }
        }
        return "";
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        String className = activity.getClassName();
        if (className.equals(KBArticle.class.getName())) {
            KBArticle kbArticle = this._kbArticleLocalService.getLatestKBArticle(activity.getClassPK(), 0);
            return KBArticlePermission.contains((PermissionChecker)permissionChecker, (KBArticle)kbArticle, (String)"VIEW");
        }
        if (className.equals(KBComment.class.getName())) {
            return true;
        }
        if (className.equals(KBTemplate.class.getName())) {
            KBTemplate kbTemplate = this._kbTemplateLocalService.getKBTemplate(activity.getClassPK());
            return KBTemplatePermission.contains((PermissionChecker)permissionChecker, (KBTemplate)kbTemplate, (String)"VIEW");
        }
        return false;
    }

    @Reference(unbind="-")
    protected void setKBArticleLocalService(KBArticleLocalService kbArticleLocalService) {
        this._kbArticleLocalService = kbArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setKBCommentLocalService(KBCommentLocalService kbCommentLocalService) {
        this._kbCommentLocalService = kbCommentLocalService;
    }

    @Reference(unbind="-")
    protected void setKBTemplateLocalService(KBTemplateLocalService kbTemplateLocalService) {
        this._kbTemplateLocalService = kbTemplateLocalService;
    }
}

