/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.selector;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.model.impl.KBFolderImpl;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.service.KBFolderLocalService;
import com.liferay.knowledge.base.web.selector.KBArticleSelection;
import com.liferay.knowledge.base.web.selector.KBArticleSelector;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.knowledge.base.model.KBFolder"}, service={KBArticleSelector.class})
public class KBFolderKBArticleSelector
implements KBArticleSelector {
    private static final KBFolder _rootKBFolder = new KBFolderImpl();
    private KBArticleLocalService _kbArticleLocalService;
    private KBFolderLocalService _kbFolderLocalService;

    @Override
    public KBArticleSelection findByResourcePrimKey(long groupId, String preferredKBFolderUrlTitle, long ancestorResourcePrimKey, long resourcePrimKey) throws PortalException {
        KBFolder ancestorKBFolder = _rootKBFolder;
        if (ancestorResourcePrimKey != 0L && (ancestorKBFolder = this._kbFolderLocalService.fetchKBFolder(ancestorResourcePrimKey)) == null) {
            return new KBArticleSelection(null, false);
        }
        KBArticle kbArticle = this._kbArticleLocalService.fetchLatestKBArticle(resourcePrimKey, 0);
        if (kbArticle == null || !this.isDescendant(kbArticle, ancestorKBFolder)) {
            KBArticleSelection kbArticleSelection = this.findFirstKBArticle(groupId, ancestorKBFolder, preferredKBFolderUrlTitle);
            if (resourcePrimKey == 0L) {
                kbArticleSelection.setExactMatch(true);
            }
            return kbArticleSelection;
        }
        return new KBArticleSelection(kbArticle, true);
    }

    @Override
    public KBArticleSelection findByUrlTitle(long groupId, String preferredKBFolderUrlTitle, long ancestorResourcePrimKey, String kbFolderUrlTitle, String urlTitle) throws PortalException {
        KBArticle kbArticle;
        KBFolder ancestorKBFolder = _rootKBFolder;
        if (ancestorResourcePrimKey != 0L && (ancestorKBFolder = this._kbFolderLocalService.fetchKBFolder(ancestorResourcePrimKey)) == null) {
            return new KBArticleSelection(null, false);
        }
        KBFolder kbFolder = _rootKBFolder;
        if (Validator.isNotNull((String)kbFolderUrlTitle)) {
            kbFolder = kbFolderUrlTitle.equals(ancestorKBFolder.getUrlTitle()) ? ancestorKBFolder : this._kbFolderLocalService.fetchKBFolderByUrlTitle(groupId, ancestorKBFolder.getKbFolderId(), kbFolderUrlTitle);
        }
        if ((kbArticle = this._kbArticleLocalService.fetchKBArticleByUrlTitle(groupId, kbFolder.getKbFolderId(), urlTitle)) == null || !this.isDescendant(kbArticle, ancestorKBFolder)) {
            return this.findClosestMatchingKBArticle(groupId, ancestorKBFolder, preferredKBFolderUrlTitle, kbFolderUrlTitle, urlTitle);
        }
        return new KBArticleSelection(kbArticle, true);
    }

    protected KBArticleSelection findClosestMatchingKBArticle(long groupId, KBFolder ancestorKBFolder, String preferredKBFolderUrlTitle, String kbFolderUrlTitle, String urlTitle) throws PortalException {
        KBFolder kbFolder = this.getCandidateKBFolder(groupId, preferredKBFolderUrlTitle, ancestorKBFolder, kbFolderUrlTitle);
        KBArticle kbArticle = this._kbArticleLocalService.fetchKBArticleByUrlTitle(groupId, kbFolder.getKbFolderId(), urlTitle);
        if (kbArticle != null) {
            return new KBArticleSelection(kbArticle, false);
        }
        kbArticle = this._kbArticleLocalService.fetchFirstChildKBArticle(groupId, kbFolder.getKbFolderId());
        String[] keywords = StringUtil.split((String)urlTitle, (char)'-');
        return new KBArticleSelection(kbArticle, keywords);
    }

    protected KBArticleSelection findFirstKBArticle(long groupId, KBFolder ancestorKBFolder, String preferredKBFolderUrlTitle) throws PortalException {
        KBFolder kbFolder = null;
        int kbArticlesCount = this._kbArticleLocalService.getKBArticlesCount(groupId, ancestorKBFolder.getKbFolderId(), 0);
        if (Validator.isNotNull((String)preferredKBFolderUrlTitle) && kbArticlesCount == 0) {
            kbFolder = this._kbFolderLocalService.fetchKBFolderByUrlTitle(groupId, ancestorKBFolder.getKbFolderId(), preferredKBFolderUrlTitle);
        }
        if (kbFolder == null && kbArticlesCount == 0) {
            kbFolder = this._kbFolderLocalService.fetchFirstChildKBFolder(groupId, ancestorKBFolder.getKbFolderId());
        }
        if (kbFolder == null) {
            kbFolder = ancestorKBFolder;
        }
        KBArticle kbArticle = this._kbArticleLocalService.fetchFirstChildKBArticle(groupId, kbFolder.getKbFolderId());
        return new KBArticleSelection(kbArticle, true);
    }

    protected KBFolder getCandidateKBFolder(long groupId, String preferredKBFolderUrlTitle, KBFolder ancestorKBFolder, String kbFolderUrlTitle) throws PortalException {
        KBFolder kbFolder = null;
        if (Validator.isNotNull((String)kbFolderUrlTitle)) {
            kbFolder = this._kbFolderLocalService.fetchKBFolderByUrlTitle(groupId, ancestorKBFolder.getKbFolderId(), kbFolderUrlTitle);
        }
        if (kbFolder == null && Validator.isNotNull((String)preferredKBFolderUrlTitle)) {
            kbFolder = this._kbFolderLocalService.fetchKBFolderByUrlTitle(groupId, ancestorKBFolder.getKbFolderId(), preferredKBFolderUrlTitle);
        }
        int kbArticlesCount = this._kbArticleLocalService.getKBArticlesCount(groupId, ancestorKBFolder.getKbFolderId(), 0);
        if (kbFolder == null && kbArticlesCount == 0) {
            kbFolder = this._kbFolderLocalService.fetchFirstChildKBFolder(groupId, ancestorKBFolder.getKbFolderId());
        }
        if (kbFolder == null) {
            return ancestorKBFolder;
        }
        return kbFolder;
    }

    protected boolean isDescendant(KBArticle kbArticle, KBFolder ancestorKBFolder) throws PortalException {
        if (ancestorKBFolder.getKbFolderId() == 0L) {
            return true;
        }
        KBFolder parentKBFolder = this._kbFolderLocalService.fetchKBFolder(kbArticle.getKbFolderId());
        while (parentKBFolder != null && !parentKBFolder.equals(ancestorKBFolder)) {
            parentKBFolder = this._kbFolderLocalService.fetchKBFolder(parentKBFolder.getParentKBFolderId());
        }
        return parentKBFolder != null;
    }

    @Reference(unbind="-")
    protected void setKBArticleLocalService(KBArticleLocalService kbArticleLocalService) {
        this._kbArticleLocalService = kbArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setKBFolderLocalService(KBFolderLocalService kbFolderLocalService) {
        this._kbFolderLocalService = kbFolderLocalService;
    }

    static {
        _rootKBFolder.setKbFolderId(0L);
    }
}

