/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.selector;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.web.selector.KBArticleSelection;
import com.liferay.knowledge.base.web.selector.KBArticleSelector;
import com.liferay.portal.kernel.exception.PortalException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.knowledge.base.model.KBArticle"}, service={KBArticleSelector.class})
public class KBArticleKBArticleSelector
implements KBArticleSelector {
    private KBArticleLocalService _kbArticleLocalService;

    @Override
    public KBArticleSelection findByResourcePrimKey(long groupId, String preferredKBFolderUrlTitle, long ancestorResourcePrimKey, long resourcePrimKey) throws PortalException {
        KBArticle ancestorKBArticle = this._kbArticleLocalService.fetchLatestKBArticle(ancestorResourcePrimKey, 0);
        if (ancestorKBArticle == null) {
            return new KBArticleSelection(null, false);
        }
        if (resourcePrimKey == 0L) {
            return new KBArticleSelection(ancestorKBArticle, true);
        }
        KBArticle kbArticle = this._kbArticleLocalService.fetchLatestKBArticle(resourcePrimKey, 0);
        return this.getClosestMatchingDescendantKBArticle(groupId, ancestorKBArticle, kbArticle);
    }

    @Override
    public KBArticleSelection findByUrlTitle(long groupId, String preferredKBFolderUrlTitle, long ancestorResourcePrimKey, String kbFolderUrlTitle, String urlTitle) throws PortalException {
        KBArticle ancestorKBArticle = this._kbArticleLocalService.fetchLatestKBArticle(ancestorResourcePrimKey, 0);
        if (ancestorKBArticle == null) {
            return new KBArticleSelection(null, false);
        }
        KBArticle kbArticle = this._kbArticleLocalService.fetchLatestKBArticleByUrlTitle(groupId, ancestorKBArticle.getKbFolderId(), urlTitle, 0);
        return this.getClosestMatchingDescendantKBArticle(groupId, ancestorKBArticle, kbArticle);
    }

    protected KBArticleSelection findClosestMatchingKBArticle(long groupId, KBArticle ancestorKBArticle, KBArticle kbArticle) throws PortalException {
        for (KBArticle candidateKBArticle = kbArticle; candidateKBArticle != null; candidateKBArticle = candidateKBArticle.getParentKBArticle()) {
            KBArticle matchingKBArticle = this._kbArticleLocalService.fetchKBArticleByUrlTitle(groupId, ancestorKBArticle.getKbFolderId(), candidateKBArticle.getUrlTitle());
            if (matchingKBArticle == null) continue;
            return new KBArticleSelection(matchingKBArticle, false);
        }
        return new KBArticleSelection(ancestorKBArticle, false);
    }

    protected KBArticleSelection getClosestMatchingDescendantKBArticle(long groupId, KBArticle ancestorKBArticle, KBArticle kbArticle) throws PortalException {
        if (kbArticle == null) {
            return new KBArticleSelection(ancestorKBArticle, false);
        }
        if (this.isDescendant(kbArticle, ancestorKBArticle)) {
            return new KBArticleSelection(kbArticle, true);
        }
        return this.findClosestMatchingKBArticle(groupId, ancestorKBArticle, kbArticle);
    }

    protected boolean isDescendant(KBArticle kbArticle, KBArticle ancestorKBArticle) throws PortalException {
        KBArticle parentKBArticle;
        if (kbArticle.getKbArticleId() == ancestorKBArticle.getKbArticleId()) {
            return true;
        }
        for (parentKBArticle = kbArticle.getParentKBArticle(); parentKBArticle != null && !parentKBArticle.equals(ancestorKBArticle); parentKBArticle = parentKBArticle.getParentKBArticle()) {
        }
        return parentKBArticle != null;
    }

    @Reference(unbind="-")
    protected void setKBArticleLocalService(KBArticleLocalService kbArticleLocalService) {
        this._kbArticleLocalService = kbArticleLocalService;
    }
}

