/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.search;

import com.liferay.knowledge.base.model.KBTemplate;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.knowledge.base.web.search.KBTemplateDisplayTerms;
import com.liferay.knowledge.base.web.search.KBTemplateSearchTerms;
import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class KBTemplateSearch
extends SearchContainer<KBTemplate> {
    public static final String EMPTY_RESULTS_MESSAGE = "no-templates-were-found";
    private static final Log _log = LogFactoryUtil.getLog(KBTemplateSearch.class);

    public KBTemplateSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new KBTemplateDisplayTerms(portletRequest), (DisplayTerms)new KBTemplateSearchTerms(portletRequest), "cur", DEFAULT_DELTA, iteratorURL, null, EMPTY_RESULTS_MESSAGE);
        KBTemplateDisplayTerms displayTerms = (KBTemplateDisplayTerms)this.getDisplayTerms();
        iteratorURL.setParameter("anytime", String.valueOf(displayTerms.isAnytime()));
        iteratorURL.setParameter("content", displayTerms.getContent());
        iteratorURL.setParameter("endDateDay", String.valueOf(displayTerms.getEndDateDay()));
        iteratorURL.setParameter("endDateMonth", String.valueOf(displayTerms.getEndDateMonth()));
        iteratorURL.setParameter("endDateYear", String.valueOf(displayTerms.getEndDateYear()));
        iteratorURL.setParameter("startDateDay", String.valueOf(displayTerms.getStartDateDay()));
        iteratorURL.setParameter("startDateMonth", String.valueOf(displayTerms.getStartDateMonth()));
        iteratorURL.setParameter("startDateYear", String.valueOf(displayTerms.getStartDateYear()));
        iteratorURL.setParameter("title", displayTerms.getTitle());
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
            String oldOrderByCol = preferences.getValue("com_liferay_knowledge_base_web_portlet_AdminPortlet", "kb-templates-order-by-col", "modified-date");
            String oldOrderByType = preferences.getValue("com_liferay_knowledge_base_web_portlet_AdminPortlet", "kb-templates-order-by-type", "desc");
            String orderByCol = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByCol", (String)oldOrderByCol);
            String orderByType = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByType", (String)oldOrderByType);
            if (!Objects.equals(orderByCol, oldOrderByCol) || !Objects.equals(orderByType, oldOrderByType)) {
                preferences.setValue("com_liferay_knowledge_base_web_portlet_AdminPortlet", "kb-templates-order-by-col", orderByCol);
                preferences.setValue("com_liferay_knowledge_base_web_portlet_AdminPortlet", "kb-templates-order-by-type", orderByType);
                KBTemplateSearchTerms searchTerms = (KBTemplateSearchTerms)this.getSearchTerms();
                searchTerms.setCurStartValues(new int[0]);
            }
            OrderByComparator orderByComparator = KnowledgeBaseUtil.getKBTemplateOrderByComparator((String)orderByCol, (String)orderByType);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
    }
}

