/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.portlet.action;

import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.service.KBFolderLocalService;
import com.liferay.knowledge.base.service.permission.KBArticlePermission;
import com.liferay.knowledge.base.service.util.AdminUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.struts.BaseStrutsAction;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"path=/knowledge_base/find_kb_article"}, service={StrutsAction.class})
public class FindKBArticleAction
extends BaseStrutsAction {
    private static final boolean _PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get((String)"portlet.add.default.resource.check.enabled"));
    private GroupLocalService _groupLocalService;
    private KBArticleLocalService _kbArticleLocalService;
    private KBFolderLocalService _kbFolderLocalService;
    private LayoutLocalService _layoutLocalService;

    public String execute(StrutsAction originalStrutsAction, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"plid");
        long resourcePrimKey = ParamUtil.getLong((HttpServletRequest)request, (String)"resourcePrimKey");
        int status = ParamUtil.getInteger((HttpServletRequest)request, (String)"status", (int)0);
        boolean maximized = ParamUtil.getBoolean((HttpServletRequest)request, (String)"maximized");
        KBArticle kbArticle = this.getKBArticle(resourcePrimKey, status);
        if (!this.isValidPlid(plid)) {
            plid = themeDisplay.getPlid();
        }
        PortletURL portletURL = null;
        if (kbArticle == null) {
            portletURL = this.getDynamicPortletURL(plid, status, request);
        }
        if (status != 0) {
            portletURL = this.getDynamicPortletURL(plid, status, request);
        }
        if (portletURL == null) {
            portletURL = this.getKBArticleURL(plid, false, kbArticle, request);
        }
        if (portletURL == null) {
            portletURL = this.getKBArticleURL(plid, true, kbArticle, request);
        }
        if (portletURL == null) {
            portletURL = this.getDynamicPortletURL(plid, status, request);
        }
        if (maximized) {
            portletURL.setWindowState(LiferayWindowState.MAXIMIZED);
            portletURL.setPortletMode(PortletMode.VIEW);
        }
        response.sendRedirect(portletURL.toString());
        return null;
    }

    protected List<Layout> getCandidateLayouts(long plid, boolean privateLayout, KBArticle kbArticle) throws Exception {
        ArrayList<Layout> candidateLayouts = new ArrayList<Layout>();
        Group group = this._groupLocalService.getGroup(kbArticle.getGroupId());
        if (group.isLayout()) {
            Layout layout = this._layoutLocalService.getLayout(group.getClassPK());
            candidateLayouts.add(layout);
            group = layout.getGroup();
        }
        List layouts = this._layoutLocalService.getLayouts(group.getGroupId(), privateLayout, "portlet");
        candidateLayouts.addAll(layouts);
        Layout layout = this._layoutLocalService.getLayout(plid);
        if (layout.getGroupId() == kbArticle.getGroupId() && layout.isTypePortlet()) {
            candidateLayouts.remove(layout);
            candidateLayouts.add(0, layout);
        }
        return candidateLayouts;
    }

    protected PortletURL getDynamicPortletURL(long plid, int status, HttpServletRequest request) throws Exception {
        String portletId = this.getPortletId(plid);
        PortletURL portletURL = this.getKBArticleURL(plid, portletId, null, request);
        if (status != 0) {
            portletURL.setParameter("status", String.valueOf(status));
        }
        if (_PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED) {
            String token = AuthTokenUtil.getToken((HttpServletRequest)request, (long)plid, (String)portletId);
            portletURL.setParameter("p_p_auth", token);
        }
        portletURL.setPortletMode(PortletMode.VIEW);
        if (Objects.equals(portletId, "com_liferay_knowledge_base_web_portlet_ArticlePortlet_INSTANCE_0000")) {
            portletURL.setWindowState(LiferayWindowState.MAXIMIZED);
        }
        return portletURL;
    }

    protected KBArticle getKBArticle(long resourcePrimKey, int status) throws Exception {
        KBArticle kbArticle = this._kbArticleLocalService.fetchLatestKBArticle(resourcePrimKey, status);
        if (kbArticle == null) {
            return null;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!KBArticlePermission.contains((PermissionChecker)permissionChecker, (KBArticle)kbArticle, (String)"VIEW")) {
            return null;
        }
        return kbArticle;
    }

    protected PortletURL getKBArticleURL(long plid, boolean privateLayout, KBArticle kbArticle, HttpServletRequest request) throws Exception {
        PortletURL firstMatchPortletURL = null;
        List<Layout> layouts = this.getCandidateLayouts(plid, privateLayout, kbArticle);
        for (Layout layout : layouts) {
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            List portlets = layoutTypePortlet.getAllPortlets();
            for (Portlet portlet : portlets) {
                long selRootResourcePrimKey;
                long resourcePrimKey;
                KBArticle selKBArticle;
                PortletPreferences portletPreferences;
                String rootPortletId = PortletConstants.getRootPortletId((String)portlet.getPortletId());
                if (rootPortletId.equals("com_liferay_knowledge_base_web_portlet_DisplayPortlet")) {
                    portletPreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portlet.getPortletId(), (String)"");
                    long kbFolderClassNameId = PortalUtil.getClassNameId((String)KBFolderConstants.getClassName());
                    long resourceClassNameId = GetterUtil.getLong((String)portletPreferences.getValue("resourceClassNameId", null), (long)kbFolderClassNameId);
                    long resourcePrimKey2 = GetterUtil.getLong((String)portletPreferences.getValue("resourcePrimKey", null), (long)0L);
                    if (resourceClassNameId == kbFolderClassNameId ? this.isParentFolder(resourcePrimKey2, kbArticle.getKbFolderId()) : resourcePrimKey2 == kbArticle.getResourcePrimKey()) {
                        return this.getKBArticleURL(layout.getPlid(), portlet.getPortletId(), kbArticle, request);
                    }
                    if (firstMatchPortletURL == null) {
                        firstMatchPortletURL = this.getKBArticleURL(layout.getPlid(), portlet.getPortletId(), kbArticle, request);
                    }
                }
                if (rootPortletId.equals("com_liferay_knowledge_base_web_portlet_SectionPortlet")) {
                    String[] sections;
                    portletPreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portlet.getPortletId(), (String)"");
                    Object[] kbArticlesSections = portletPreferences.getValues("kbArticlesSections", new String[0]);
                    KBArticle rootKBArticle = this._kbArticleLocalService.fetchLatestKBArticle(kbArticle.getRootResourcePrimKey(), 0);
                    if (rootKBArticle == null) continue;
                    for (String section : sections = AdminUtil.unescapeSections((String)rootKBArticle.getSections())) {
                        if (!ArrayUtil.contains((Object[])kbArticlesSections, (Object)section)) continue;
                        return this.getKBArticleURL(layout.getPlid(), portlet.getPortletId(), kbArticle, request);
                    }
                }
                if (!rootPortletId.equals("com_liferay_knowledge_base_web_portlet_ArticlePortlet") || (selKBArticle = this._kbArticleLocalService.fetchLatestKBArticle(resourcePrimKey = GetterUtil.getLong((String)(portletPreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portlet.getPortletId(), (String)"")).getValue("resourcePrimKey", null)), 0)) == null) continue;
                long rootResourcePrimKey = kbArticle.getRootResourcePrimKey();
                if (rootResourcePrimKey == (selRootResourcePrimKey = selKBArticle.getRootResourcePrimKey())) {
                    return this.getKBArticleURL(layout.getPlid(), portlet.getPortletId(), kbArticle, request);
                }
                if (firstMatchPortletURL != null) continue;
                firstMatchPortletURL = this.getKBArticleURL(layout.getPlid(), portlet.getPortletId(), kbArticle, request);
            }
        }
        return firstMatchPortletURL;
    }

    protected PortletURL getKBArticleURL(long plid, String portletId, KBArticle kbArticle, HttpServletRequest request) throws Exception {
        long resourcePrimKey = ParamUtil.getLong((HttpServletRequest)request, (String)"resourcePrimKey");
        String mvcPath = null;
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        if (rootPortletId.equals("com_liferay_knowledge_base_web_portlet_ArticlePortlet")) {
            mvcPath = "/article/view_article.jsp";
        } else if (rootPortletId.equals("com_liferay_knowledge_base_web_portlet_SectionPortlet")) {
            mvcPath = "/section/view_article.jsp";
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)portletId, (long)plid, (String)"RENDER_PHASE");
        if (mvcPath != null) {
            portletURL.setParameter("mvcPath", mvcPath);
        }
        if (kbArticle == null || Validator.isNull((String)kbArticle.getUrlTitle())) {
            portletURL.setParameter("resourcePrimKey", String.valueOf(resourcePrimKey));
        } else {
            portletURL.setParameter("urlTitle", kbArticle.getUrlTitle());
            if (kbArticle.getKbFolderId() != 0L) {
                KBFolder kbFolder = this._kbFolderLocalService.getKBFolder(kbArticle.getKbFolderId());
                portletURL.setParameter("kbFolderUrlTitle", String.valueOf(kbFolder.getUrlTitle()));
            }
        }
        portletURL.setPortletMode(PortletMode.VIEW);
        portletURL.setWindowState(LiferayWindowState.NORMAL);
        if (rootPortletId.equals("com_liferay_knowledge_base_web_portlet_SectionPortlet")) {
            portletURL.setWindowState(LiferayWindowState.MAXIMIZED);
        }
        return portletURL;
    }

    protected String getPortletId(long plid) throws Exception {
        Layout layout = this._layoutLocalService.getLayout(plid);
        long selPlid = PortalUtil.getPlidFromPortletId((long)layout.getGroupId(), (String)"com_liferay_knowledge_base_web_portlet_DisplayPortlet");
        if (selPlid != 0L) {
            return "com_liferay_knowledge_base_web_portlet_DisplayPortlet";
        }
        return "com_liferay_knowledge_base_web_portlet_ArticlePortlet_INSTANCE_0000";
    }

    protected boolean isParentFolder(long resourcePrimKey, long kbFolderId) throws PortalException {
        if (resourcePrimKey == kbFolderId) {
            return true;
        }
        while (kbFolderId != 0L) {
            if (resourcePrimKey == kbFolderId) {
                return true;
            }
            KBFolder kbFolder = this._kbFolderLocalService.getKBFolder(kbFolderId);
            kbFolderId = kbFolder.getParentKBFolderId();
        }
        return false;
    }

    protected boolean isValidPlid(long plid) throws Exception {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        return layout != null;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setKBArticleLocalService(KBArticleLocalService kbArticleLocalService) {
        this._kbArticleLocalService = kbArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setKBFolderLocalService(KBFolderLocalService kbFolderLocalService) {
        this._kbFolderLocalService = kbFolderLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }
}

