/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.portlet;

import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.exception.NoSuchArticleException;
import com.liferay.knowledge.base.exception.NoSuchCommentException;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.service.permission.KBArticlePermission;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.knowledge.base.util.comparator.KBArticlePriorityComparator;
import com.liferay.knowledge.base.web.portlet.BaseKBPortlet;
import com.liferay.knowledge.base.web.selector.KBArticleSelection;
import com.liferay.knowledge.base.web.selector.KBArticleSelector;
import com.liferay.knowledge.base.web.selector.KBArticleSelectorFactory;
import com.liferay.portal.kernel.exception.NoSuchSubscriptionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.css-class-wrapper=knowledge-base-portlet knowledge-base-portlet-display", "com.liferay.portlet.display-category=category.cms", "com.liferay.portlet.header-portlet-css=/admin/css/common.css", "com.liferay.portlet.header-portlet-css=/display/css/main.css", "com.liferay.portlet.icon=/icons/display.png", "com.liferay.portlet.scopeable=true", "javax.portlet.display-name=Knowledge Base Display", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.always-send-redirect=true", "javax.portlet.init-param.copy-request-parameters=true", "javax.portlet.init-param.template-path=/display/", "javax.portlet.init-param.view-template=/display/view.jsp", "javax.portlet.name=com_liferay_knowledge_base_web_portlet_DisplayPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator,guest,power-user,user", "javax.portlet.supported-public-render-parameter=categoryId", "javax.portlet.supported-public-render-parameter=tag", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class DisplayPortlet
extends BaseKBPortlet {
    private ClassNameLocalService _classNameLocalService;
    private KBArticleLocalService _kbArticleLocalService;
    private KBArticleSelectorFactory _kbArticleSelectorFactory;

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            renderRequest.setAttribute("DL_MIME_TYPE_DISPLAY_CONTEXT", (Object)this.dlMimeTypeDisplayContext);
            KBArticleSelection kbArticleSelection = this.getKBArticle(renderRequest);
            renderRequest.setAttribute("KNOWLEDGE_BASE_EXACT_MATCH", (Object)kbArticleSelection.isExactMatch());
            KBArticle kbArticle = kbArticleSelection.getKBArticle();
            int status = this.getStatus(renderRequest, kbArticle);
            if (kbArticle != null && kbArticle.getStatus() != status) {
                kbArticle = this._kbArticleLocalService.fetchLatestKBArticle(kbArticle.getResourcePrimKey(), status);
            }
            renderRequest.setAttribute("KNOWLEDGE_BASE_KB_ARTICLE", (Object)kbArticle);
            renderRequest.setAttribute("KNOWLEDGE_BASE_SEARCH_KEYWORDS", (Object)kbArticleSelection.getKeywords());
            renderRequest.setAttribute("KNOWLEDGE_BASE_STATUS", (Object)status);
            if (!kbArticleSelection.isExactMatch()) {
                HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)renderResponse);
                response.setStatus(404);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchArticleException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                SessionMessages.add((PortletRequest)renderRequest, (String)(PortalUtil.getPortletId((PortletRequest)renderRequest) + ".hideDefaultErrorMessage"));
            }
            throw new PortletException((Throwable)e);
        }
        super.render(renderRequest, renderResponse);
    }

    public void updateRootKBFolderId(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortalException {
        long kbFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"rootKBFolderId");
        if (kbFolderId == 0L) {
            return;
        }
        KBFolder kbFolder = this.kbFolderService.getKBFolder(kbFolderId);
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)PortalUtil.getLiferayPortletRequest((PortletRequest)actionRequest));
        PortletPreferences portletPreferences = actionRequest.getPreferences();
        String contentRootPrefix = GetterUtil.getString((String)portletPreferences.getValue("contentRootPrefix", null));
        String previousPreferredKBFolderURLTitle = KnowledgeBaseUtil.getPreferredKBFolderURLTitle((PortalPreferences)portalPreferences, (String)contentRootPrefix);
        KnowledgeBaseUtil.setPreferredKBFolderURLTitle((PortalPreferences)portalPreferences, (String)contentRootPrefix, (String)kbFolder.getUrlTitle());
        String urlTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"urlTitle");
        KBArticle kbArticle = null;
        if (Validator.isNotNull((String)urlTitle) && (kbArticle = this._kbArticleLocalService.fetchKBArticleByUrlTitle(kbFolder.getGroupId(), kbFolder.getUrlTitle(), urlTitle)) == null && Validator.isNull((String)previousPreferredKBFolderURLTitle)) {
            kbArticle = this.findClosestMatchingKBArticle(kbFolder.getGroupId(), previousPreferredKBFolderURLTitle, kbFolder.getKbFolderId(), urlTitle);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (kbArticle != null && !KBArticlePermission.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (KBArticle)kbArticle, (String)"VIEW")) {
            kbArticle = null;
        }
        LiferayPortletURL redirectURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)"com_liferay_knowledge_base_web_portlet_DisplayPortlet", (long)themeDisplay.getPlid(), (String)"RENDER_PHASE");
        redirectURL.setParameter("kbFolderUrlTitle", kbFolder.getUrlTitle());
        if (kbArticle != null) {
            redirectURL.setParameter("urlTitle", kbArticle.getUrlTitle());
        }
        actionResponse.sendRedirect(redirectURL.toString());
    }

    protected void addSuccessMessage(ActionRequest actionRequest, ActionResponse actionResponse) {
        String actionName = ParamUtil.getString((PortletRequest)actionRequest, (String)"javax.portlet.action");
        if (actionName.equals("deleteKBArticle") || actionName.equals("updateKBComment") || actionName.equals("updateRootKBFolderId")) {
            return;
        }
        super.addSuccessMessage(actionRequest, actionResponse);
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchArticleException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchCommentException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchSubscriptionException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses())) {
            this.include(this.templatePath + "error.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected KBArticle findClosestMatchingKBArticle(long groupId, String oldKBFolderURLTitle, long newKBFolderId, String urlTitle) throws PortalException {
        List kbArticles;
        KBArticle oldKBArticle = this._kbArticleLocalService.fetchKBArticleByUrlTitle(groupId, oldKBFolderURLTitle, urlTitle);
        KBArticle kbArticle = null;
        while (kbArticle == null && oldKBArticle != null) {
            kbArticle = this._kbArticleLocalService.fetchKBArticleByUrlTitle(groupId, newKBFolderId, oldKBArticle.getUrlTitle());
            if (kbArticle != null) continue;
            oldKBArticle = oldKBArticle.getParentKBArticle();
        }
        if (kbArticle == null && !(kbArticles = this._kbArticleLocalService.getKBArticles(groupId, newKBFolderId, 0, 0, 1, (OrderByComparator)new KBArticlePriorityComparator(true))).isEmpty()) {
            kbArticle = (KBArticle)kbArticles.get(0);
        }
        return kbArticle;
    }

    protected KBArticleSelection getKBArticle(RenderRequest renderRequest) throws PortalException {
        String mvcPath = ParamUtil.getString((PortletRequest)renderRequest, (String)"mvcPath");
        if (mvcPath.endsWith("/edit_article.jsp") || mvcPath.endsWith("/history.jsp") || mvcPath.endsWith("/print_article.jsp")) {
            long resourcePrimKey = ParamUtil.getLong((PortletRequest)renderRequest, (String)"resourcePrimKey");
            if (resourcePrimKey == 0L) {
                return new KBArticleSelection(null, false);
            }
            KBArticle latestKBArticle = this._kbArticleLocalService.getLatestKBArticle(resourcePrimKey, -1);
            return new KBArticleSelection(latestKBArticle, true);
        }
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        long kbFolderClassNameId = this._classNameLocalService.getClassNameId(KBFolderConstants.getClassName());
        long parentResourcePrimKey = GetterUtil.getLong((String)portletPreferences.getValue("resourcePrimKey", null));
        long parentResourceClassNameId = GetterUtil.getLong((String)portletPreferences.getValue("resourceClassNameId", null), (long)kbFolderClassNameId);
        KBArticleSelector kbArticleSelector = this._kbArticleSelectorFactory.getKBArticleSelector(parentResourceClassNameId);
        String urlTitle = ParamUtil.getString((PortletRequest)renderRequest, (String)"urlTitle");
        String preferredKBFolderURLTitle = this.getPreferredKBFolderUrlTitle(renderRequest, portletPreferences);
        if (Validator.isNotNull((String)urlTitle)) {
            String kbFolderUrlTitle = ParamUtil.getString((PortletRequest)renderRequest, (String)"kbFolderUrlTitle");
            return kbArticleSelector.findByUrlTitle(PortalUtil.getScopeGroupId((PortletRequest)renderRequest), preferredKBFolderURLTitle, parentResourcePrimKey, kbFolderUrlTitle, urlTitle);
        }
        long resourcePrimKey = ParamUtil.getLong((PortletRequest)renderRequest, (String)"resourcePrimKey", (long)0L);
        return kbArticleSelector.findByResourcePrimKey(PortalUtil.getScopeGroupId((PortletRequest)renderRequest), preferredKBFolderURLTitle, parentResourcePrimKey, resourcePrimKey);
    }

    protected String getPreferredKBFolderUrlTitle(RenderRequest renderRequest, PortletPreferences portletPreferences) throws PortalException {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)renderRequest);
        String contentRootPrefix = GetterUtil.getString((String)portletPreferences.getValue("contentRootPrefix", null));
        return KnowledgeBaseUtil.getPreferredKBFolderURLTitle((PortalPreferences)portalPreferences, (String)contentRootPrefix);
    }

    protected int getStatus(RenderRequest renderRequest, KBArticle kbArticle) throws Exception {
        if (kbArticle == null) {
            return 0;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (KBArticlePermission.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (KBArticle)kbArticle, (String)"UPDATE")) {
            return ParamUtil.getInteger((PortletRequest)renderRequest, (String)"status", (int)-1);
        }
        return 0;
    }

    @Reference(unbind="-")
    protected void setClassNameLocalService(ClassNameLocalService classNameLocalService) {
        this._classNameLocalService = classNameLocalService;
    }

    @Reference(unbind="-")
    protected void setKBArticleLocalService(KBArticleLocalService kbArticleLocalService) {
        this._kbArticleLocalService = kbArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setKBArticleSelectorFactory(KBArticleSelectorFactory kbArticleSelectorFactory) {
        this._kbArticleSelectorFactory = kbArticleSelectorFactory;
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.knowledge.base.web)(release.schema.version=1.0.0))", unbind="-")
    protected void setRelease(Release release) {
    }
}

