/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.portlet;

import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.document.library.display.context.DLMimeTypeDisplayContext;
import com.liferay.document.library.kernel.exception.DuplicateFileException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.knowledge.base.constants.KBArticleConstants;
import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.exception.KBArticleContentException;
import com.liferay.knowledge.base.exception.KBArticlePriorityException;
import com.liferay.knowledge.base.exception.KBArticleTitleException;
import com.liferay.knowledge.base.exception.KBCommentContentException;
import com.liferay.knowledge.base.exception.NoSuchArticleException;
import com.liferay.knowledge.base.exception.NoSuchCommentException;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.service.KBArticleService;
import com.liferay.knowledge.base.service.KBCommentLocalService;
import com.liferay.knowledge.base.service.KBCommentService;
import com.liferay.knowledge.base.service.KBFolderService;
import com.liferay.knowledge.base.service.KBTemplateService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.LiferayFileItemException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

public abstract class BaseKBPortlet
extends MVCPortlet {
    protected DLMimeTypeDisplayContext dlMimeTypeDisplayContext;
    protected JSONFactory jsonFactory;
    protected KBArticleService kbArticleService;
    protected KBCommentLocalService kbCommentLocalService;
    protected KBCommentService kbCommentService;
    protected KBFolderService kbFolderService;
    protected KBTemplateService kbTemplateService;
    protected Portal portal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTempAttachment(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        UploadPortletRequest uploadPortletRequest = this.portal.getUploadPortletRequest((PortletRequest)actionRequest);
        this.checkExceededSizeLimit((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long resourcePrimKey = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourcePrimKey");
        String sourceFileName = uploadPortletRequest.getFileName("file");
        InputStream inputStream = null;
        try {
            inputStream = uploadPortletRequest.getFileAsStream("file");
            String mimeType = uploadPortletRequest.getContentType("file");
            this.kbArticleService.addTempAttachment(themeDisplay.getScopeGroupId(), resourcePrimKey, sourceFileName, "com.liferay.knowledge.base.admin", inputStream, mimeType);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            throw throwable;
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
    }

    public void deleteKBArticle(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long resourcePrimKey = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourcePrimKey");
        this.kbArticleService.deleteKBArticle(resourcePrimKey);
    }

    public void deleteKBComment(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!themeDisplay.isSignedIn()) {
            return;
        }
        long kbCommentId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"kbCommentId");
        this.kbCommentService.deleteKBComment(kbCommentId);
        SessionMessages.add((PortletRequest)actionRequest, (String)"suggestionDeleted");
    }

    public void deleteKBComments(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] deleteKBCommentIds;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!themeDisplay.isSignedIn()) {
            return;
        }
        for (long deleteKBCommentId : deleteKBCommentIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsKBComment")) {
            this.kbCommentService.deleteKBComment(deleteKBCommentId);
        }
        SessionMessages.add((PortletRequest)actionRequest, (String)"suggestionsDeleted");
    }

    public void deleteTempAttachment(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long resourcePrimKey = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourcePrimKey");
        String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        JSONObject jsonObject = this.jsonFactory.createJSONObject();
        try {
            this.kbArticleService.deleteTempAttachment(themeDisplay.getScopeGroupId(), resourcePrimKey, fileName, "com.liferay.knowledge.base.admin");
            jsonObject.put("deleted", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            String errorMessage = themeDisplay.translate("an-unexpected-error-occurred-while-deleting-the-file");
            jsonObject.put("deleted", (Object)Boolean.FALSE);
            jsonObject.put("errorMessage", errorMessage);
        }
        this.writeJSON((PortletRequest)actionRequest, actionResponse, jsonObject);
    }

    public void moveKBObject(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long resourceClassNameId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceClassNameId");
        long resourcePrimKey = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourcePrimKey");
        long parentResourceClassNameId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentResourceClassNameId", (long)this.portal.getClassNameId(KBFolderConstants.getClassName()));
        long parentResourcePrimKey = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentResourcePrimKey", (long)0L);
        double priority = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"priority");
        long kbArticleClassNameId = this.portal.getClassNameId(KBArticleConstants.getClassName());
        if (resourceClassNameId == kbArticleClassNameId) {
            this.kbArticleService.moveKBArticle(resourcePrimKey, parentResourceClassNameId, parentResourcePrimKey, priority);
        } else {
            this.kbFolderService.moveKBFolder(resourcePrimKey, parentResourcePrimKey);
        }
    }

    public void serveKBArticleRSS(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        PortletPreferences portletPreferences = resourceRequest.getPreferences();
        boolean enableRss = GetterUtil.getBoolean((String)portletPreferences.getValue("enableRss", null), (boolean)true);
        if (!this.portal.isRSSFeedsEnabled() || !enableRss) {
            this.portal.sendRSSFeedsDisabledError((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long resourcePrimKey = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"resourcePrimKey");
        int rssDelta = ParamUtil.getInteger((PortletRequest)resourceRequest, (String)"rssDelta");
        String rssDisplayStyle = ParamUtil.getString((PortletRequest)resourceRequest, (String)"rssDisplayStyle");
        String rssFormat = ParamUtil.getString((PortletRequest)resourceRequest, (String)"rssFormat");
        String rss = this.kbArticleService.getKBArticleRSS(resourcePrimKey, 0, rssDelta, rssDisplayStyle, rssFormat, themeDisplay);
        PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, null, (byte[])rss.getBytes("UTF-8"), (String)"text/xml; charset=UTF-8");
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        try {
            String resourceID = resourceRequest.getResourceID();
            if (resourceID.equals("kbArticleRSS")) {
                this.serveKBArticleRSS(resourceRequest, resourceResponse);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (PortletException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void subscribeKBArticle(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long resourcePrimKey = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourcePrimKey");
        this.kbArticleService.subscribeKBArticle(themeDisplay.getScopeGroupId(), resourcePrimKey);
    }

    public void unsubscribeKBArticle(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long resourcePrimKey = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourcePrimKey");
        this.kbArticleService.unsubscribeKBArticle(resourcePrimKey);
    }

    public void updateKBArticle(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String portletId = this.portal.getPortletId((PortletRequest)actionRequest);
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        long resourcePrimKey = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourcePrimKey");
        long parentResourceClassNameId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentResourceClassNameId", (long)this.portal.getClassNameId(KBFolderConstants.getClassName()));
        long parentResourcePrimKey = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentResourcePrimKey", (long)0L);
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String urlTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"urlTitle");
        String content = ParamUtil.getString((PortletRequest)actionRequest, (String)"content");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        String sourceURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"sourceURL");
        String[] sections = actionRequest.getParameterValues("sections");
        String[] selectedFileNames = ParamUtil.getParameterValues((PortletRequest)actionRequest, (String)"selectedFileName");
        long[] removeFileEntryIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"removeFileEntryIds");
        int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction");
        KBArticle kbArticle = null;
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)KBArticle.class.getName(), (PortletRequest)actionRequest);
        if (cmd.equals("add")) {
            kbArticle = this.kbArticleService.addKBArticle(portletId, parentResourceClassNameId, parentResourcePrimKey, title, urlTitle, content, description, sourceURL, sections, selectedFileNames, serviceContext);
        } else if (cmd.equals("revert")) {
            int version = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"version", (int)1);
            kbArticle = this.kbArticleService.revertKBArticle(resourcePrimKey, version, serviceContext);
        } else if (cmd.equals("update")) {
            kbArticle = this.kbArticleService.updateKBArticle(resourcePrimKey, title, content, description, sourceURL, sections, selectedFileNames, removeFileEntryIds, serviceContext);
        }
        if (!cmd.equals("add") && !cmd.equals("update")) {
            return;
        }
        if (workflowAction == 2) {
            String editURL = this.buildEditURL(actionRequest, actionResponse, kbArticle);
            actionRequest.setAttribute("REDIRECT", (Object)editURL);
        }
    }

    public void updateKBComment(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!themeDisplay.isSignedIn()) {
            return;
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        long kbCommentId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"kbCommentId");
        long classNameId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classNameId");
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        String content = ParamUtil.getString((PortletRequest)actionRequest, (String)"content");
        int status = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"status", (int)-1);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)KBComment.class.getName(), (PortletRequest)actionRequest);
        if (cmd.equals("add")) {
            this.kbCommentLocalService.addKBComment(themeDisplay.getUserId(), classNameId, classPK, content, serviceContext);
        } else if (cmd.equals("update")) {
            if (status == -1) {
                KBComment kbComment = this.kbCommentService.getKBComment(kbCommentId);
                status = kbComment.getStatus();
            }
            this.kbCommentLocalService.updateKBComment(kbCommentId, classNameId, classPK, content, status, serviceContext);
        }
        SessionMessages.add((PortletRequest)actionRequest, (String)"suggestionSaved");
    }

    public void updateKBCommentStatus(ActionRequest actionRequest, ActionResponse actionResponse) throws PortalException {
        long kbCommentId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"kbCommentId");
        int status = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"kbCommentStatus");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)KBComment.class.getName(), (PortletRequest)actionRequest);
        this.kbCommentService.updateStatus(kbCommentId, status, serviceContext);
        SessionMessages.add((PortletRequest)actionRequest, (String)"suggestionStatusUpdated");
    }

    protected String buildEditURL(ActionRequest actionRequest, ActionResponse actionResponse, KBArticle kbArticle) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        String editURL = this.portal.getLayoutFullURL(themeDisplay);
        editURL = HttpUtil.setParameter((String)editURL, (String)"p_p_id", (String)portletDisplay.getId());
        editURL = HttpUtil.setParameter((String)editURL, (String)(actionResponse.getNamespace() + "mvcPath"), (String)(this.templatePath + "edit_article.jsp"));
        editURL = HttpUtil.setParameter((String)editURL, (String)(actionResponse.getNamespace() + "redirect"), (String)this.getRedirect(actionRequest, actionResponse));
        editURL = HttpUtil.setParameter((String)editURL, (String)(actionResponse.getNamespace() + "resourcePrimKey"), (long)kbArticle.getResourcePrimKey());
        editURL = HttpUtil.setParameter((String)editURL, (String)(actionResponse.getNamespace() + "status"), (int)-1);
        return editURL;
    }

    protected void checkExceededSizeLimit(PortletRequest portletRequest) throws PortalException {
        UploadException uploadException = (UploadException)portletRequest.getAttribute("UPLOAD_EXCEPTION");
        if (uploadException != null) {
            Throwable cause = uploadException.getCause();
            if (uploadException.isExceededFileSizeLimit()) {
                throw new FileSizeException(cause);
            }
            if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                throw new LiferayFileItemException(cause);
            }
            if (uploadException.isExceededUploadRequestSizeLimit()) {
                throw new UploadRequestSizeException(cause);
            }
            throw new PortalException(cause);
        }
    }

    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof AssetCategoryException || cause instanceof AssetTagException || cause instanceof DuplicateFileException || cause instanceof FileNameException || cause instanceof FileSizeException || cause instanceof KBArticleContentException || cause instanceof KBArticlePriorityException || cause instanceof KBArticleTitleException || cause instanceof KBCommentContentException || cause instanceof NoSuchArticleException || cause instanceof NoSuchCommentException || cause instanceof NoSuchFileException || cause instanceof PrincipalException || super.isSessionErrorException(cause);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setDLMimeTypeDisplayContext(DLMimeTypeDisplayContext dlMimeTypeDisplayContext) {
        this.dlMimeTypeDisplayContext = dlMimeTypeDisplayContext;
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    @Reference(unbind="-")
    protected void setKBArticleService(KBArticleService kbArticleService) {
        this.kbArticleService = kbArticleService;
    }

    @Reference(unbind="-")
    protected void setKBCommentLocalService(KBCommentLocalService kbCommentLocalService) {
        this.kbCommentLocalService = kbCommentLocalService;
    }

    @Reference(unbind="-")
    protected void setKBCommentService(KBCommentService kbCommentService) {
        this.kbCommentService = kbCommentService;
    }

    @Reference(unbind="-")
    protected void setKBFolderService(KBFolderService kbFolderService) {
        this.kbFolderService = kbFolderService;
    }

    @Reference(unbind="-")
    protected void setKBTemplateService(KBTemplateService kbTemplateService) {
        this.kbTemplateService = kbTemplateService;
    }

    @Reference(unbind="-")
    protected void setPortal(Portal portal) {
        this.portal = portal;
    }

    protected void unsetDLMimeTypeDisplayContext(DLMimeTypeDisplayContext dlMimeTypeDisplayContext) {
        this.dlMimeTypeDisplayContext = null;
    }
}

