/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.display.context;

import com.liferay.knowledge.base.constants.KBArticleConstants;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBCommentServiceUtil;
import com.liferay.knowledge.base.service.KBFolderLocalServiceUtil;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class KBSuggestionListDisplayContext {
    private final long _groupId;
    private KBArticle _kbArticle;
    private final String _navigation;
    private final HttpServletRequest _request;
    private final String _templatePath;

    public KBSuggestionListDisplayContext(HttpServletRequest request, String templatePath, KBArticle kbArticle) {
        this._request = request;
        this._templatePath = templatePath;
        this._kbArticle = kbArticle;
        this._groupId = kbArticle.getGroupId();
        this._navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"all");
    }

    public KBSuggestionListDisplayContext(HttpServletRequest request, String templatePath, long groupId) {
        this._request = request;
        this._templatePath = templatePath;
        this._groupId = groupId;
        this._navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"all");
    }

    public int getCompletedKBCommentsCount() throws PortalException {
        return this.getKBCommentsCount(0);
    }

    public String getEmptyResultsMessage() {
        if (this._navigation.equals("new")) {
            return "there-are-no-new-suggestions";
        }
        if (this._navigation.equals("in-progress")) {
            return "there-are-no-suggestions-in-progress";
        }
        if (this._navigation.equals("resolved")) {
            return "there-are-no-resolved-suggestions";
        }
        return "there-are-no-suggestions";
    }

    public long getGroupId() {
        return this._groupId;
    }

    public int getInProgressKBCommentsCount() throws PortalException {
        return this.getKBCommentsCount(2);
    }

    public int getKBCommentsCount(int status) throws PortalException {
        if (this._kbArticle == null) {
            return KBCommentServiceUtil.getKBCommentsCount((long)this._groupId, (int)status);
        }
        return KBCommentServiceUtil.getKBCommentsCount((long)this._groupId, (String)KBArticleConstants.getClassName(), (long)this._kbArticle.getClassPK(), (int)status);
    }

    public int getNewKBCommentsCount() throws PortalException {
        return this.getKBCommentsCount(1);
    }

    public String getViewSuggestionURL(PortletURL portletURL) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        String portletId = portletDisplay.getId();
        portletURL.setParameter("expanded", Boolean.TRUE.toString());
        if (this._kbArticle == null) {
            portletURL.setParameter("mvcPath", "/admin/view_suggestions.jsp");
        } else if (Validator.isNull((String)this._kbArticle.getUrlTitle()) || portletId.equals("com_liferay_knowledge_base_web_portlet_AdminPortlet")) {
            if (portletId.equals("com_liferay_knowledge_base_web_portlet_AdminPortlet")) {
                portletURL.setParameter("mvcPath", this._templatePath + "view_article.jsp");
            }
            portletURL.setParameter("resourceClassNameId", String.valueOf(this._kbArticle.getClassNameId()));
            portletURL.setParameter("resourcePrimKey", String.valueOf(this._kbArticle.getResourcePrimKey()));
        } else {
            portletURL.setParameter("urlTitle", this._kbArticle.getUrlTitle());
            if (this._kbArticle.getKbFolderId() != 0L) {
                KBFolder kbFolder = KBFolderLocalServiceUtil.getKBFolder((long)this._kbArticle.getKbFolderId());
                portletURL.setParameter("kbFolderUrlTitle", kbFolder.getUrlTitle());
            }
        }
        return portletURL.toString() + "#kbSuggestions";
    }

    public String getViewSuggestionURL(RenderResponse renderResponse) throws PortalException {
        return this.getViewSuggestionURL(renderResponse.createRenderURL());
    }

    public boolean isShowKBArticleTitle() {
        return this._kbArticle == null;
    }

    public void populateResultsAndTotal(SearchContainer<KBComment> searchContainer) throws PortalException {
        int status = this._getStatus();
        if (this._kbArticle == null) {
            if (status == -1) {
                searchContainer.setTotal(KBCommentServiceUtil.getKBCommentsCount((long)this._groupId));
                searchContainer.setResults(KBCommentServiceUtil.getKBComments((long)this._groupId, (int)searchContainer.getStart(), (int)searchContainer.getEnd(), (OrderByComparator)KnowledgeBaseUtil.getKBCommentOrderByComparator((String)searchContainer.getOrderByCol(), (String)searchContainer.getOrderByType())));
            } else {
                searchContainer.setTotal(this.getKBCommentsCount(status));
                searchContainer.setResults(KBCommentServiceUtil.getKBComments((long)this._groupId, (int)status, (int)searchContainer.getStart(), (int)searchContainer.getEnd(), (OrderByComparator)KnowledgeBaseUtil.getKBCommentOrderByComparator((String)searchContainer.getOrderByCol(), (String)searchContainer.getOrderByType())));
            }
        } else if (status == -1) {
            searchContainer.setTotal(KBCommentServiceUtil.getKBCommentsCount((long)this._groupId, (String)KBArticleConstants.getClassName(), (long)this._kbArticle.getClassPK()));
            searchContainer.setResults(KBCommentServiceUtil.getKBComments((long)this._groupId, (String)KBArticleConstants.getClassName(), (long)this._kbArticle.getClassPK(), (int)searchContainer.getStart(), (int)searchContainer.getEnd(), (OrderByComparator)KnowledgeBaseUtil.getKBCommentOrderByComparator((String)searchContainer.getOrderByCol(), (String)searchContainer.getOrderByType())));
        } else {
            searchContainer.setTotal(this.getKBCommentsCount(status));
            searchContainer.setResults(KBCommentServiceUtil.getKBComments((long)this._groupId, (String)KBArticleConstants.getClassName(), (long)this._kbArticle.getClassPK(), (int)status, (int)searchContainer.getStart(), (int)searchContainer.getEnd(), (OrderByComparator)KnowledgeBaseUtil.getKBCommentOrderByComparator((String)searchContainer.getOrderByCol(), (String)searchContainer.getOrderByType())));
        }
    }

    private int _getStatus() {
        if (this._navigation.equals("new")) {
            return 1;
        }
        if (this._navigation.equals("in-progress")) {
            return 2;
        }
        if (this._navigation.equals("resolved")) {
            return 0;
        }
        return -1;
    }
}

