/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.application.dao.search;

import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.web.display.context.KBSuggestionListDisplayContext;
import com.liferay.portal.kernel.dao.search.ResultRow;
import com.liferay.portal.kernel.dao.search.ResultRowSplitter;
import com.liferay.portal.kernel.dao.search.ResultRowSplitterEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;

public class KBCommentResultRowSplitter
implements ResultRowSplitter {
    private static final Log _log = LogFactoryUtil.getLog(KBCommentResultRowSplitter.class);
    private final KBSuggestionListDisplayContext _kbSuggestionListDisplayContext;
    private final String _orderByType;
    private final ResourceBundle _resourceBundle;

    public KBCommentResultRowSplitter(KBSuggestionListDisplayContext kbSuggestionListDisplayContext, ResourceBundle resourceBundle) {
        this(kbSuggestionListDisplayContext, resourceBundle, "desc");
    }

    public KBCommentResultRowSplitter(KBSuggestionListDisplayContext kbSuggestionListDisplayContext, ResourceBundle resourceBundle, String orderByType) {
        this._kbSuggestionListDisplayContext = kbSuggestionListDisplayContext;
        this._resourceBundle = resourceBundle;
        this._orderByType = orderByType;
    }

    public List<ResultRowSplitterEntry> split(List<ResultRow> resultRows) {
        ArrayList<ResultRowSplitterEntry> resultRowSplitterEntries = new ArrayList<ResultRowSplitterEntry>();
        ArrayList<ResultRow> newResultRows = new ArrayList<ResultRow>();
        ArrayList<ResultRow> inProgressResultRows = new ArrayList<ResultRow>();
        ArrayList<ResultRow> completedResultRows = new ArrayList<ResultRow>();
        for (ResultRow resultRow : resultRows) {
            KBComment kbComment = (KBComment)resultRow.getObject();
            if (kbComment.getStatus() == 1) {
                newResultRows.add(resultRow);
                continue;
            }
            if (kbComment.getStatus() == 2) {
                inProgressResultRows.add(resultRow);
                continue;
            }
            completedResultRows.add(resultRow);
        }
        if (!newResultRows.isEmpty()) {
            resultRowSplitterEntries.add(new ResultRowSplitterEntry(this.getNewKBCommentsLabel(), newResultRows));
        }
        if (!inProgressResultRows.isEmpty()) {
            resultRowSplitterEntries.add(new ResultRowSplitterEntry(this.getInProgressKBCommentsLabel(), inProgressResultRows));
        }
        if (!completedResultRows.isEmpty()) {
            resultRowSplitterEntries.add(new ResultRowSplitterEntry(this.getCompletedKBCommentsLabel(), completedResultRows));
        }
        if (this._orderByType.equals("asc")) {
            Collections.reverse(resultRowSplitterEntries);
        }
        return resultRowSplitterEntries;
    }

    protected String getCompletedKBCommentsLabel() {
        int completedKBCommentsCount = 0;
        try {
            completedKBCommentsCount = this._kbSuggestionListDisplayContext.getCompletedKBCommentsCount();
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to obtain completed knowledge base comments count for group " + this._kbSuggestionListDisplayContext.getGroupId()));
        }
        return String.format("%s (%s)", LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"completed"), completedKBCommentsCount);
    }

    protected String getInProgressKBCommentsLabel() {
        int inProgressKBCommentsCount = 0;
        try {
            inProgressKBCommentsCount = this._kbSuggestionListDisplayContext.getInProgressKBCommentsCount();
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to obtain in progress knowledge base comments count for  group " + this._kbSuggestionListDisplayContext.getGroupId()));
        }
        return String.format("%s (%s)", LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"in-progress"), inProgressKBCommentsCount);
    }

    protected String getNewKBCommentsLabel() {
        int newKBCommentsCount = 0;
        try {
            newKBCommentsCount = this._kbSuggestionListDisplayContext.getNewKBCommentsCount();
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to obtain new knowledge base comments count for group " + this._kbSuggestionListDisplayContext.getGroupId()));
        }
        return String.format("%s (%s)", LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"new"), newKBCommentsCount);
    }
}

