/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.search;

import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.web.internal.KBUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Objects;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class KBObjectsSearch
extends SearchContainer<Object> {
    public static final String EMPTY_RESULTS_MESSAGE = "no-articles-were-found";
    private static final Log _log = LogFactoryUtil.getLog(KBObjectsSearch.class);

    public KBObjectsSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        super(portletRequest, null, null, "cur", DEFAULT_DELTA, iteratorURL, null, EMPTY_RESULTS_MESSAGE);
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
            PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)portletRequest);
            String portletOrderByCol = portletPreferences.getValue("kbArticlesOrderByCol", "priority");
            String portletOrderByType = portletPreferences.getValue("kbArticlesOrderByType", "asc");
            String oldOrderByCol = preferences.getValue("com_liferay_knowledge_base_web_portlet_AdminPortlet", "kb-articles-order-by-col", portletOrderByCol);
            String oldOrderByType = preferences.getValue("com_liferay_knowledge_base_web_portlet_AdminPortlet", "kb-articles-order-by-type", portletOrderByType);
            String orderByCol = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByCol", (String)oldOrderByCol);
            String orderByType = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByType", (String)oldOrderByType);
            if (!Objects.equals(orderByCol, oldOrderByCol) || !Objects.equals(orderByType, oldOrderByType)) {
                preferences.setValue("com_liferay_knowledge_base_web_portlet_AdminPortlet", "kb-articles-order-by-col", orderByCol);
                preferences.setValue("com_liferay_knowledge_base_web_portlet_AdminPortlet", "kb-articles-order-by-type", orderByType);
            }
            long kbFolderClassNameId = PortalUtil.getClassNameId((String)KBFolderConstants.getClassName());
            long parentResourceClassNameId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"parentResourceClassNameId", (long)kbFolderClassNameId);
            OrderByComparator orderByComparator = null;
            orderByComparator = parentResourceClassNameId == kbFolderClassNameId ? KBUtil.getKBObjectsOrderByComparator(orderByCol, orderByType) : KBUtil.getKBArticleOrderByComparator(orderByCol, orderByType);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
    }
}

