/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.display.context;

import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleLocalServiceUtil;
import com.liferay.knowledge.base.service.KBFolderServiceUtil;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.knowledge.base.web.configuration.KBDisplayPortletInstanceConfiguration;
import com.liferay.knowledge.base.web.internal.KBUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletRequest;

public class KBNavigationDisplayContext {
    private final KBArticle _kbArticle;
    private final KBDisplayPortletInstanceConfiguration _kbDisplayPortletInstanceConfiguration;
    private Boolean _leftNavigationVisible;
    private final PortalPreferences _portalPreferences;
    private final PortletRequest _portletRequest;
    private Long _resourceClassNameId;
    private Long _resourcePrimKey;
    private Long _rootResourcePrimKey;

    public KBNavigationDisplayContext(PortletRequest portletRequest, PortalPreferences portalPreferences, KBDisplayPortletInstanceConfiguration kbDisplayPortletInstanceConfiguration, KBArticle kbArticle) {
        this._portletRequest = portletRequest;
        this._portalPreferences = portalPreferences;
        this._kbDisplayPortletInstanceConfiguration = kbDisplayPortletInstanceConfiguration;
        this._kbArticle = kbArticle;
    }

    public List<Long> getAncestorResourcePrimaryKeys() throws PortalException {
        List<Long> ancestorResourcePrimaryKeys = new ArrayList<Long>();
        if (this._kbArticle != null) {
            KBArticle latestKBArticle = KBArticleLocalServiceUtil.getLatestKBArticle((long)this._kbArticle.getResourcePrimKey(), (int)0);
            ancestorResourcePrimaryKeys = latestKBArticle.getAncestorResourcePrimaryKeys();
            Collections.reverse(ancestorResourcePrimaryKeys);
        } else {
            ancestorResourcePrimaryKeys.add(0L);
        }
        return ancestorResourcePrimaryKeys;
    }

    public String getCurrentKBFolderURLTitle() throws PortalException {
        String currentKBFolderURLTitle = KBUtil.getPreferredKBFolderURLTitle(this._portalPreferences, this._kbDisplayPortletInstanceConfiguration.contentRootPrefix());
        long rootResourcePrimKey = this.getRootResourcePrimKey();
        if (rootResourcePrimKey != 0L) {
            KBFolder kbFolder = KBFolderServiceUtil.getKBFolder((long)rootResourcePrimKey);
            currentKBFolderURLTitle = kbFolder.getUrlTitle();
        }
        return currentKBFolderURLTitle;
    }

    public String getPageTitle() throws PortalException {
        long rootResourcePrimKey = this.getRootResourcePrimKey();
        String pageTitle = null;
        if (rootResourcePrimKey != 0L) {
            KBFolder kbFolder = KBFolderServiceUtil.getKBFolder((long)rootResourcePrimKey);
            pageTitle = this._kbDisplayPortletInstanceConfiguration.contentRootPrefix() + " " + kbFolder.getName();
            if (this._kbArticle != null) {
                pageTitle = this._kbArticle.getTitle() + " - " + pageTitle;
            }
        } else if (this._kbArticle != null) {
            pageTitle = this._kbArticle.getTitle();
        }
        return pageTitle;
    }

    public long getRootResourcePrimKey() throws PortalException {
        if (this._rootResourcePrimKey == null) {
            this._rootResourcePrimKey = 0L;
            if (this._kbArticle != null) {
                this._rootResourcePrimKey = KnowledgeBaseUtil.getKBFolderId((long)this._kbArticle.getParentResourceClassNameId(), (long)this._kbArticle.getParentResourcePrimKey());
            }
            if (this._rootResourcePrimKey == 0L) {
                this._rootResourcePrimKey = KBUtil.getRootResourcePrimKey(this._portletRequest, PortalUtil.getScopeGroupId((PortletRequest)this._portletRequest), this.getResourceClassNameId(), this.getResourcePrimKey());
            }
        }
        return this._rootResourcePrimKey;
    }

    public boolean isLeftNavigationVisible() throws PortalException {
        if (this._leftNavigationVisible == null) {
            this._leftNavigationVisible = this.hasMultipleDescendantKBArticles();
        }
        return this._leftNavigationVisible;
    }

    public boolean isTopNavigationVisible() throws PortalException {
        long kbFolderClassNameId = PortalUtil.getClassNameId((String)KBFolderConstants.getClassName());
        return this.getResourceClassNameId() == kbFolderClassNameId && !this.isLeftNavigationVisible();
    }

    protected long getResourceClassNameId() {
        if (this._resourceClassNameId == null) {
            this._resourceClassNameId = this._kbDisplayPortletInstanceConfiguration.resourceClassNameId() != 0L ? Long.valueOf(this._kbDisplayPortletInstanceConfiguration.resourceClassNameId()) : Long.valueOf(PortalUtil.getClassNameId((String)KBFolderConstants.getClassName()));
        }
        return this._resourceClassNameId;
    }

    protected long getResourcePrimKey() {
        if (this._resourcePrimKey == null) {
            this._resourcePrimKey = GetterUtil.getLong((Object)this._kbDisplayPortletInstanceConfiguration.resourcePrimKey());
        }
        return this._resourcePrimKey;
    }

    protected boolean hasMultipleDescendantKBArticles() throws PortalException {
        List kbArticles;
        KBArticle navigationKBArticle;
        int navigationKBArticleChildCount;
        List<KBFolder> kbFolders;
        long scopeGroupId = PortalUtil.getScopeGroupId((PortletRequest)this._portletRequest);
        long kbFolderClassNameId = PortalUtil.getClassNameId((String)KBFolderConstants.getClassName());
        if (this.getResourceClassNameId() == kbFolderClassNameId && (kbFolders = KBUtil.getAlternateRootKBFolders(scopeGroupId, this.getResourcePrimKey())).size() > 1) {
            int maxKBArticlesCount = 0;
            for (KBFolder kbFolder : kbFolders) {
                int kbArticlesCount = KBArticleLocalServiceUtil.getKBFolderKBArticlesCount((long)scopeGroupId, (long)kbFolder.getKbFolderId(), (int)0);
                if (kbArticlesCount <= maxKBArticlesCount) continue;
                maxKBArticlesCount = kbArticlesCount;
            }
            return maxKBArticlesCount > 1;
        }
        boolean showNavigation = true;
        long rootResourcePrimKey = this.getRootResourcePrimKey();
        int kbArticlesCount = KBArticleLocalServiceUtil.getKBArticlesCount((long)scopeGroupId, (long)rootResourcePrimKey, (int)0);
        if (kbArticlesCount == 0) {
            showNavigation = false;
        } else if (kbArticlesCount == 1 && (navigationKBArticleChildCount = KBArticleLocalServiceUtil.getKBArticlesCount((long)scopeGroupId, (long)(navigationKBArticle = (KBArticle)(kbArticles = KBArticleLocalServiceUtil.getKBArticles((long)scopeGroupId, (long)rootResourcePrimKey, (int)0, (int)0, (int)1, null)).get(0)).getResourcePrimKey(), (int)0)) == 0) {
            showNavigation = false;
        }
        return showNavigation;
    }
}

