/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.asset;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.knowledge.base.exception.NoSuchArticleException;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.service.permission.AdminPermission;
import com.liferay.knowledge.base.service.permission.KBArticlePermission;
import com.liferay.knowledge.base.web.internal.asset.KBArticleAssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.PortalUtil;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_knowledge_base_web_portlet_AdminPortlet"}, service={AssetRendererFactory.class})
public class KBArticleAssetRendererFactory
extends BaseAssetRendererFactory<KBArticle> {
    public static final String TYPE = "article";
    private KBArticleLocalService _kbArticleLocalService;
    private ServletContext _servletContext;

    public KBArticleAssetRendererFactory() {
        this.setLinkable(true);
        this.setSearchable(true);
    }

    public AssetEntry getAssetEntry(String className, long classPK) throws PortalException {
        KBArticle kbArticle = this.getKBArticle(classPK, -1);
        return super.getAssetEntry(className, kbArticle.getKbArticleId());
    }

    public AssetRenderer<KBArticle> getAssetRenderer(long classPK, int type) throws PortalException {
        KBArticle kbArticle = null;
        kbArticle = type == 1 ? this.getKBArticle(classPK, 0) : this.getKBArticle(classPK, -1);
        KBArticleAssetRenderer kbArticleAssetRenderer = new KBArticleAssetRenderer(kbArticle);
        kbArticleAssetRenderer.setAssetRendererType(type);
        kbArticleAssetRenderer.setServletContext(this._servletContext);
        return kbArticleAssetRenderer;
    }

    public String getClassName() {
        return KBArticle.class.getName();
    }

    public String getIconCssClass() {
        return "page";
    }

    public String getPortletId() {
        return "com_liferay_knowledge_base_web_portlet_DisplayPortlet";
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long classTypeId) throws PortalException {
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (Group)this.getGroup(liferayPortletRequest), (String)"com_liferay_knowledge_base_web_portlet_AdminPortlet", (long)0L, (long)0L, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/admin/edit_article.jsp");
        return portletURL;
    }

    public boolean hasAddPermission(PermissionChecker permissionChecker, long groupId, long classTypeId) throws Exception {
        return AdminPermission.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"ADD_KB_ARTICLE");
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return KBArticlePermission.contains((PermissionChecker)permissionChecker, (long)classPK, (String)actionId);
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.knowledge.base.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    protected KBArticle getKBArticle(long classPK, int status) throws PortalException {
        KBArticle kbArticle = null;
        try {
            kbArticle = this._kbArticleLocalService.getKBArticle(classPK);
        }
        catch (NoSuchArticleException nsae) {
            kbArticle = this._kbArticleLocalService.getLatestKBArticle(classPK, status);
        }
        return kbArticle;
    }

    @Reference(unbind="-")
    protected void setKBArticleLocalService(KBArticleLocalService kbArticleLocalService) {
        this._kbArticleLocalService = kbArticleLocalService;
    }
}

