/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.asset;

import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.permission.KBArticlePermission;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class KBArticleAssetRenderer
extends BaseJSPAssetRenderer<KBArticle> {
    private final KBArticle _kbArticle;

    public KBArticleAssetRenderer(KBArticle kbArticle) {
        this._kbArticle = kbArticle;
    }

    public KBArticle getAssetObject() {
        return this._kbArticle;
    }

    public String getClassName() {
        return KBArticle.class.getName();
    }

    public long getClassPK() {
        return this.getClassPK(this._kbArticle);
    }

    public long getGroupId() {
        return this._kbArticle.getGroupId();
    }

    public String getJspPath(HttpServletRequest request, String template) {
        if (template.equals("full_content")) {
            return "/admin/asset/" + template + ".jsp";
        }
        return null;
    }

    public int getStatus() {
        return this._kbArticle.getStatus();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        String summary = this._kbArticle.getDescription();
        if (Validator.isNull((String)summary)) {
            summary = StringUtil.shorten((String)HtmlUtil.extractText((String)this._kbArticle.getContent()), (int)200);
        }
        return summary;
    }

    public String getTitle(Locale locale) {
        return this._kbArticle.getTitle();
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        Group group = GroupLocalServiceUtil.fetchGroup((long)this._kbArticle.getGroupId());
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (Group)group, (String)"com_liferay_knowledge_base_web_portlet_AdminPortlet", (long)0L, (long)0L, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/admin/edit_article.jsp");
        portletURL.setParameter("resourcePrimKey", String.valueOf(this._kbArticle.getResourcePrimKey()));
        return portletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return KnowledgeBaseUtil.getKBArticleURL((long)themeDisplay.getPlid(), (long)this._kbArticle.getResourcePrimKey(), (int)this._kbArticle.getStatus(), (String)themeDisplay.getPortalURL(), (boolean)false);
    }

    public long getUserId() {
        return this._kbArticle.getUserId();
    }

    public String getUserName() {
        return this._kbArticle.getUserName();
    }

    public String getUuid() {
        return this._kbArticle.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) {
        return KBArticlePermission.contains((PermissionChecker)permissionChecker, (KBArticle)this._kbArticle, (String)"UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        return KBArticlePermission.contains((PermissionChecker)permissionChecker, (KBArticle)this._kbArticle, (String)"VIEW");
    }

    public boolean include(HttpServletRequest request, HttpServletResponse response, String template) throws Exception {
        request.setAttribute("KNOWLEDGE_BASE_KB_ARTICLE", (Object)this._kbArticle);
        return super.include(request, response, template);
    }

    public boolean isPrintable() {
        return true;
    }

    protected long getClassPK(KBArticle kbArticle) {
        if ((kbArticle.isDraft() || kbArticle.isPending()) && kbArticle.getVersion() != 1) {
            return kbArticle.getPrimaryKey();
        }
        return kbArticle.getResourcePrimKey();
    }
}

