/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.knowledge.base.internal.upgrade.v1_3_5;

import com.liferay.portal.kernel.upgrade.BaseLastPublishDateUpgradeProcess;

/**
 * @author Máté Thurzó
 */
public class UpgradeLastPublishDate extends BaseLastPublishDateUpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		alterTableAddColumn("KBArticle", "lastPublishDate", "DATE null");

		updateLastPublishDates("1_WAR_knowledgebaseportlet", "KBArticle");

		alterTableAddColumn("KBComment", "lastPublishDate", "DATE null");

		updateLastPublishDates("1_WAR_knowledgebaseportlet", "KBComment");

		alterTableAddColumn("KBFolder", "lastPublishDate", "DATE null");

		updateLastPublishDates("1_WAR_knowledgebaseportlet", "KBFolder");

		alterTableAddColumn("KBTemplate", "lastPublishDate", "DATE null");

		updateLastPublishDates("1_WAR_knowledgebaseportlet", "KBTemplate");
	}

}