/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.upgrade.v1_3_0;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeKBAttachments
extends UpgradeProcess {
    private static final String _KB_ARTICLE_CLASS_NAME = "com.liferay.knowledgebase.model.KBArticle";
    private static final String _PORTLET_ID = "3_WAR_knowledgebaseportlet";
    private static final Log _log = LogFactoryUtil.getLog(UpgradeKBAttachments.class);
    private final Store _store;

    public UpgradeKBAttachments(Store store) {
        this._store = store;
    }

    protected void deleteEmptyDirectories() throws Exception {
        for (long companyId : PortalUtil.getCompanyIds()) {
            this._store.deleteDirectory(companyId, 0L, "knowledgebase/kbarticles");
        }
    }

    protected void doUpgrade() throws Exception {
        this.updateAttachments();
        this.deleteEmptyDirectories();
    }

    protected String[] getAttachments(long companyId, long resourcePrimKey) throws Exception {
        String dirName = "knowledgebase/kbarticles/" + resourcePrimKey;
        return this._store.getFileNames(companyId, 0L, dirName);
    }

    protected long getFolderId(long groupId, long userId, long resourcePrimKey) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)_PORTLET_ID, (ServiceContext)serviceContext);
        Folder folder = PortletFileRepositoryUtil.addPortletFolder((long)userId, (long)repository.getRepositoryId(), (long)0L, (String)String.valueOf(resourcePrimKey), (ServiceContext)serviceContext);
        return folder.getFolderId();
    }

    protected void updateAttachments() throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select kbArticleId, resourcePrimKey, groupId, companyId, userId, status from KBArticle");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long classPK = rs.getLong("resourcePrimKey");
                int status = rs.getInt("status");
                if (status != 0) {
                    classPK = rs.getLong("kbArticleId");
                }
                long userId = rs.getLong("userId");
                this.updateAttachments(companyId, groupId, classPK, userId);
            }
        }
    }

    protected void updateAttachments(long companyId, long groupId, long resourcePrimKey, long userId) throws Exception {
        for (String attachment : this.getAttachments(companyId, resourcePrimKey)) {
            try {
                if (!this._store.hasFile(companyId, 0L, attachment)) continue;
                long folderId = this.getFolderId(groupId, userId, resourcePrimKey);
                byte[] bytes = this._store.getFileAsBytes(companyId, 0L, attachment);
                String title = FileUtil.getShortFileName((String)attachment);
                String extension = FileUtil.getExtension((String)title);
                String mimeType = MimeTypesUtil.getExtensionContentType((String)extension);
                PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)_KB_ARTICLE_CLASS_NAME, (long)resourcePrimKey, (String)_PORTLET_ID, (long)folderId, (byte[])bytes, (String)title, (String)mimeType, (boolean)false);
                this._store.deleteFile(companyId, 0L, attachment);
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to upgrade attachment " + attachment), (Throwable)pe);
            }
        }
    }
}

