/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.persistence.impl;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.impl.KBArticleImpl;
import com.liferay.knowledge.base.service.persistence.KBArticleFinder;
import com.liferay.knowledge.base.service.persistence.impl.KBArticleFinderBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={KBArticleFinder.class})
public class KBArticleFinderImpl
extends KBArticleFinderBaseImpl
implements KBArticleFinder {
    private static final String _COUNT_BY_URL_TITLE = KBArticleFinder.class.getName() + ".countByUrlTitle";
    private static final String _FIND_BY_URL_TITLE = KBArticleFinder.class.getName() + ".findByUrlTitle";
    @Reference
    private CustomSQL _customSQL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countByUrlTitle(long groupId, String kbFolderUrlTitle, String kbArticleUrlTitle, int[] status) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(KBArticleFinderImpl.class, _COUNT_BY_URL_TITLE);
            sql = this.replaceWorkflowStatus(sql, status);
            SQLQuery query = session.createSynchronizedSQLQuery(sql);
            query.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)query);
            qPos.add(groupId);
            qPos.add(kbArticleUrlTitle);
            qPos.add(kbFolderUrlTitle);
            Iterator itr = query.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KBArticle> findByUrlTitle(long groupId, String kbFolderUrlTitle, String kbArticleUrlTitle, int[] status, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(KBArticleFinderImpl.class, _FIND_BY_URL_TITLE);
            sql = this.replaceWorkflowStatus(sql, status);
            SQLQuery query = session.createSynchronizedSQLQuery(sql);
            query.addEntity("KBArticle", KBArticleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)query);
            qPos.add(groupId);
            qPos.add(kbArticleUrlTitle);
            qPos.add(kbFolderUrlTitle);
            List list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String replaceWorkflowStatus(String sql, int[] status) {
        StringBundler sb = new StringBundler(status.length);
        for (int i = 0; i < status.length; ++i) {
            sb.append(status[i]);
            if (i == status.length - 1) continue;
            sb.append(", ");
        }
        return StringUtil.replace((String)sql, (String)"[$WORKFLOW_STATUS$]", (String)sb.toString());
    }
}

