/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.util;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalServiceUtil;
import com.liferay.knowledge.base.service.permission.KBArticlePermission;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Subscription;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.EscapableLocalizableFunction;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.portal.kernel.util.TextFormatter;
import java.util.List;
import java.util.Locale;

public class AdminSubscriptionSender
extends SubscriptionSender {
    private final KBArticle _kbArticle;
    private final ServiceContext _serviceContext;

    public AdminSubscriptionSender(KBArticle kbArticle, ServiceContext serviceContext) {
        this._kbArticle = kbArticle;
        this._serviceContext = serviceContext;
    }

    public void initialize() throws Exception {
        super.initialize();
        String kbArticleURL = KnowledgeBaseUtil.getKBArticleURL((long)this._serviceContext.getPlid(), (long)this._kbArticle.getResourcePrimKey(), (int)this._kbArticle.getStatus(), (String)this._serviceContext.getPortalURL(), (boolean)false);
        this.setContextAttribute("[$ARTICLE_TITLE$]", this._kbArticle.getTitle());
        this.setContextAttribute("[$ARTICLE_URL$]", kbArticleURL);
        this.setLocalizedContextAttribute("[$ARTICLE_ATTACHMENTS$]", new EscapableLocalizableFunction(this._getEmailKBArticleAttachmentsFunction(), true));
        this.setLocalizedContextAttribute("[$ARTICLE_VERSION$]", new EscapableLocalizableFunction(locale -> LanguageUtil.format((Locale)locale, (String)"version-x", (Object)String.valueOf(this._kbArticle.getVersion()), (boolean)false), true));
        this.setLocalizedContextAttribute("[$CATEGORY_TITLE$]", new EscapableLocalizableFunction(locale -> LanguageUtil.get((Locale)locale, (String)"category.kb"), true));
    }

    protected void deleteSubscription(Subscription subscription) throws Exception {
        if (subscription.getClassPK() == this._kbArticle.getResourcePrimKey()) {
            KBArticleLocalServiceUtil.unsubscribeKBArticle((long)subscription.getUserId(), (long)this._kbArticle.getResourcePrimKey());
        }
        if (subscription.getClassPK() == this._kbArticle.getGroupId()) {
            KBArticleLocalServiceUtil.unsubscribeGroupKBArticles((long)subscription.getUserId(), (long)this._kbArticle.getGroupId());
        }
    }

    @Deprecated
    protected String getEmailKBArticleAttachments(Locale locale) throws Exception {
        Function<Locale, String> emailKBArticleAttachmentsFunction = this._getEmailKBArticleAttachmentsFunction();
        return (String)emailKBArticleAttachmentsFunction.apply((Object)locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPermission(Subscription subscription, String inferredClassName, long inferredClassPK, User user) throws Exception {
        String name = PrincipalThreadLocal.getName();
        PermissionChecker contextPermissionChecker = PermissionThreadLocal.getPermissionChecker();
        try {
            PrincipalThreadLocal.setName((long)user.getUserId());
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            boolean bl = KBArticlePermission.contains(permissionChecker, this._kbArticle, "VIEW");
            return bl;
        }
        finally {
            PrincipalThreadLocal.setName((String)name);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)contextPermissionChecker);
        }
    }

    protected String replaceContent(String content, Locale locale) throws Exception {
        return super.replaceContent(content, locale);
    }

    private Function<Locale, String> _getEmailKBArticleAttachmentsFunction() throws PortalException {
        List attachmentsFileEntries = this._kbArticle.getAttachmentsFileEntries();
        if (attachmentsFileEntries.isEmpty()) {
            return locale -> "";
        }
        return locale -> {
            StringBundler sb = new StringBundler(attachmentsFileEntries.size() * 5);
            for (FileEntry fileEntry : attachmentsFileEntries) {
                sb.append(fileEntry.getTitle());
                sb.append(" (");
                sb.append(TextFormatter.formatStorageSize((double)fileEntry.getSize(), (Locale)locale));
                sb.append(")");
                sb.append("<br />");
            }
            return sb.toString();
        };
    }
}

