/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.permission;

import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBFolderLocalServiceUtil;
import com.liferay.knowledge.base.service.permission.AdminPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.knowledge.base.model.KBFolder"}, service={BaseModelPermissionChecker.class})
public class KBFolderPermission
implements BaseModelPermissionChecker {
    public static void check(PermissionChecker permissionChecker, KBFolder kbFolder, String actionId) throws PortalException {
        if (!KBFolderPermission.contains(permissionChecker, kbFolder, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long kbFolderId, String actionId) throws PortalException {
        if (!KBFolderPermission.contains(permissionChecker, groupId, kbFolderId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long kbFolderId, String actionId) throws PortalException {
        KBFolder kbFolder = KBFolderLocalServiceUtil.getKBFolder((long)kbFolderId);
        KBFolderPermission.check(permissionChecker, kbFolder, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, KBFolder kbFolder, String actionId) {
        if (permissionChecker.hasOwnerPermission(kbFolder.getCompanyId(), KBFolder.class.getName(), kbFolder.getKbFolderId(), kbFolder.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(kbFolder.getGroupId(), KBFolder.class.getName(), kbFolder.getKbFolderId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long kbFolderId, String actionId) throws PortalException {
        if (kbFolderId == 0L) {
            return AdminPermission.contains(permissionChecker, groupId, actionId);
        }
        KBFolder kbFolder = KBFolderLocalServiceUtil.getKBFolder((long)kbFolderId);
        return KBFolderPermission.contains(permissionChecker, kbFolder, actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        KBFolderPermission.check(permissionChecker, groupId, primaryKey, actionId);
    }
}

