/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.permission;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.knowledge.base.model.KBArticle"}, service={BaseModelPermissionChecker.class})
public class KBArticlePermission
implements BaseModelPermissionChecker {
    public static void check(PermissionChecker permissionChecker, KBArticle kbArticle, String actionId) throws PortalException {
        if (!KBArticlePermission.contains(permissionChecker, kbArticle, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        if (!KBArticlePermission.contains(permissionChecker, classPK, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, KBArticle kbArticle, String actionId) {
        if (permissionChecker.hasOwnerPermission(kbArticle.getCompanyId(), KBArticle.class.getName(), kbArticle.getRootResourcePrimKey(), kbArticle.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(kbArticle.getGroupId(), KBArticle.class.getName(), kbArticle.getRootResourcePrimKey(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        KBArticle kbArticle = KBArticleLocalServiceUtil.fetchLatestKBArticle((long)classPK, (int)-1);
        if (kbArticle == null) {
            kbArticle = KBArticleLocalServiceUtil.getKBArticle((long)classPK);
        }
        return KBArticlePermission.contains(permissionChecker, kbArticle, actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        KBArticlePermission.check(permissionChecker, primaryKey, actionId);
    }
}

