/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.markdown.converter.internal;

import com.liferay.knowledge.base.markdown.converter.MarkdownConverter;
import com.vladsch.flexmark.ext.attributes.AttributesExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FlexmarkMarkdownConverter
implements MarkdownConverter {
    private static final Pattern _pattern = Pattern.compile("(?m)^(.*?)\\[\\]\\(id=([^\\s]+?)\\)\\s*$");
    private final HtmlRenderer _htmlRenderer;
    private final Parser _parser;

    public FlexmarkMarkdownConverter() {
        MutableDataSet htmlRendererMutableDataSet = new MutableDataSet();
        htmlRendererMutableDataSet.set(HtmlRenderer.RENDER_HEADER_ID, (Object)true);
        this._htmlRenderer = HtmlRenderer.builder((DataHolder)htmlRendererMutableDataSet).build();
        MutableDataSet parserMutableDataSet = new MutableDataSet();
        parserMutableDataSet.set(Parser.EXTENSIONS, Arrays.asList(AttributesExtension.create()));
        this._parser = Parser.builder((DataHolder)parserMutableDataSet).build();
    }

    public String convert(String markdown) throws IOException {
        return this._htmlRenderer.render((Node)this._parser.parse(this._replaceHeaderIdWithAttribute(markdown)));
    }

    private String _replaceHeaderIdWithAttribute(String markdown) {
        Matcher matcher = _pattern.matcher(markdown);
        return matcher.replaceAll("$1 {#$2}");
    }
}

