/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.markdown.converter.internal.pegdown.serializer;

import com.liferay.knowledge.base.markdown.converter.internal.pegdown.ast.PicWithCaptionNode;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pegdown.LinkRenderer;
import org.pegdown.ToHtmlSerializer;
import org.pegdown.ast.HeaderNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.ParaNode;
import org.pegdown.ast.SuperNode;
import org.pegdown.ast.TextNode;

public class LiferayToHtmlSerializer
extends ToHtmlSerializer {
    private final Pattern _headerIdPattern = Pattern.compile("\\[\\]\\(id=([^\\s]+?)\\)");

    public LiferayToHtmlSerializer(LinkRenderer linkRenderer) {
        super(linkRenderer);
    }

    public void visit(HeaderNode node) {
        List childNodes;
        boolean anchorInserted = false;
        if (node.getLevel() != 1 && !(childNodes = node.getChildren()).isEmpty()) {
            StringBundler sb = new StringBundler();
            for (Node child : childNodes) {
                if (!(child instanceof TextNode)) continue;
                sb.append(((TextNode)child).getText());
            }
            Matcher matcher = this._headerIdPattern.matcher(sb.toString());
            if (matcher.find()) {
                String match = matcher.group(1);
                this.printer.print(StringBundler.concat((String[])new String[]{"<a href=\"#", match, "\" id=\"", match, "\">"}));
                anchorInserted = true;
            }
        }
        super.visit(node);
        if (anchorInserted) {
            this.printer.print("</a>");
        }
    }

    public void visit(ParaNode node) {
        boolean printParagraphTag = true;
        List childNodes = node.getChildren();
        for (Node childNode : childNodes) {
            List grandchildNodes = childNode.getChildren();
            for (Node grandchildNode : grandchildNodes) {
                TextNode textNode;
                String text;
                if (!(grandchildNode instanceof TextNode) || !(text = (textNode = (TextNode)grandchildNode).getText()).equals("+$$$") && !text.equals("$$$")) continue;
                this.visitChildren((SuperNode)node);
                printParagraphTag = false;
            }
        }
        if (printParagraphTag) {
            this.printTag((SuperNode)node, "p");
        }
    }

    public void visit(PicWithCaptionNode picWithCaptionNode) {
        this.print(picWithCaptionNode);
    }

    public void visit(SuperNode superNode) {
        if (superNode instanceof PicWithCaptionNode) {
            this.visit((PicWithCaptionNode)superNode);
        } else {
            this.visitChildren(superNode);
        }
    }

    public void visit(TextNode node) {
        String text = node.getText();
        if (text.equals("+$$$")) {
            this.printer.print("<div class=\"sidebar\">");
            this.printer.print("<div class=\"sidebar-image\"></div>");
            this.printer.print("<div class=\"sidebar-text\">");
        } else if (text.equals("$$$")) {
            this.printer.print("</div></div>");
        } else if (this.abbreviations.isEmpty()) {
            this.printer.print(text);
        } else {
            this.printWithAbbreviations(text);
        }
    }

    protected void print(PicWithCaptionNode picWithCaptionNode) {
        this.printer.print("<p><img src=\"");
        this.printer.print(picWithCaptionNode.getSrc());
        this.printer.print("\" alt=\"");
        this.printer.print(picWithCaptionNode.getAlt());
        this.printer.print("\" /><p class=\"caption\">");
        this.visitChildren(picWithCaptionNode);
        this.printer.print("</p>");
    }
}

