/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.util;

import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KnowledgeBaseUtil {
    private static final int _SQL_DATA_MAX_PARAMETERS = GetterUtil.getInteger((String)PropsUtil.get((String)"sql.data.max.parameters"));
    private static final Log _log = LogFactoryUtil.getLog(KnowledgeBaseUtil.class);
    private static final Pattern _normalizationFriendlyUrlPattern = Pattern.compile("[^a-z0-9_-]");
    private static final Pattern _validFriendlyUrlPattern = Pattern.compile("/[a-z0-9_-]+");

    public static String getKBArticleURL(long plid, long resourcePrimKey, int status, String portalURL, boolean maximized) {
        StringBundler sb = new StringBundler(19);
        sb.append(portalURL);
        sb.append(PortalUtil.getPathMain());
        sb.append("/knowledge_base/find_kb_article");
        sb.append("?");
        sb.append("plid");
        sb.append("=");
        sb.append(plid);
        sb.append("&");
        sb.append("resourcePrimKey");
        sb.append("=");
        sb.append(resourcePrimKey);
        if (status != 0) {
            sb.append("&");
            sb.append("status");
            sb.append("=");
            sb.append(status);
        }
        if (maximized) {
            sb.append("&");
            sb.append("maximized");
            sb.append("=");
            sb.append(maximized);
        }
        return sb.toString();
    }

    public static long getKBFolderId(long parentResourceClassNameId, long parentResourcePrimKey) throws PortalException {
        long kbFolderClassNameId = PortalUtil.getClassNameId((String)KBFolderConstants.getClassName());
        if (parentResourceClassNameId == kbFolderClassNameId) {
            return parentResourcePrimKey;
        }
        KBArticle kbArticle = KBArticleLocalServiceUtil.getLatestKBArticle(parentResourcePrimKey, -1);
        return kbArticle.getKbFolderId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMimeType(byte[] bytes, String fileName) {
        try (UnsyncByteArrayInputStream inputStream = new UnsyncByteArrayInputStream(bytes);){
            String string = MimeTypesUtil.getContentType((InputStream)inputStream, (String)fileName);
            return string;
        }
        catch (IOException ioException) {
            if (!_log.isWarnEnabled()) return null;
            _log.warn((Object)ioException, (Throwable)ioException);
            return null;
        }
    }

    public static Long[][] getParams(Long[] params) {
        if (ArrayUtil.isEmpty((Object[])params)) {
            return null;
        }
        if (params.length <= _SQL_DATA_MAX_PARAMETERS) {
            return new Long[][]{new Long[0], params};
        }
        return new Long[][]{(Long[])ArrayUtil.subset((Object[])params, (int)_SQL_DATA_MAX_PARAMETERS, (int)params.length), (Long[])ArrayUtil.subset((Object[])params, (int)0, (int)_SQL_DATA_MAX_PARAMETERS)};
    }

    public static String getUrlTitle(long id, String title) {
        if (title == null) {
            return String.valueOf(id);
        }
        title = Validator.isNull((String)(title = StringUtil.toLowerCase((String)title.trim()))) || Validator.isNumber((String)title) || title.equals("rss") ? String.valueOf(id) : FriendlyURLNormalizerUtil.normalize((String)title, (Pattern)_normalizationFriendlyUrlPattern);
        return ModelHintsUtil.trimString((String)KBArticle.class.getName(), (String)"urlTitle", (String)title);
    }

    public static boolean isValidUrlTitle(String urlTitle) {
        Matcher matcher = _validFriendlyUrlPattern.matcher(urlTitle);
        return matcher.matches();
    }

    public static void setPreferredKBFolderURLTitle(PortalPreferences portalPreferences, String contentRootPrefix, String value) throws JSONException {
        String preferredKBFolderURLTitle = portalPreferences.getValue("com_liferay_knowledge_base_web_portlet_DisplayPortlet", "preferredKBFolderURLTitle", "{}");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)preferredKBFolderURLTitle);
        jsonObject.put(contentRootPrefix, value);
        portalPreferences.setValue("com_liferay_knowledge_base_web_portlet_DisplayPortlet", "preferredKBFolderURLTitle", jsonObject.toString());
    }

    public static List<KBArticle> sort(long[] resourcePrimKeys, List<KBArticle> kbArticles) {
        HashMap<Long, KBArticle> map = new HashMap<Long, KBArticle>();
        for (KBArticle kbArticle : kbArticles) {
            map.put(kbArticle.getResourcePrimKey(), kbArticle);
        }
        kbArticles.clear();
        for (Object resourcePrimKey : (Object)resourcePrimKeys) {
            if (!map.containsKey((long)resourcePrimKey)) continue;
            kbArticles.add((KBArticle)map.get((long)resourcePrimKey));
        }
        return kbArticles;
    }

    public static String[] splitKeywords(String keywords) {
        LinkedHashSet<String> keywordsSet = new LinkedHashSet<String>();
        StringBundler sb = new StringBundler();
        for (char c : keywords.toCharArray()) {
            if (Character.isWhitespace(c)) {
                if (sb.length() <= 0) continue;
                keywordsSet.add(sb.toString());
                sb = new StringBundler();
                continue;
            }
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            return new String[]{keywords};
        }
        if (sb.length() > 0) {
            keywordsSet.add(sb.toString());
        }
        return StringUtil.split((String)StringUtil.merge(keywordsSet));
    }

    public static String trimLeadingSlash(String s) {
        if (Validator.isNull((String)s)) {
            return s;
        }
        int x = 0;
        for (char c : s.toCharArray()) {
            if (c != '\\' && c != '/') break;
            ++x;
        }
        return s.substring(x);
    }
}

