/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.util.comparator;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.portal.kernel.util.OrderByComparator;

public class KBObjectsTitleComparator<T>
extends OrderByComparator<T> {
    public static final String ORDER_BY_ASC = "title ASC";
    public static final String ORDER_BY_DESC = "title DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"title"};
    public static final String ORDER_BY_MODEL_ASC = "modelFolder DESC, title ASC";
    public static final String ORDER_BY_MODEL_DESC = "modelFolder DESC, title DESC";
    private final boolean _ascending;
    private final boolean _orderByModel;

    public KBObjectsTitleComparator() {
        this(false, false);
    }

    public KBObjectsTitleComparator(boolean ascending) {
        this(ascending, false);
    }

    public KBObjectsTitleComparator(boolean ascending, boolean orderByModel) {
        this._ascending = ascending;
        this._orderByModel = orderByModel;
    }

    public int compare(T t1, T t2) {
        int value = 0;
        String title1 = this.getTitle(t1);
        String title2 = this.getTitle(t2);
        if (this._orderByModel) {
            if (t1 instanceof KBFolder && t2 instanceof KBFolder) {
                title1.compareToIgnoreCase(title2);
            } else if (t1 instanceof KBFolder) {
                value = -1;
            } else if (t2 instanceof KBFolder) {
                value = 1;
            } else {
                title1.compareToIgnoreCase(title2);
            }
        } else {
            value = title1.compareToIgnoreCase(title2);
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._orderByModel) {
            if (this._ascending) {
                return ORDER_BY_MODEL_ASC;
            }
            return ORDER_BY_MODEL_DESC;
        }
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    protected String getTitle(Object object) {
        if (object instanceof KBArticle) {
            KBArticle kbArticle = (KBArticle)object;
            return kbArticle.getTitle();
        }
        KBFolder kbFolder = (KBFolder)object;
        return kbFolder.getName();
    }
}

