<%--
/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
--%>

<%@ include file="/init.jsp" %>

<%
JournalEditDDMTemplateDisplayContext journalEditDDMTemplateDisplayContext = new JournalEditDDMTemplateDisplayContext(request, renderResponse);

DDMTemplate ddmTemplate = journalEditDDMTemplateDisplayContext.getDDMTemplate();

DDMStructure ddmStructure = journalEditDDMTemplateDisplayContext.getDDMStructure();
%>

<aui:model-context bean="<%= ddmTemplate %>" model="<%= DDMTemplate.class %>" />

<div class="form-group">
	<label class="control-label" for="<portlet:namespace />ddmStructure">
		<liferay-ui:message key="structure" />

		<liferay-ui:icon-help message="structure-help" />
	</label>

	<div class="input-group">
		<div class="input-group-item">
			<input placeholder="<%= LanguageUtil.format(locale, "select-x", "structure") %>" id="<%= liferayPortletResponse.getNamespace() %>ddmStructure" name="structure" readonly value="<%= (ddmStructure != null) ? ddmStructure.getName(locale) : StringPool.BLANK %>" class="form-control lfr-input-resource" />
		</div>

		<c:if test="<%= (ddmTemplate == null) || (ddmTemplate.getClassPK() == 0) %>">
			<div class="input-group-item input-group-item-shrink">
				<clay:button
					displayType="secondary"
					icon="plus"
					id='<%= liferayPortletResponse.getNamespace() + "selectDDMStructure" %>'
					small="<%= true %>"
				/>
			</div>
		</c:if>
	</div>
</div>

<c:if test="<%= !journalEditDDMTemplateDisplayContext.autogenerateDDMTemplateKey() && (ddmTemplate == null) %>">
	<aui:input helpMessage="template-key-help" name="templateKey" type="text" />
</c:if>

<aui:input defaultLanguageId="<%= (ddmTemplate == null) ? LocaleUtil.toLanguageId(LocaleUtil.getSiteDefault()): ddmTemplate.getDefaultLanguageId() %>" name="description" />

<c:if test="<%= ddmTemplate != null %>">
	<aui:input helpMessage="template-key-help" name="ddmTemplateKey" type="resource" value="<%= ddmTemplate.getTemplateKey() %>" />

	<portlet:resourceURL id="/journal/get_ddm_template" var="getDDMTemplateURL">
		<portlet:param name="ddmTemplateId" value="<%= String.valueOf(ddmTemplate.getTemplateId()) %>" />
	</portlet:resourceURL>

	<aui:input name="url" type="resource" value="<%= getDDMTemplateURL %>" />

	<%
	Portlet portlet = PortletLocalServiceUtil.getPortletById(portletDisplay.getId());
	%>

	<aui:input name="webDavURL" type="resource" value="<%= ddmTemplate.getWebDavURL(themeDisplay, WebDAVUtil.getStorageToken(portlet)) %>" />
</c:if>

<aui:input helpMessage="journal-template-cacheable-help" labelCssClass="control-label" name="cacheable" value="<%= journalEditDDMTemplateDisplayContext.isCacheable() %>" />

<aui:script>
	Liferay.Util.toggleBoxes(
		'<portlet:namespace />cacheable',
		'<portlet:namespace />-cacheableWarningMessage'
	);
</aui:script>

<c:if test="<%= (ddmTemplate == null) || (ddmTemplate.getClassPK() == 0) %>">
	<aui:script sandbox="<%= true %>">
		const selectDDMStructure = document.getElementById(
			'<portlet:namespace />selectDDMStructure'
		);

		const ddmStructure = document.getElementById(
			'<portlet:namespace />ddmStructure'
		);

		const onClick = (event) => {
			Liferay.Util.openSelectionModal({
				onSelect: function (selectedItem) {
					const itemValue = JSON.parse(selectedItem.value);

					if (
						document.<portlet:namespace />fm.<portlet:namespace />classPK
							.value != itemValue.ddmstructureid
					) {
						document.<portlet:namespace />fm.<portlet:namespace />classPK.value =
							itemValue.ddmstructureid;

						Liferay.fire('<portlet:namespace />refreshEditor');
					}
				},
				selectEventName: '<portlet:namespace />selectDDMStructure',
				title: '<%= UnicodeLanguageUtil.get(request, "structures") %>',
				url: '<%= journalDisplayContext.getSelectDDMStructureURL() %>>',
			});
		};

		if (selectDDMStructure) {
			selectDDMStructure.addEventListener('click', onClick);
		}

		if (ddmStructure) {
			ddmStructure.addEventListener('click', onClick);
		}
	</aui:script>
</c:if>