/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.util;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.util.ImageProcessorUtil;
import com.liferay.journal.exception.NoSuchFeedException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.model.JournalFeed;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalContentSearchLocalService;
import com.liferay.journal.service.JournalFeedLocalService;
import com.liferay.journal.util.JournalContent;
import com.liferay.journal.util.comparator.ArticleDisplayDateComparator;
import com.liferay.journal.util.comparator.ArticleModifiedDateComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.rss.export.RSSExporter;
import com.liferay.rss.model.SyndContent;
import com.liferay.rss.model.SyndEnclosure;
import com.liferay.rss.model.SyndEntry;
import com.liferay.rss.model.SyndFeed;
import com.liferay.rss.model.SyndLink;
import com.liferay.rss.model.SyndModelFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={JournalRSSUtil.class})
public class JournalRSSUtil {
    private static final String _XML_REQUUEST = "<request><parameters><parameter><name>rss</name><value>true</value></parameter></parameters></request>";
    private static final Log _log = LogFactoryUtil.getLog(JournalRSSUtil.class);
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private Http _http;
    private ImageLocalService _imageLocalService;
    private JournalArticleLocalService _journalArticleLocalService;
    private JournalContent _journalContent;
    private JournalContentSearchLocalService _journalContentSearchLocalService;
    private JournalFeedLocalService _journalFeedLocalService;
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RSSExporter _rssExporter;
    @Reference
    private SyndModelFactory _syndModelFactory;

    public List<JournalArticle> getArticles(JournalFeed feed) {
        String ddmTemplateKey;
        long companyId = feed.getCompanyId();
        long groupId = feed.getGroupId();
        List folderIds = Collections.emptyList();
        String articleId = null;
        Double version = null;
        String title = null;
        String description = null;
        String content = null;
        String ddmStructureKey = feed.getDDMStructureKey();
        if (Validator.isNull((String)ddmStructureKey)) {
            ddmStructureKey = null;
        }
        if (Validator.isNull((String)(ddmTemplateKey = feed.getDDMTemplateKey()))) {
            ddmTemplateKey = null;
        }
        Date displayDateGT = null;
        Date displayDateLT = new Date();
        int status = 0;
        Date reviewDate = null;
        boolean andOperator = true;
        int start = 0;
        int end = feed.getDelta();
        String orderByCol = feed.getOrderByCol();
        String orderByType = feed.getOrderByType();
        boolean orderByAsc = orderByType.equals("asc");
        ArticleModifiedDateComparator obc = new ArticleModifiedDateComparator(orderByAsc);
        if (orderByCol.equals("display-date")) {
            obc = new ArticleDisplayDateComparator(orderByAsc);
        }
        return this._journalArticleLocalService.search(companyId, groupId, folderIds, 0L, articleId, version, title, description, content, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, status, reviewDate, andOperator, start, end, (OrderByComparator)obc);
    }

    public List<SyndEnclosure> getDLEnclosures(String portalURL, String url) {
        ArrayList<SyndEnclosure> syndEnclosures = new ArrayList<SyndEnclosure>();
        FileEntry fileEntry = this.getFileEntry(url);
        if (fileEntry == null) {
            return syndEnclosures;
        }
        SyndEnclosure syndEnclosure = this._syndModelFactory.createSyndEnclosure();
        syndEnclosure.setLength(fileEntry.getSize());
        syndEnclosure.setType(fileEntry.getMimeType());
        syndEnclosure.setUrl(portalURL + url);
        syndEnclosures.add(syndEnclosure);
        return syndEnclosures;
    }

    public List<SyndLink> getDLLinks(String portalURL, String url) {
        ArrayList<SyndLink> syndLinks = new ArrayList<SyndLink>();
        FileEntry fileEntry = this.getFileEntry(url);
        if (fileEntry == null) {
            return syndLinks;
        }
        SyndLink syndLink = this._syndModelFactory.createSyndLink();
        syndLink.setHref(portalURL + url);
        syndLink.setLength(fileEntry.getSize());
        syndLink.setRel("enclosure");
        syndLink.setType(fileEntry.getMimeType());
        syndLinks.add(syndLink);
        return syndLinks;
    }

    public FileEntry getFileEntry(String url) {
        FileEntry fileEntry;
        block17: {
            fileEntry = null;
            String queryString = this._http.getQueryString(url);
            Map parameters = this._http.parameterMapFromString(queryString);
            if (url.startsWith("/documents/")) {
                String[] pathArray = StringUtil.split((String)url, (char)'/');
                String uuid = null;
                long groupId = GetterUtil.getLong((String)pathArray[2]);
                long folderId = 0L;
                String title = null;
                if (pathArray.length == 4) {
                    uuid = pathArray[3];
                } else if (pathArray.length == 5) {
                    folderId = GetterUtil.getLong((String)pathArray[3]);
                    title = this._http.decodeURL(pathArray[4]);
                } else if (pathArray.length > 5) {
                    uuid = pathArray[5];
                }
                try {
                    if (Validator.isNotNull((String)uuid)) {
                        fileEntry = this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
                        break block17;
                    }
                    fileEntry = this._dlAppLocalService.getFileEntry(groupId, folderId, title);
                }
                catch (Exception e) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e, (Throwable)e);
                    }
                    break block17;
                }
            }
            if (parameters.containsKey("folderId") && parameters.containsKey("name")) {
                try {
                    long fileEntryId = GetterUtil.getLong((String)((String[])parameters.get("fileEntryId"))[0]);
                    fileEntry = this._dlAppLocalService.getFileEntry(fileEntryId);
                }
                catch (Exception e) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e, (Throwable)e);
                    }
                    break block17;
                }
            }
            if (parameters.containsKey("uuid") && parameters.containsKey("groupId")) {
                try {
                    String uuid = ((String[])parameters.get("uuid"))[0];
                    long groupId = GetterUtil.getLong((String)((String[])parameters.get("groupId"))[0]);
                    fileEntry = this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block17;
                    _log.warn((Object)e, (Throwable)e);
                }
            }
        }
        return fileEntry;
    }

    public List<SyndEnclosure> getIGEnclosures(String portalURL, String url) {
        ArrayList<SyndEnclosure> syndEnclosures = new ArrayList<SyndEnclosure>();
        Object[] imageProperties = this.getImageProperties(url);
        if (imageProperties == null) {
            return syndEnclosures;
        }
        SyndEnclosure syndEnclosure = this._syndModelFactory.createSyndEnclosure();
        syndEnclosure.setLength(((Long)imageProperties[1]).longValue());
        syndEnclosure.setType(MimeTypesUtil.getExtensionContentType((String)imageProperties[0].toString()));
        syndEnclosure.setUrl(portalURL + url);
        syndEnclosures.add(syndEnclosure);
        return syndEnclosures;
    }

    public List<SyndLink> getIGLinks(String portalURL, String url) {
        ArrayList<SyndLink> syndLinks = new ArrayList<SyndLink>();
        Object[] imageProperties = this.getImageProperties(url);
        if (imageProperties == null) {
            return syndLinks;
        }
        SyndLink syndLink = this._syndModelFactory.createSyndLink();
        syndLink.setHref(portalURL + url);
        syndLink.setLength(((Long)imageProperties[1]).longValue());
        syndLink.setRel("enclosure");
        syndLink.setType(MimeTypesUtil.getExtensionContentType((String)imageProperties[0].toString()));
        syndLinks.add(syndLink);
        return syndLinks;
    }

    public Image getImage(String url) {
        Image image;
        block8: {
            image = null;
            String queryString = this._http.getQueryString(url);
            Map parameters = this._http.parameterMapFromString(queryString);
            if (parameters.containsKey("image_id") || parameters.containsKey("img_id") || parameters.containsKey("i_id")) {
                try {
                    long imageId = 0L;
                    if (parameters.containsKey("image_id")) {
                        imageId = GetterUtil.getLong((String)((String[])parameters.get("image_id"))[0]);
                    } else if (parameters.containsKey("img_id")) {
                        imageId = GetterUtil.getLong((String)((String[])parameters.get("img_id"))[0]);
                    } else if (parameters.containsKey("i_id")) {
                        imageId = GetterUtil.getLong((String)((String[])parameters.get("i_id"))[0]);
                    }
                    image = this._imageLocalService.getImage(imageId);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)e, (Throwable)e);
                }
            }
        }
        return image;
    }

    public byte[] getRSS(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JournalFeed feed = null;
        long id = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"id");
        if (id > 0L) {
            try {
                feed = this._journalFeedLocalService.getFeed(id);
            }
            catch (NoSuchFeedException nsfe) {
                feed = this._journalFeedLocalService.getFeed(themeDisplay.getScopeGroupId(), String.valueOf(id));
            }
        } else {
            long groupId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"groupId");
            String feedId = ParamUtil.getString((PortletRequest)resourceRequest, (String)"feedId");
            feed = this._journalFeedLocalService.getFeed(groupId, feedId);
        }
        String languageId = LanguageUtil.getLanguageId((PortletRequest)resourceRequest);
        long plid = this._portal.getPlidFromFriendlyURL(themeDisplay.getCompanyId(), feed.getTargetLayoutFriendlyUrl());
        Layout layout = null;
        if (plid > 0L) {
            layout = this._layoutLocalService.fetchLayout(plid);
        }
        if (layout == null) {
            layout = themeDisplay.getLayout();
        }
        String rss = this.exportToRSS(resourceRequest, resourceResponse, feed, languageId, layout, themeDisplay);
        return rss.getBytes("UTF-8");
    }

    protected String exportToRSS(ResourceRequest resourceRequest, ResourceResponse resourceResponse, JournalFeed feed, String languageId, Layout layout, ThemeDisplay themeDisplay) throws Exception {
        SyndFeed syndFeed = this._syndModelFactory.createSyndFeed();
        syndFeed.setDescription(feed.getDescription());
        ArrayList<SyndEntry> syndEntries = new ArrayList<SyndEntry>();
        syndFeed.setEntries(syndEntries);
        List<JournalArticle> articles = this.getArticles(feed);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Syndicating " + articles.size() + " articles"));
        }
        for (JournalArticle article : articles) {
            String value;
            SyndContent syndContent;
            SyndEntry syndEntry;
            block4: {
                syndEntry = this._syndModelFactory.createSyndEntry();
                String author = this._portal.getUserName((BaseModel)article);
                syndEntry.setAuthor(author);
                syndContent = this._syndModelFactory.createSyndContent();
                syndContent.setType("html");
                value = article.getDescription(languageId);
                try {
                    value = this.processContent(resourceRequest, resourceResponse, feed, article, languageId, themeDisplay, syndEntry, syndContent);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)e, (Throwable)e);
                }
            }
            syndContent.setValue(value);
            syndEntry.setDescription(syndContent);
            String link = this.getEntryURL(resourceRequest, feed, article, layout, themeDisplay);
            syndEntry.setLink(link);
            syndEntry.setPublishedDate(article.getDisplayDate());
            syndEntry.setTitle(article.getTitle(languageId));
            syndEntry.setUpdatedDate(article.getModifiedDate());
            syndEntry.setUri(link);
            syndEntries.add(syndEntry);
        }
        syndFeed.setFeedType(feed.getFeedFormat() + "_" + feed.getFeedVersion());
        SyndLink selfSyndLink = this._syndModelFactory.createSyndLink();
        ResourceURL feedURL = resourceResponse.createResourceURL();
        feedURL.setCacheability("cacheLevelFull");
        feedURL.setParameter("groupId", String.valueOf(feed.getGroupId()));
        feedURL.setParameter("feedId", String.valueOf(feed.getFeedId()));
        feedURL.setResourceID("rss");
        selfSyndLink.setHref(feedURL.toString());
        selfSyndLink.setRel("self");
        syndFeed.setLinks(ListUtil.toList((Object)selfSyndLink));
        syndFeed.setPublishedDate(new Date());
        syndFeed.setTitle(feed.getName());
        syndFeed.setUri(feedURL.toString());
        return this._rssExporter.export(syndFeed);
    }

    protected String getEntryURL(ResourceRequest resourceRequest, JournalFeed feed, JournalArticle article, Layout layout, ThemeDisplay themeDisplay) throws Exception {
        List hitLayoutIds = this._journalContentSearchLocalService.getLayoutIds(layout.getGroupId(), layout.isPrivateLayout(), article.getArticleId());
        if (!hitLayoutIds.isEmpty()) {
            Long hitLayoutId = (Long)hitLayoutIds.get(0);
            Layout hitLayout = this._layoutLocalService.getLayout(layout.getGroupId(), layout.isPrivateLayout(), hitLayoutId.longValue());
            return this._portal.getLayoutFriendlyURL(hitLayout, themeDisplay);
        }
        String portletId = feed.getTargetPortletId();
        if (Validator.isNull((String)portletId)) {
            return "";
        }
        long plid = this._portal.getPlidFromFriendlyURL(feed.getCompanyId(), feed.getTargetLayoutFriendlyUrl());
        LiferayPortletURL entryURL = PortletURLFactoryUtil.create((PortletRequest)resourceRequest, (String)portletId, (long)plid, (String)"RENDER_PHASE");
        entryURL.setParameter("groupId", String.valueOf(article.getGroupId()));
        entryURL.setParameter("articleId", article.getArticleId());
        return entryURL.toString();
    }

    protected Object[] getImageProperties(String url) {
        String type = null;
        long size = 0L;
        Image image = this.getImage(url);
        if (image != null) {
            type = image.getType();
            size = image.getSize();
        } else {
            FileEntry fileEntry = this.getFileEntry(url);
            Set imageMimeTypes = ImageProcessorUtil.getImageMimeTypes();
            if (fileEntry != null && imageMimeTypes.contains(fileEntry.getMimeType())) {
                type = fileEntry.getExtension();
                size = fileEntry.getSize();
            }
        }
        if (Validator.isNotNull((String)type)) {
            return new Object[]{type, size};
        }
        return null;
    }

    @Deprecated
    protected String processContent(JournalFeed feed, JournalArticle article, String languageId, ThemeDisplay themeDisplay, SyndEntry syndEntry, SyndContent syndContent) throws Exception {
        return "";
    }

    protected String processContent(ResourceRequest resourceRequest, ResourceResponse resourceResponse, JournalFeed feed, JournalArticle article, String languageId, ThemeDisplay themeDisplay, SyndEntry syndEntry, SyndContent syndContent) throws Exception {
        String content = article.getDescription(languageId);
        String contentField = feed.getContentField();
        if (contentField.equals("rendered-web-content")) {
            JournalArticleDisplay articleDisplay;
            String ddmRendererTemplateKey = article.getDDMTemplateKey();
            if (Validator.isNotNull((String)feed.getDDMRendererTemplateKey())) {
                ddmRendererTemplateKey = feed.getDDMRendererTemplateKey();
            }
            if ((articleDisplay = this._journalContent.getDisplay(feed.getGroupId(), article.getArticleId(), ddmRendererTemplateKey, null, languageId, 1, new PortletRequestModel((PortletRequest)resourceRequest, (PortletResponse)resourceResponse){

                public String toXML() {
                    return JournalRSSUtil._XML_REQUUEST;
                }
            }, themeDisplay)) != null) {
                content = articleDisplay.getContent();
            }
        } else if (!contentField.equals("web-content-description")) {
            Document document = SAXReaderUtil.read((String)article.getContentByLocale(languageId));
            contentField = HtmlUtil.escapeXPathAttribute((String)contentField);
            XPath xPathSelector = SAXReaderUtil.createXPath((String)("//dynamic-element[@name=" + contentField + "]"));
            List results = xPathSelector.selectNodes((Object)document);
            if (results.isEmpty()) {
                return content;
            }
            Element element = (Element)results.get(0);
            String elType = element.attributeValue("type");
            if (elType.equals("document_library")) {
                String url = element.elementText("dynamic-content");
                url = this.processURL(feed, url, themeDisplay, syndEntry);
            } else if (elType.equals("image") || elType.equals("image_gallery")) {
                String url = element.elementText("dynamic-content");
                url = this.processURL(feed, url, themeDisplay, syndEntry);
                content = StringBundler.concat((String[])new String[]{content, "<br /><br /><img alt='' src='", themeDisplay.getURLPortal(), url, "' />"});
            } else if (elType.equals("text_box")) {
                syndContent.setType("text");
                content = element.elementText("dynamic-content");
            } else {
                content = element.elementText("dynamic-content");
            }
        }
        return content;
    }

    protected String processURL(JournalFeed feed, String url, ThemeDisplay themeDisplay, SyndEntry syndEntry) {
        url = StringUtil.replace((String)url, (String[])new String[]{"@group_id@", "@image_path@", "@main_path@"}, (String[])new String[]{String.valueOf(feed.getGroupId()), themeDisplay.getPathImage(), themeDisplay.getPathMain()});
        List<SyndEnclosure> syndEnclosures = this.getDLEnclosures(themeDisplay.getURLPortal(), url);
        syndEnclosures.addAll(this.getIGEnclosures(themeDisplay.getURLPortal(), url));
        syndEntry.setEnclosures(syndEnclosures);
        List<SyndLink> syndLinks = this.getDLLinks(themeDisplay.getURLPortal(), url);
        syndLinks.addAll(this.getIGLinks(themeDisplay.getURLPortal(), url));
        syndEntry.setLinks(syndLinks);
        return url;
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }

    @Reference(unbind="-")
    protected void setImageLocalService(ImageLocalService imageLocalService) {
        this._imageLocalService = imageLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleLocalService(JournalArticleLocalService journalArticleLocalService) {
        this._journalArticleLocalService = journalArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalContent(JournalContent journalContent) {
        this._journalContent = journalContent;
    }

    @Reference(unbind="-")
    protected void setJournalContentSearchLocalService(JournalContentSearchLocalService journalContentSearchLocalService) {
        this._journalContentSearchLocalService = journalContentSearchLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalFeedLocalService(JournalFeedLocalService journalFeedLocalService) {
        this._journalFeedLocalService = journalFeedLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }
}

