/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.util;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.journal.util.comparator.ArticleCreateDateComparator;
import com.liferay.journal.util.comparator.ArticleDisplayDateComparator;
import com.liferay.journal.util.comparator.ArticleIDComparator;
import com.liferay.journal.util.comparator.ArticleModifiedDateComparator;
import com.liferay.journal.util.comparator.ArticleReviewDateComparator;
import com.liferay.journal.util.comparator.ArticleTitleComparator;
import com.liferay.journal.util.comparator.ArticleVersionComparator;
import com.liferay.journal.web.internal.util.JournalHelperUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.BreadcrumbEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class JournalPortletUtil {
    public static String getAddMenuFavItemKey(PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"folderId");
        String key = "journal-add-menu-fav-items-" + themeDisplay.getScopeGroupId();
        if ((folderId = JournalPortletUtil.getAddMenuFavItemFolderId(folderId)) <= 0L) {
            return key;
        }
        return key + "-" + folderId;
    }

    public static OrderByComparator<JournalArticle> getArticleOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        ArticleCreateDateComparator orderByComparator = null;
        if (orderByCol.equals("create-date")) {
            orderByComparator = new ArticleCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("display-date")) {
            orderByComparator = new ArticleDisplayDateComparator(orderByAsc);
        } else if (orderByCol.equals("id")) {
            orderByComparator = new ArticleIDComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new ArticleModifiedDateComparator(orderByAsc);
        } else if (orderByCol.equals("review-date")) {
            orderByComparator = new ArticleReviewDateComparator(orderByAsc);
        } else if (orderByCol.equals("title")) {
            orderByComparator = new ArticleTitleComparator(orderByAsc);
        } else if (orderByCol.equals("version")) {
            orderByComparator = new ArticleVersionComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public static List<BreadcrumbEntry> getPortletBreadcrumbEntries(JournalFolder folder, HttpServletRequest httpServletRequest, PortletURL portletURL) throws Exception {
        ArrayList<BreadcrumbEntry> breadcrumbEntries = new ArrayList<BreadcrumbEntry>();
        BreadcrumbEntry breadcrumbEntry = new BreadcrumbEntry();
        breadcrumbEntry.setTitle(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"home"));
        portletURL.setParameter("folderId", String.valueOf(0L));
        breadcrumbEntry.setURL(portletURL.toString());
        breadcrumbEntries.add(breadcrumbEntry);
        if (folder == null) {
            return breadcrumbEntries;
        }
        List ancestorFolders = folder.getAncestors();
        Collections.reverse(ancestorFolders);
        for (JournalFolder ancestorFolder : ancestorFolders) {
            BreadcrumbEntry folderBreadcrumbEntry = new BreadcrumbEntry();
            folderBreadcrumbEntry.setTitle(ancestorFolder.getName());
            portletURL.setParameter("folderId", String.valueOf(ancestorFolder.getFolderId()));
            folderBreadcrumbEntry.setURL(portletURL.toString());
            breadcrumbEntries.add(folderBreadcrumbEntry);
        }
        if (folder.getFolderId() != 0L) {
            BreadcrumbEntry folderBreadcrumbEntry = new BreadcrumbEntry();
            JournalFolder unescapedFolder = (JournalFolder)folder.toUnescapedModel();
            folderBreadcrumbEntry.setTitle(unescapedFolder.getName());
            portletURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
            folderBreadcrumbEntry.setURL(portletURL.toString());
            breadcrumbEntries.add(folderBreadcrumbEntry);
        }
        return breadcrumbEntries;
    }

    protected static long getAddMenuFavItemFolderId(long folderId) throws PortalException {
        if (folderId <= 0L) {
            return 0L;
        }
        for (JournalFolder folder = JournalFolderLocalServiceUtil.fetchFolder((long)folderId); folder != null; folder = folder.getParentFolder()) {
            int restrictionType = JournalHelperUtil.getRestrictionType(folder.getFolderId());
            if (restrictionType != 1) continue;
            return folder.getFolderId();
        }
        return 0L;
    }
}

