/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.social;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.web.util.JournalResourceBundleLoader;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionHelper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.social.kernel.model.BaseSocialActivityInterpreter;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet"}, service={SocialActivityInterpreter.class})
public class JournalArticleActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{JournalArticle.class.getName()};
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalArticle)")
    private ModelResourcePermission<JournalArticle> _journalArticleModelResourcePermission;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalFolder)")
    private ModelResourcePermission<JournalFolder> _journalFolderModelResourcePermission;
    @Reference
    private Portal _portal;

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        LiferayPortletRequest liferayPortletRequest = serviceContext.getLiferayPortletRequest();
        LiferayPortletResponse liferayPortletResponse = serviceContext.getLiferayPortletResponse();
        if (liferayPortletRequest != null && liferayPortletResponse != null) {
            AssetRendererFactory journalArticleAssetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalArticle.class);
            AssetRenderer journalArticleAssetRenderer = journalArticleAssetRendererFactory.getAssetRenderer(activity.getClassPK());
            return journalArticleAssetRenderer.getURLViewInContext(serviceContext.getLiferayPortletRequest(), serviceContext.getLiferayPortletResponse(), null);
        }
        JournalArticle article = this._journalArticleLocalService.getLatestArticle(activity.getClassPK());
        Layout layout = article.getLayout();
        if (layout != null) {
            String groupFriendlyURL = this._portal.getGroupFriendlyURL(layout.getLayoutSet(), serviceContext.getThemeDisplay());
            return groupFriendlyURL.concat("/-/").concat(article.getUrlTitle());
        }
        return null;
    }

    protected ResourceBundleLoader getResourceBundleLoader() {
        return JournalResourceBundleLoader.INSTANCE;
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) {
        int activityType = activity.getType();
        if (activityType == 1) {
            if (Validator.isNull((String)groupName)) {
                return "activity-journal-article-add-web-content";
            }
            return "activity-journal-article-add-web-content-in";
        }
        if (activityType == 2) {
            if (Validator.isNull((String)groupName)) {
                return "activity-journal-article-update-web-content";
            }
            return "activity-journal-article-update-web-content-in";
        }
        if (activityType == 10007) {
            if (Validator.isNull((String)groupName)) {
                return "activity-journal-article-move-to-trash";
            }
            return "activity-journal-article-move-to-trash-in";
        }
        if (activityType == 10008) {
            if (Validator.isNull((String)groupName)) {
                return "activity-journal-article-restore-from-trash";
            }
            return "activity-journal-article-restore-from-trash-in";
        }
        return null;
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        int activityType = activity.getType();
        if (activityType == 1) {
            JournalArticle article = this._journalArticleLocalService.getLatestArticle(activity.getClassPK());
            return ModelResourcePermissionHelper.contains(this._journalFolderModelResourcePermission, (PermissionChecker)permissionChecker, (long)article.getGroupId(), (long)article.getFolderId(), (String)"ADD_ARTICLE");
        }
        if (activityType == 2) {
            return this._journalArticleModelResourcePermission.contains(permissionChecker, activity.getClassPK(), "UPDATE");
        }
        return this._journalArticleModelResourcePermission.contains(permissionChecker, activity.getClassPK(), actionId);
    }

    @Reference(unbind="-")
    protected void setJournalArticleLocalService(JournalArticleLocalService journalArticleLocalService) {
        this._journalArticleLocalService = journalArticleLocalService;
    }
}

