/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.TemplateVariableDefinition;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;

@Component(service={JournalDDMTemplateUtil.class})
public class JournalDDMTemplateUtil {
    private static final Log _log = LogFactoryUtil.getLog(JournalDDMTemplateUtil.class);

    public String getDataContent(TemplateVariableDefinition templateVariableDefinition, String language) {
        String dataContent = "";
        String dataType = templateVariableDefinition.getDataType();
        if (templateVariableDefinition.isCollection()) {
            TemplateVariableDefinition itemTemplateVariableDefinition = templateVariableDefinition.getItemTemplateVariableDefinition();
            dataContent = this._getListCode(templateVariableDefinition.getName(), itemTemplateVariableDefinition.getName(), itemTemplateVariableDefinition.getAccessor(), language);
        } else if (Validator.isNull((String)dataType)) {
            dataContent = this._getVariableReferenceCode(templateVariableDefinition.getName(), templateVariableDefinition.getAccessor(), language);
        } else if (dataType.equals("service-locator")) {
            Class templateVariableDefinitionClass = templateVariableDefinition.getClazz();
            String variableName = templateVariableDefinitionClass.getSimpleName();
            StringBundler sb = new StringBundler(3);
            sb.append(this._getVariableAssignmentCode(variableName, "serviceLocator.findService(\"" + templateVariableDefinition.getName() + "\")", language));
            sb.append("[$CURSOR$]");
            sb.append(this._getVariableReferenceCode(variableName, null, language));
            dataContent = sb.toString();
        } else {
            try {
                String[] generateCode = templateVariableDefinition.generateCode(language);
                dataContent = generateCode[0];
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return dataContent;
    }

    public String getPaletteItemTitle(HttpServletRequest httpServletRequest, ResourceBundle resourceBundle, TemplateVariableDefinition templateVariableDefinition) {
        StringBundler sb = new StringBundler(12);
        String help = templateVariableDefinition.getHelp();
        if (Validator.isNotNull((String)help)) {
            sb.append("<p>");
            sb.append(HtmlUtil.escape((String)LanguageUtil.get((HttpServletRequest)httpServletRequest, (ResourceBundle)resourceBundle, (String)help)));
            sb.append("</p>");
        }
        if (templateVariableDefinition.isCollection()) {
            sb.append("<p><i>*");
            sb.append(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"this-is-a-collection-of-fields"));
            sb.append("</i></p>");
        } else if (templateVariableDefinition.isRepeatable()) {
            sb.append("<p><i>*");
            sb.append(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"this-is-a-repeatable-field"));
            sb.append("</i></p>");
        }
        if (!Objects.equals(templateVariableDefinition.getDataType(), "service-locator")) {
            sb.append(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"variable"));
            sb.append(":");
            sb.append("&nbsp;");
            sb.append(HtmlUtil.escape((String)templateVariableDefinition.getName()));
        }
        sb.append(this._getPaletteItemTitle(httpServletRequest, "class", templateVariableDefinition.getClazz()));
        if (templateVariableDefinition.isCollection()) {
            TemplateVariableDefinition itemTemplateVariableDefinition = templateVariableDefinition.getItemTemplateVariableDefinition();
            sb.append(this._getPaletteItemTitle(httpServletRequest, "items-class", itemTemplateVariableDefinition.getClazz()));
        }
        return sb.toString();
    }

    private String _getAccessor(String accessor, String language) {
        if (StringUtil.equalsIgnoreCase((String)language, (String)"vm")) {
            if (!accessor.contains("(")) {
                return accessor;
            }
            StringTokenizer st = new StringTokenizer(accessor, "(,");
            StringBundler sb = new StringBundler(st.countTokens() * 2);
            sb.append(st.nextToken());
            sb.append("(");
            while (st.hasMoreTokens()) {
                sb.append("$");
                sb.append(st.nextToken());
            }
            accessor = sb.toString();
        }
        return accessor;
    }

    private String _getListCode(String variableName, String itemName, String accessor, String language) {
        if (StringUtil.equalsIgnoreCase((String)language, (String)"ftl")) {
            StringBundler sb = new StringBundler(9);
            sb.append("<#if ");
            sb.append(variableName);
            sb.append("?has_content>\n\t<#list ");
            sb.append(variableName);
            sb.append(" as ");
            sb.append(itemName);
            sb.append(">\n\t\t");
            sb.append(this._getVariableReferenceCode(itemName, accessor, language));
            sb.append("[$CURSOR$]\n\t</#list>\n</#if>");
            return sb.toString();
        }
        if (StringUtil.equalsIgnoreCase((String)language, (String)"vm")) {
            StringBundler sb = new StringBundler(9);
            sb.append("#if (!$");
            sb.append(variableName);
            sb.append(".isEmpty())\n\t#foreach ($");
            sb.append(itemName);
            sb.append(" in $");
            sb.append(variableName);
            sb.append(")\n\t\t");
            sb.append(this._getVariableReferenceCode(itemName, accessor, language));
            sb.append("[$CURSOR$]#end\n#end");
            return sb.toString();
        }
        return "";
    }

    private String _getPaletteItemTitle(HttpServletRequest httpServletRequest, String label, Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        StringBundler sb = new StringBundler(10);
        String className = clazz.getName();
        sb.append("<br />");
        sb.append(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)label));
        sb.append(":");
        sb.append("&nbsp;");
        String javadocURL = null;
        if (className.startsWith("com.liferay.portal.kernel")) {
            javadocURL = "http://docs.liferay.com/portal/7.0/javadocs/portal-kernel/";
        }
        if (Validator.isNotNull((String)javadocURL)) {
            sb.append("<a href=\"");
            sb.append(javadocURL);
            sb.append(StringUtil.replace((String)className, (char)'.', (char)'/'));
            sb.append(".html\" target=\"_blank\">");
        }
        sb.append(clazz.getSimpleName());
        if (Validator.isNull((String)javadocURL)) {
            sb.append("</a>");
        }
        return sb.toString();
    }

    private String _getVariableAssignmentCode(String variableName, String variableValue, String language) {
        if (StringUtil.equalsIgnoreCase((String)language, (String)"ftl")) {
            return StringBundler.concat((String[])new String[]{"<#assign ", variableName, " = ", variableValue, ">"});
        }
        if (StringUtil.equalsIgnoreCase((String)language, (String)"vm")) {
            if (!(variableValue.startsWith("\"\"") || variableValue.startsWith("[") || variableValue.startsWith("{") || variableValue.startsWith("\"") || Validator.isNumber((String)variableValue))) {
                variableValue = "$" + variableValue;
            }
            return StringBundler.concat((String[])new String[]{"#set ($", variableName, " = ", variableValue, ")"});
        }
        return variableName;
    }

    private String _getVariableReferenceCode(String variableName, String accessor, String language) {
        String methodInvocation = "";
        if (Validator.isNotNull((String)accessor)) {
            methodInvocation = "." + this._getAccessor(accessor, language);
        }
        if (StringUtil.equalsIgnoreCase((String)language, (String)"ftl")) {
            return StringBundler.concat((String[])new String[]{"${", variableName, methodInvocation, "}"});
        }
        if (StringUtil.equalsIgnoreCase((String)language, (String)"vm")) {
            return "$" + variableName + methodInvocation;
        }
        return variableName;
    }
}

