/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.servlet.taglib.util;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.web.internal.security.permission.resource.JournalFolderPermission;
import com.liferay.journal.web.internal.security.permission.resource.JournalPermission;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.workflow.WorkflowEngineManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.StagingGroupHelperUtil;
import com.liferay.taglib.security.PermissionsURLTag;
import com.liferay.trash.TrashHelper;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class JournalFolderActionDropdownItems {
    private static final Log _log = LogFactoryUtil.getLog(JournalFolderActionDropdownItems.class);
    private final JournalFolder _folder;
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private String _redirect;
    private final ThemeDisplay _themeDisplay;
    private final TrashHelper _trashHelper;

    public JournalFolderActionDropdownItems(JournalFolder folder, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, TrashHelper trashHelper) {
        this._folder = folder;
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._trashHelper = trashHelper;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)liferayPortletRequest);
        this._themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() throws Exception {
        return new DropdownItemList(){
            {
                if (JournalFolderPermission.contains(JournalFolderActionDropdownItems.this._themeDisplay.getPermissionChecker(), JournalFolderActionDropdownItems.this._folder, "UPDATE")) {
                    this.add(JournalFolderActionDropdownItems.this._getEditFolderActionUnsafeConsumer());
                }
                if (JournalFolderPermission.contains(JournalFolderActionDropdownItems.this._themeDisplay.getPermissionChecker(), JournalFolderActionDropdownItems.this._folder, "UPDATE")) {
                    this.add(JournalFolderActionDropdownItems.this._getMoveFolderActionUnsafeConsumer());
                }
                if (JournalFolderPermission.contains(JournalFolderActionDropdownItems.this._themeDisplay.getPermissionChecker(), JournalFolderActionDropdownItems.this._folder, "PERMISSIONS")) {
                    this.add(JournalFolderActionDropdownItems.this._getPermissionsFolderActionUnsafeConsumer());
                }
                if (JournalFolderPermission.contains(JournalFolderActionDropdownItems.this._themeDisplay.getPermissionChecker(), JournalFolderActionDropdownItems.this._folder, "DELETE")) {
                    this.add(JournalFolderActionDropdownItems.this._getDeleteFolderActionUnsafeConsumer());
                }
                Group group = JournalFolderActionDropdownItems.this._themeDisplay.getScopeGroup();
                if (JournalFolderActionDropdownItems.this._isShowPublishFolderAction() && !group.isLayout()) {
                    this.add(JournalFolderActionDropdownItems.this._getPublishToLiveFolderActionUnsafeConsumer());
                }
            }
        };
    }

    public List<DropdownItem> getInfoPanelActionDropdownItems() throws Exception {
        if (this._folder != null) {
            List<DropdownItem> actionDropdownItems = this.getActionDropdownItems();
            if (JournalFolderPermission.contains(this._themeDisplay.getPermissionChecker(), this._folder, "ADD_FOLDER")) {
                DropdownItem dropdownItem = new DropdownItem();
                dropdownItem.setHref(this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_folder.jsp", "redirect", this._getRedirect(), "groupId", this._folder.getGroupId(), "parentFolderId", this._folder.getFolderId()});
                dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"add-subfolder"));
                actionDropdownItems.add(0, dropdownItem);
            }
            return actionDropdownItems;
        }
        return new DropdownItemList(){
            {
                if (JournalPermission.contains(JournalFolderActionDropdownItems.this._themeDisplay.getPermissionChecker(), JournalFolderActionDropdownItems.this._themeDisplay.getScopeGroupId(), "ADD_FOLDER")) {
                    this.add(JournalFolderActionDropdownItems.this._getAddHomeFolderActionUnsafeConsumer());
                }
                boolean workflowEnabled = false;
                if (WorkflowEngineManagerUtil.isDeployed() && WorkflowHandlerRegistryUtil.getWorkflowHandler((String)JournalArticle.class.getName()) != null) {
                    workflowEnabled = true;
                }
                if (workflowEnabled && JournalFolderPermission.contains(JournalFolderActionDropdownItems.this._themeDisplay.getPermissionChecker(), JournalFolderActionDropdownItems.this._themeDisplay.getScopeGroupId(), 0L, "UPDATE")) {
                    this.add(JournalFolderActionDropdownItems.this._getEditHomeFolderActionUnsafeConsumer());
                }
                if (JournalPermission.contains(JournalFolderActionDropdownItems.this._themeDisplay.getPermissionChecker(), JournalFolderActionDropdownItems.this._themeDisplay.getScopeGroupId(), "PERMISSIONS")) {
                    this.add(JournalFolderActionDropdownItems.this._getPermissionsHomeFolderActionUnsafeConsumer());
                }
                Group group = JournalFolderActionDropdownItems.this._themeDisplay.getScopeGroup();
                if (JournalFolderActionDropdownItems.this._isShowPublishFolderAction() && !group.isLayout()) {
                    this.add(JournalFolderActionDropdownItems.this._getPublishToLiveFolderActionUnsafeConsumer());
                }
            }
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getAddHomeFolderActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_folder.jsp", "redirect", this._getRedirect(), "groupId", this._themeDisplay.getScopeGroupId(), "parentFolderId", 0L});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"add-folder"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getDeleteFolderActionUnsafeConsumer() throws PortalException {
        String redirect = this._getRedirect();
        long currentFolderId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"folderId");
        if (currentFolderId == this._folder.getFolderId()) {
            PortletURL redirectURL = this._liferayPortletResponse.createRenderURL();
            redirectURL.setParameter("groupId", String.valueOf(this._folder.getGroupId()));
            redirectURL.setParameter("folderId", String.valueOf(this._folder.getParentFolderId()));
            redirect = redirectURL.toString();
        }
        PortletURL deleteURL = this._liferayPortletResponse.createActionURL();
        String actionName = "deleteFolder";
        String key = "delete";
        if (this._trashHelper.isTrashEnabled(this._themeDisplay.getScopeGroupId())) {
            actionName = "moveFolderToTrash";
            key = "move-to-recycle-bin";
        }
        deleteURL.setParameter("javax.portlet.action", actionName);
        deleteURL.setParameter("redirect", redirect);
        deleteURL.setParameter("groupId", String.valueOf(this._folder.getGroupId()));
        deleteURL.setParameter("folderId", String.valueOf(this._folder.getFolderId()));
        String label = LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)key);
        return dropdownItem -> {
            dropdownItem.putData("action", "delete");
            dropdownItem.putData("deleteURL", deleteURL.toString());
            dropdownItem.setLabel(label);
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getEditFolderActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_folder.jsp", "redirect", this._getRedirect(), "groupId", this._folder.getGroupId(), "folderId", this._folder.getFolderId()});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"edit"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getEditHomeFolderActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_folder.jsp", "redirect", this._getRedirect(), "groupId", this._themeDisplay.getScopeGroupId(), "folderId", 0L, "rootFolder", true});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"edit"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getMoveFolderActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcPath", "/move_entries.jsp", "redirect", this._getRedirect(), "rowIdsJournalFolder", this._folder.getFolderId()});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"move"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getPermissionsFolderActionUnsafeConsumer() throws Exception {
        String permissionsURL = PermissionsURLTag.doTag((String)"", (String)JournalFolder.class.getName(), (String)this._folder.getName(), null, (String)String.valueOf(this._folder.getPrimaryKey()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._httpServletRequest);
        return dropdownItem -> {
            dropdownItem.putData("action", "permissions");
            dropdownItem.putData("permissionsURL", permissionsURL);
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"permissions"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getPermissionsHomeFolderActionUnsafeConsumer() throws Exception {
        String permissionsURL = PermissionsURLTag.doTag((String)"", (String)"com.liferay.journal", (String)this._themeDisplay.getScopeGroupName(), null, (String)String.valueOf(this._themeDisplay.getScopeGroupId()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._httpServletRequest);
        return dropdownItem -> {
            dropdownItem.putData("action", "permissions");
            dropdownItem.putData("permissionsURL", permissionsURL);
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"permissions"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getPublishToLiveFolderActionUnsafeConsumer() {
        PortletURL publishFolderURL = this._liferayPortletResponse.createActionURL();
        publishFolderURL.setParameter("javax.portlet.action", "/journal/publish_folder");
        publishFolderURL.setParameter("backURL", this._getRedirect());
        publishFolderURL.setParameter("folderId", String.valueOf(this._folder.getFolderId()));
        return dropdownItem -> {
            dropdownItem.putData("action", "publishToLive");
            dropdownItem.putData("publishFolderURL", publishFolderURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"publish-to-live"));
        };
    }

    private String _getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"redirect", (String)this._themeDisplay.getURLCurrent());
        return this._redirect;
    }

    private boolean _isShowPublishAction() {
        PermissionChecker permissionChecker = this._themeDisplay.getPermissionChecker();
        long scopeGroupId = this._themeDisplay.getScopeGroupId();
        StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
        try {
            return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"EXPORT_IMPORT_PORTLET_INFO") && stagingGroupHelper.isStagingGroup(scopeGroupId) && stagingGroupHelper.isStagedPortlet(scopeGroupId, "com_liferay_journal_web_portlet_JournalPortlet");
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"An exception occured when checking if the publish action should be displayed", (Throwable)pe);
            }
            return false;
        }
    }

    private boolean _isShowPublishFolderAction() {
        if (this._folder == null) {
            return false;
        }
        return this._isShowPublishAction();
    }
}

