/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.servlet.taglib.util;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.journal.web.internal.security.permission.resource.DDMTemplatePermission;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.taglib.security.PermissionsURLTag;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class JournalDDMTemplateActionDropdownItemsProvider {
    private final DDMTemplate _ddmTemplate;
    private final HttpServletRequest _httpServletRequest;
    private final RenderResponse _renderResponse;
    private final ThemeDisplay _themeDisplay;

    public JournalDDMTemplateActionDropdownItemsProvider(DDMTemplate ddmTemplate, RenderRequest renderRequest, RenderResponse renderResponse) {
        this._ddmTemplate = ddmTemplate;
        this._renderResponse = renderResponse;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() throws Exception {
        return new DropdownItemList(){
            {
                Group scopeGroup;
                if (DDMTemplatePermission.contains(JournalDDMTemplateActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalDDMTemplateActionDropdownItemsProvider.this._ddmTemplate, "UPDATE")) {
                    this.add(JournalDDMTemplateActionDropdownItemsProvider.this._getEditDDMTemplateActionUnsafeConsumer());
                }
                if (DDMTemplatePermission.contains(JournalDDMTemplateActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalDDMTemplateActionDropdownItemsProvider.this._ddmTemplate, "PERMISSIONS")) {
                    this.add(JournalDDMTemplateActionDropdownItemsProvider.this._getPermissionsDDMTemplateActionUnsafeConsumer());
                }
                if ((!(scopeGroup = JournalDDMTemplateActionDropdownItemsProvider.this._themeDisplay.getScopeGroup()).hasLocalOrRemoteStagingGroup() || scopeGroup.isStagingGroup()) && DDMTemplatePermission.containsAddTemplatePermission(JournalDDMTemplateActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalDDMTemplateActionDropdownItemsProvider.this._themeDisplay.getScopeGroupId(), JournalDDMTemplateActionDropdownItemsProvider.this._ddmTemplate.getClassNameId(), JournalDDMTemplateActionDropdownItemsProvider.this._ddmTemplate.getResourceClassNameId())) {
                    this.add(JournalDDMTemplateActionDropdownItemsProvider.this._getCopyDDMTemplateActionUnsafeConsumer());
                }
                if (DDMTemplatePermission.contains(JournalDDMTemplateActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalDDMTemplateActionDropdownItemsProvider.this._ddmTemplate, "DELETE")) {
                    this.add(JournalDDMTemplateActionDropdownItemsProvider.this._getDeleteDDMTemplateActionUnsafeConsumer());
                }
            }
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getCopyDDMTemplateActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._renderResponse.createRenderURL(), new Object[]{"mvcPath", "/copy_ddm_template.jsp", "redirect", this._themeDisplay.getURLCurrent(), "ddmTemplateId", this._ddmTemplate.getTemplateId()});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"copy"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getDeleteDDMTemplateActionUnsafeConsumer() {
        PortletURL deleteDDMTemplateURL = this._renderResponse.createActionURL();
        deleteDDMTemplateURL.setParameter("javax.portlet.action", "/journal/delete_ddm_template");
        deleteDDMTemplateURL.setParameter("mvcPath", "/view_ddm_templates.jsp");
        deleteDDMTemplateURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        deleteDDMTemplateURL.setParameter("ddmTemplateId", String.valueOf(this._ddmTemplate.getTemplateId()));
        return dropdownItem -> {
            dropdownItem.putData("action", "deleteDDMTemplate");
            dropdownItem.putData("deleteDDMTemplateURL", deleteDDMTemplateURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"delete"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getEditDDMTemplateActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._renderResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_ddm_template.jsp", "redirect", this._themeDisplay.getURLCurrent(), "ddmTemplateId", this._ddmTemplate.getTemplateId()});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"edit"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getPermissionsDDMTemplateActionUnsafeConsumer() throws Exception {
        String permissionsDDMTemplateURL = PermissionsURLTag.doTag((String)"", (String)DDMTemplatePermission.getTemplateModelResourceName(this._ddmTemplate.getResourceClassNameId()), (String)this._ddmTemplate.getName(this._themeDisplay.getLocale()), null, (String)String.valueOf(this._ddmTemplate.getTemplateId()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._httpServletRequest);
        return dropdownItem -> {
            dropdownItem.putData("action", "permissionsDDMTemplate");
            dropdownItem.putData("permissionsDDMTemplateURL", permissionsDDMTemplateURL);
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"permissions"));
        };
    }
}

